/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.file;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Syncable;
import com.sun.media.datasink.BasicDataSink;
import com.sun.media.datasink.RandomAccess;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12DeleteFileAction;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Control;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class Handler
extends BasicDataSink
implements SourceTransferHandler,
Seekable,
Runnable,
RandomAccess,
Syncable {
    private static final boolean DEBUG = false;
    protected static final int NOT_INITIALIZED = 0;
    protected static final int OPENED = 1;
    protected static final int STARTED = 2;
    protected static final int CLOSED = 3;
    protected int state = 0;
    protected DataSource source;
    protected SourceStream[] streams;
    protected SourceStream stream;
    protected boolean push;
    protected boolean errorEncountered = false;
    protected String errorReason = null;
    protected Control[] controls;
    protected File file;
    protected File tempFile = null;
    protected RandomAccessFile raFile = null;
    protected RandomAccessFile qtStrRaFile = null;
    protected boolean fileClosed = false;
    protected FileDescriptor fileDescriptor = null;
    protected MediaLocator locator = null;
    protected String contentType = null;
    protected int fileSize = 0;
    protected int filePointer = 0;
    protected int bytesWritten = 0;
    protected static final int BUFFER_LEN = 131072;
    protected boolean syncEnabled = false;
    protected byte[] buffer1 = new byte[131072];
    protected byte[] buffer2 = new byte[131072];
    protected boolean buffer1Pending = false;
    protected long buffer1PendingLocation = -1L;
    protected int buffer1Length;
    protected boolean buffer2Pending = false;
    protected long buffer2PendingLocation = -1L;
    protected int buffer2Length;
    protected long nextLocation = 0L;
    protected Thread writeThread = null;
    private Integer bufferLock = new Integer(0);
    private boolean receivedEOS = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    public int WRITE_CHUNK_SIZE = 16384;
    private boolean streamingEnabled = false;
    private boolean errorCreatingStreamingFile = false;
    long lastSyncTime = -1L;

    public void setSource(DataSource dataSource) throws IncompatibleSourceException {
        if (!(dataSource instanceof PushDataSource) && !(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException("Incompatible datasource");
        }
        this.source = dataSource;
        if (this.source instanceof PushDataSource) {
            this.push = true;
            try {
                ((PushDataSource)this.source).connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streams = ((PushDataSource)this.source).getStreams();
        } else {
            this.push = false;
            try {
                ((PullDataSource)this.source).connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.streams = ((PullDataSource)this.source).getStreams();
        }
        if (this.streams == null || this.streams.length != 1) {
            throw new IncompatibleSourceException("DataSource should have 1 stream");
        }
        this.stream = this.streams[0];
        this.contentType = this.source.getContentType();
        if (this.push) {
            ((PushSourceStream)this.stream).setTransferHandler(this);
        }
    }

    public void setOutputLocator(MediaLocator mediaLocator) {
        this.locator = mediaLocator;
    }

    public void setEnabled(boolean bl) {
        this.streamingEnabled = bl;
    }

    public void setSyncEnabled() {
        this.syncEnabled = true;
    }

    public boolean write(long l2, int n2) {
        try {
            if (l2 >= 0L && n2 > 0) {
                int n3 = n2;
                this.raFile.seek(l2);
                while (n3 > 0) {
                    int n4 = n3 > 131072 ? 131072 : n3;
                    this.raFile.read(this.buffer1, 0, n4);
                    this.qtStrRaFile.write(this.buffer1, 0, n4);
                    n3 -= n4;
                }
            } else if (l2 < 0L && n2 > 0) {
                this.qtStrRaFile.seek(0L);
                this.qtStrRaFile.seek(n2 - 1);
                this.qtStrRaFile.writeByte(0);
                this.qtStrRaFile.seek(0L);
            } else {
                this.sendEndofStreamEvent();
            }
        }
        catch (Exception exception) {
            this.errorCreatingStreamingFile = true;
            System.err.println("Exception when creating streamable version of media file: " + exception.getMessage());
            return false;
        }
        return true;
    }

    public void open() throws IOException, SecurityException {
        try {
            if (this.state == 0 && this.locator != null) {
                String string;
                String string2 = this.locator.getRemainder();
                while (string2.charAt(0) == '/' && (string2.charAt(1) == '/' || string2.charAt(2) == ':')) {
                    string2 = string2.substring(1);
                }
                String string3 = System.getProperty("file.separator");
                if (string3.equals("\\")) {
                    string2 = string2.replace('/', '\\');
                }
                JMFSecurityManager.checkFileSave();
                if (securityPrivelege && jmfSecurity != null) {
                    string = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            string = "read file";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            string = "write file";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 4);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                        }
                    }
                    catch (Exception exception) {
                        securityPrivelege = false;
                        if (this.push) {
                            ((PushSourceStream)this.stream).setTransferHandler(null);
                        }
                        throw new SecurityException(exception.getMessage());
                    }
                    catch (Error error) {
                        securityPrivelege = false;
                        if (this.push) {
                            ((PushSourceStream)this.stream).setTransferHandler(null);
                        }
                        throw new SecurityException(error.getMessage());
                    }
                }
                if (!securityPrivelege) {
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw new IOException("Datasink: Unable to get security privileges for file writing");
                }
                this.file = new File(string2);
                if (this.file.exists() && !this.deleteFile(this.file)) {
                    System.err.println("datasink open: Existing file " + string2 + " cannot be deleted. Check if " + "some other process is using " + " this file");
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw new IOException("Existing file " + string2 + " cannot be deleted");
                }
                string = this.file.getParent();
                if (string != null) {
                    new File(string).mkdirs();
                }
                try {
                    if (!this.streamingEnabled) {
                        this.raFile = new RandomAccessFile(this.file, "rw");
                        this.fileDescriptor = this.raFile.getFD();
                    } else {
                        int n2 = string2.lastIndexOf(".");
                        String string4 = n2 > 0 ? string2.substring(0, n2) + ".nonstreamable" + string2.substring(n2, string2.length()) : this.file + ".nonstreamable.mov";
                        this.tempFile = new File(string4);
                        this.raFile = new RandomAccessFile(this.tempFile, "rw");
                        this.fileDescriptor = this.raFile.getFD();
                        this.qtStrRaFile = new RandomAccessFile(this.file, "rw");
                    }
                }
                catch (IOException iOException) {
                    System.err.println("datasink open: IOException when creating RandomAccessFile " + string2 + " : " + iOException);
                    if (this.push) {
                        ((PushSourceStream)this.stream).setTransferHandler(null);
                    }
                    throw iOException;
                }
                this.setState(1);
            }
            Object var7_9 = null;
            if (this.state == 0 && this.stream != null) {
                ((PushSourceStream)this.stream).setTransferHandler(null);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (this.state == 0 && this.stream != null) {
                ((PushSourceStream)this.stream).setTransferHandler(null);
            }
            throw throwable;
        }
    }

    public MediaLocator getOutputLocator() {
        return this.locator;
    }

    public void start() throws IOException {
        if (this.state == 1) {
            if (this.source != null) {
                this.source.start();
            }
            if (this.writeThread == null) {
                this.writeThread = new Thread(this);
                this.writeThread.start();
            }
            this.setState(2);
        }
    }

    public void stop() throws IOException {
        if (this.state == 2) {
            if (this.source != null) {
                this.source.stop();
            }
            this.setState(1);
        }
    }

    protected void setState(int n2) {
        Handler handler = this;
        synchronized (handler) {
            this.state = n2;
        }
    }

    public void close() {
        this.close(null);
    }

    protected final void close(String string) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 3) {
                return;
            }
            this.setState(3);
        }
        if (this.push) {
            int n2 = 0;
            while (n2 < this.streams.length) {
                ((PushSourceStream)this.streams[n2]).setTransferHandler(null);
                ++n2;
            }
        }
        if (string != null) {
            this.errorEncountered = true;
            this.sendDataSinkErrorEvent(string);
            Integer n3 = this.bufferLock;
            synchronized (n3) {
                this.bufferLock.notifyAll();
            }
        }
        try {
            this.source.stop();
        }
        catch (IOException iOException) {
            System.err.println("IOException when stopping source " + iOException);
        }
        try {
            if (this.raFile != null) {
                this.raFile.close();
            }
            if (this.streamingEnabled && this.qtStrRaFile != null) {
                this.qtStrRaFile.close();
            }
            if (this.source != null) {
                this.source.disconnect();
            }
            if (this.streamingEnabled && this.tempFile != null) {
                if (!this.errorCreatingStreamingFile) {
                    boolean bl = this.deleteFile(this.tempFile);
                } else {
                    boolean bl = this.deleteFile(this.file);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("close: " + iOException);
        }
        this.raFile = null;
        this.qtStrRaFile = null;
        this.removeAllListeners();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[0];
        }
        return this.controls;
    }

    public Object getControl(String string) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void transferData(PushSourceStream pushSourceStream) {
        Integer n2;
        int n3 = 0;
        int n4 = 131072;
        int n5 = 0;
        if (this.errorEncountered) {
            return;
        }
        if (this.buffer1Pending) {
            n2 = this.bufferLock;
            synchronized (n2) {
                while (this.buffer1Pending) {
                    try {
                        this.bufferLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        while (n4 > 0) {
            block20: {
                try {
                    n5 = pushSourceStream.read(this.buffer1, n3, n4);
                    if (n5 <= 16384 || this.WRITE_CHUNK_SIZE >= 32768) break block20;
                    if (n5 > 65536 && this.WRITE_CHUNK_SIZE < 131072) {
                        this.WRITE_CHUNK_SIZE = 131072;
                        break block20;
                    }
                    if (n5 > 32768 && this.WRITE_CHUNK_SIZE < 65536) {
                        this.WRITE_CHUNK_SIZE = 65536;
                        break block20;
                    }
                    if (this.WRITE_CHUNK_SIZE < 32768) {
                        this.WRITE_CHUNK_SIZE = 32768;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (n5 <= 0) break;
            n3 += n5;
            n4 -= n5;
        }
        if (n3 > 0) {
            n2 = this.bufferLock;
            synchronized (n2) {
                this.buffer1Pending = true;
                this.buffer1PendingLocation = this.nextLocation;
                this.buffer1Length = n3;
                this.nextLocation = -1L;
                this.bufferLock.notifyAll();
            }
        }
        if (n5 == -1) {
            this.receivedEOS = true;
            while (!this.fileClosed && !this.errorEncountered && this.state != 3) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (this.state != 3 && !this.errorEncountered) {
            Integer n2 = this.bufferLock;
            // MONITORENTER : n2
            while (!(this.buffer1Pending || this.buffer2Pending || this.errorEncountered || this.state == 3 || this.receivedEOS)) {
                try {
                    this.bufferLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : n2
            if (this.buffer2Pending) {
                this.write(this.buffer2, this.buffer2PendingLocation, this.buffer2Length);
                this.buffer2Pending = false;
            }
            Integer n3 = this.bufferLock;
            // MONITORENTER : n3
            if (this.buffer1Pending) {
                byte[] byArray = this.buffer2;
                this.buffer2 = this.buffer1;
                this.buffer2Pending = true;
                this.buffer2PendingLocation = this.buffer1PendingLocation;
                this.buffer2Length = this.buffer1Length;
                this.buffer1Pending = false;
                this.buffer1 = byArray;
                this.bufferLock.notifyAll();
            } else if (this.receivedEOS) {
                // MONITOREXIT : n3
                break;
            }
            // MONITOREXIT : n3
        }
        if (this.receivedEOS) {
            if (this.raFile != null) {
                if (!this.streamingEnabled) {
                    try {
                        this.raFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.raFile = null;
                }
                this.fileClosed = true;
            }
            if (!this.streamingEnabled) {
                this.sendEndofStreamEvent();
            }
        }
        if (!this.errorEncountered) return;
        if (this.state == 3) return;
        this.close(this.errorReason);
    }

    public synchronized long seek(long l2) {
        this.nextLocation = l2;
        return l2;
    }

    private void write(byte[] byArray, long l2, int n2) {
        try {
            if (l2 != -1L) {
                this.doSeek(l2);
            }
            int n3 = 0;
            while (n2 > 0) {
                int n4 = this.WRITE_CHUNK_SIZE;
                if (n2 < n4) {
                    n4 = n2;
                }
                this.raFile.write(byArray, n3, n4);
                this.bytesWritten += n4;
                if (this.fileDescriptor != null && this.syncEnabled && this.bytesWritten >= this.WRITE_CHUNK_SIZE) {
                    this.bytesWritten -= this.WRITE_CHUNK_SIZE;
                    this.fileDescriptor.sync();
                }
                this.filePointer += n4;
                n2 -= n4;
                n3 += n4;
                if (this.filePointer > this.fileSize) {
                    this.fileSize = this.filePointer;
                }
                Thread.yield();
            }
        }
        catch (IOException iOException) {
            this.errorEncountered = true;
            this.errorReason = iOException.toString();
        }
    }

    public long doSeek(long l2) {
        if (this.raFile != null) {
            try {
                this.raFile.seek(l2);
                this.filePointer = (int)l2;
                return l2;
            }
            catch (IOException iOException) {
                this.close("Error in seek: " + iOException);
            }
        }
        return -1L;
    }

    public long tell() {
        return this.nextLocation;
    }

    public long doTell() {
        if (this.raFile != null) {
            try {
                return this.raFile.getFilePointer();
            }
            catch (IOException iOException) {
                this.close("Error in tell: " + iOException);
            }
        }
        return -1L;
    }

    public boolean isRandomAccess() {
        return true;
    }

    private boolean deleteFile(File file) {
        boolean bl = false;
        try {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 8);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                    }
                }
                catch (Exception exception) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12DeleteFileAction.cons;
                Boolean bl2 = (Boolean)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(file));
                bl = bl2;
            } else {
                bl = file.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

