/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class AUMux
extends BasicMux {
    private static final int HEADER_SIZE = 24;
    private static final int UNKNOWN_ENCODING = -1;
    private AudioFormat audioFormat;
    private int sampleSizeInBits;
    private int encoding;
    private double sampleRate;
    private int channels;
    private static final int AU_SUN_MAGIC = 779316836;
    private static final int AU_ULAW_8 = 1;
    private static final int AU_ALAW_8 = 27;
    private static final int AU_LINEAR_8 = 2;
    private static final int AU_LINEAR_16 = 3;
    private static final int AU_LINEAR_24 = 4;
    private static final int AU_LINEAR_32 = 5;
    private static final int AU_FLOAT = 6;
    private static final int AU_DOUBLE = 7;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, 1);

    public AUMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.basic");
    }

    public String getName() {
        return "Basic Audio Multiplexer";
    }

    public int setNumTracks(int n2) {
        if (n2 != 1) {
            return 1;
        }
        return super.setNumTracks(n2);
    }

    protected void writeHeader() {
        this.bufClear();
        this.bufWriteInt(779316836);
        this.bufWriteInt(24);
        this.bufWriteInt(-1);
        this.bufWriteInt(this.encoding);
        this.bufWriteInt((int)this.sampleRate);
        this.bufWriteInt(this.channels);
        this.bufFlush();
    }

    public Format setInputFormat(Format format, int n2) {
        String string = null;
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.audioFormat = (AudioFormat)format;
        String string2 = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        if (string2.equalsIgnoreCase("LINEAR")) {
            if (this.sampleSizeInBits > 8 && this.audioFormat.getEndian() == 0) {
                return null;
            }
            if (this.audioFormat.getSigned() == 0) {
                return null;
            }
            if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                this.audioFormat = (AudioFormat)this.audioFormat.intersects(this.bigEndian);
            }
        }
        this.encoding = this.getEncoding(string2, this.sampleSizeInBits);
        if (this.encoding == -1) {
            string = "No support for encoding " + string2;
        }
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        if (string == null) {
            return this.audioFormat;
        }
        return null;
    }

    protected void writeFooter() {
        this.seek(8);
        this.bufClear();
        this.bufWriteInt(this.fileSize - 24);
        this.bufFlush();
    }

    private int getEncoding(String string, int n2) {
        if (string.equalsIgnoreCase("ULAW")) {
            return 1;
        }
        if (string.equalsIgnoreCase("alaw")) {
            return 27;
        }
        if (string.equalsIgnoreCase("LINEAR")) {
            if (n2 == 8) {
                return 2;
            }
            if (n2 == 16) {
                return 3;
            }
            if (n2 == 24) {
                return 4;
            }
            if (n2 == 32) {
                return 5;
            }
            return -1;
        }
        if (string.equalsIgnoreCase("float")) {
            return 6;
        }
        if (string.equalsIgnoreCase("double")) {
            return 7;
        }
        return -1;
    }
}

