/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class AiffParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format = null;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize = -1;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private PullSourceStream stream = null;
    private int maxFrame;
    private int blockSize = 0;
    private double sampleRate = -1.0;
    private long minLocation;
    private long maxLocation;
    private String encodingString = null;
    private int samplesPerBlock = 1;
    private double timePerBlockNano = -1.0;
    private double locationToMediaTime = -1.0;
    public static final String FormID = "FORM";
    public static final String FormatVersionID = "FVER";
    public static final String CommonID = "COMM";
    public static final String SoundDataID = "SSND";
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_aiff")};
    public static final int CommonIDSize = 18;
    private boolean isAIFC = false;
    private boolean commonChunkSeen = false;
    private boolean soundDataChunkSeen = false;
    private boolean formatVersionChunkSeen = false;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.tracks[0] = new AiffTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        boolean bl = true;
        String string = this.readString(this.stream);
        if (!string.equals(FormID)) {
            throw new BadHeaderException("AIFF Parser: expected string FORM, got " + string);
        }
        int n2 = this.readInt(this.stream) + 8;
        String string2 = this.readString(this.stream);
        if (string2.equals("AIFC")) {
            this.isAIFC = true;
        } else {
            this.encodingString = "LINEAR";
        }
        int n3 = n2 - 12;
        String string3 = null;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        while (n3 >= 8) {
            int n7;
            String string4 = this.readString(this.stream);
            int n8 = this.readInt(this.stream);
            n3 -= 8;
            if (string4.equals(FormatVersionID)) {
                if (!this.isAIFC) {
                    // empty if block
                }
                n7 = this.readInt(this.stream);
                if (n8 != 4) {
                    throw new BadHeaderException("Illegal FormatVersionID: chunk size is not 4 but " + n8);
                }
                this.formatVersionChunkSeen = true;
            } else if (string4.equals(CommonID)) {
                if (n8 < 18) {
                    throw new BadHeaderException("Size of COMM chunk should be atleast 18");
                }
                n5 = this.readShort(this.stream);
                if (n5 < 1) {
                    throw new BadHeaderException("Number of channels is " + n5);
                }
                this.maxFrame = this.readInt(this.stream);
                n6 = this.readShort(this.stream);
                if (n6 <= 0) {
                    throw new BadHeaderException("Illegal sampleSize " + n6);
                }
                this.sampleRate = this.readIeeeExtended(this.stream);
                if (this.sampleRate < 0.0) {
                    throw new BadHeaderException("Negative Sample Rate " + this.sampleRate);
                }
                n7 = n8 - 18;
                if (this.isAIFC) {
                    if (n7 < 4) {
                        throw new BadHeaderException("COMM chunk in AIFC doesn't have compressionType info");
                    }
                    string3 = this.readString(this.stream);
                    if (string3 == null) {
                        throw new BadHeaderException("Compression type for AIFC is null");
                    }
                    this.skip(this.stream, n7 - 4);
                }
                this.commonChunkSeen = true;
            } else if (string4.equals(SoundDataID)) {
                if (this.soundDataChunkSeen) {
                    throw new BadHeaderException("Cannot have more than 1 Sound Data Chunk");
                }
                n4 = this.readInt(this.stream);
                this.blockSize = this.readInt(this.stream);
                this.minLocation = this.getLocation(this.stream);
                this.dataSize = n8 - 8;
                this.maxLocation = this.minLocation + (long)this.dataSize;
                this.soundDataChunkSeen = true;
                if (this.commonChunkSeen) {
                    n3 -= 8;
                    break;
                }
                this.skip(this.stream, n8 - 8);
            } else {
                this.skip(this.stream, n8);
            }
            n3 -= n8;
        }
        if (!this.commonChunkSeen) {
            throw new BadHeaderException("Mandatory chunk COMM missing");
        }
        if (!this.soundDataChunkSeen) {
            throw new BadHeaderException("Mandatory chunk SSND missing");
        }
        double d2 = -1.0;
        if (this.isAIFC) {
            String string5 = string3;
            if (string5.equalsIgnoreCase("NONE")) {
                this.encodingString = "LINEAR";
            } else if (string5.equalsIgnoreCase("twos")) {
                this.encodingString = "LINEAR";
            } else if (string5.equalsIgnoreCase("raw")) {
                this.encodingString = "LINEAR";
                bl = false;
            } else if (string5.equalsIgnoreCase("ULAW")) {
                this.encodingString = "ULAW";
                n6 = 8;
                bl = false;
            } else if (string5.equalsIgnoreCase("ALAW")) {
                this.encodingString = "alaw";
                n6 = 8;
                bl = false;
            } else if (string5.equalsIgnoreCase("G723")) {
                this.encodingString = "g723";
            } else if (string5.equalsIgnoreCase("MAC3")) {
                this.encodingString = "MAC3";
                this.blockSize = 2;
                this.samplesPerBlock = 6;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else if (string5.equalsIgnoreCase("MAC6")) {
                this.encodingString = "MAC6";
                this.blockSize = 1;
                this.samplesPerBlock = 6;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else if (string5.equalsIgnoreCase("IMA4")) {
                this.encodingString = "ima4";
                this.blockSize = 34 * n5;
                this.samplesPerBlock = 64;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else {
                throw new BadHeaderException("Unsupported encoding" + string5);
            }
        }
        if (this.blockSize == 0) {
            this.blockSize = n5 * n6 / 8;
        }
        this.bufferSize = this.blockSize * (int)(this.sampleRate / (double)this.samplesPerBlock);
        d2 = (double)(this.maxFrame * this.samplesPerBlock) / this.sampleRate;
        if (d2 > 0.0) {
            this.duration = new Time(d2);
        }
        this.locationToMediaTime = (double)this.samplesPerBlock / (this.sampleRate * (double)this.blockSize);
        this.format = new AudioFormat(this.encodingString, this.sampleRate, n6, n5, 1, bl ? 1 : 0, this.blockSize * 8, -1.0, Format.byteArray);
    }

    public Time setPosition(Time time, int n2) {
        long l2;
        if (!this.seekable) {
            return this.getMediaTime();
        }
        long l3 = time.getNanoseconds();
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (this.timePerBlockNano == -1.0) {
            int n3 = (int)this.sampleRate * this.blockSize;
            double d2 = (double)l3 * this.sampleRate * (double)this.blockSize / 1.0E9;
            double d3 = d2 % (double)this.blockSize;
            l2 = (long)(d2 - d3);
            if (d3 > 0.0) {
                switch (n2) {
                    case 1: {
                        l2 += (long)this.blockSize;
                        break;
                    }
                    case 3: {
                        if (!(d3 > (double)this.blockSize / 2.0)) break;
                        l2 += (long)this.blockSize;
                    }
                }
            }
        } else {
            double d4 = (double)l3 / this.timePerBlockNano;
            int n4 = (int)d4;
            double d5 = d4 - (double)n4;
            if (d5 > 0.0) {
                switch (n2) {
                    case 1: {
                        ++n4;
                        break;
                    }
                    case 3: {
                        if (!(d5 > 0.5)) break;
                        ++n4;
                    }
                }
            }
            l2 = n4 * this.blockSize;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(l2 += this.minLocation);
        if (this.cacheStream != null) {
            AiffParser aiffParser = this;
            synchronized (aiffParser) {
                this.cacheStream.abortRead();
            }
        }
        return time;
    }

    public Time getMediaTime() {
        long l2 = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long l3 = l2 != -1L ? l2 - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)l3 * this.locationToMediaTime);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        long l2;
        if (this.maxFrame <= 0 && this.tracks[0] != null && (l2 = ((BasicTrack)this.tracks[0]).getMediaSizeAtEOM()) > 0L) {
            this.maxFrame = (int)(l2 / (long)this.blockSize);
            double d2 = (double)(this.maxFrame * this.samplesPerBlock) / this.sampleRate;
            if (d2 > 0.0) {
                this.duration = new Time(d2);
            }
        }
        return this.duration;
    }

    public String getName() {
        return "Parser for AIFF file format";
    }

    private double readIeeeExtended(PullSourceStream pullSourceStream) throws IOException {
        double d2 = 0.0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        double d3 = 3.4028234663852886E38;
        n2 = this.readShort(pullSourceStream);
        l2 = this.readInt(pullSourceStream);
        if (l2 < 0L) {
            l2 += 0x100000000L;
        }
        if ((l3 = (long)this.readInt(pullSourceStream)) < 0L) {
            l3 += 0x100000000L;
        }
        if (n2 == 0 && l2 == 0L && l3 == 0L) {
            d2 = 0.0;
        } else if (n2 == Short.MAX_VALUE) {
            d2 = d3;
        } else {
            n2 -= 16383;
            d2 = (double)l2 * Math.pow(2.0, n2 -= 31);
            d2 += (double)l3 * Math.pow(2.0, n2 -= 32);
        }
        return d2;
    }

    class AiffTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime = new SettableTime();

        AiffTrack(AudioFormat audioFormat, boolean bl, Time time, int n2, int n3, long l2, long l3) {
            super(AiffParser.this, audioFormat, bl, AiffParser.this.duration, time, n2, n3, AiffParser.this.stream, l2, l3);
            double d2 = audioFormat.getSampleRate();
            int n4 = audioFormat.getChannels();
            int n5 = audioFormat.getSampleSizeInBits();
            if (AiffParser.this.timePerBlockNano == -1.0) {
                float f2 = (float)(d2 * (double)AiffParser.this.blockSize);
                this.timePerFrame = (float)n3 / f2;
            } else {
                float f3 = (float)n3 / (float)AiffParser.this.blockSize;
                float f4 = f3 * (float)AiffParser.this.samplesPerBlock;
                this.timePerFrame = (float)((double)f4 / d2);
            }
        }

        AiffTrack(AudioFormat audioFormat, boolean bl, Time time, int n2, int n3) {
            this(audioFormat, bl, time, n2, n3, 0L, Long.MAX_VALUE);
        }
    }
}

