/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.processor.rtp;

import com.sun.media.BasicProcessor;
import com.sun.media.JMFSecurity;
import com.sun.media.Log;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicProcessor
implements ReceiveStreamListener {
    RTPSessionMgr[] mgrs = null;
    DataSource[] sources = null;
    Processor processor = null;
    Format[] formats = null;
    Vector locators = null;
    Object dataLock = new Object();
    boolean dataReady = false;
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    String sessionError = "cannot create and initialize the RTP Session.";
    Object closeSync = new Object();

    public Handler() {
        this.framePositioning = false;
    }

    protected synchronized boolean doConfigure() {
        Object object;
        super.doConfigure();
        try {
            if (this.source instanceof RTPSocket) {
                this.mgrs = new RTPSessionMgr[1];
                this.mgrs[1] = new RTPSessionMgr((RTPSocket)this.source);
                this.mgrs[1].addReceiveStreamListener(this);
                this.sources = new DataSource[1];
                this.sources[0] = this.source;
                this.formats = new Format[1];
                this.dataReady = false;
            } else {
                SessionAddress sessionAddress = new SessionAddress();
                this.mgrs = new RTPSessionMgr[this.locators.size()];
                this.sources = new DataSource[this.locators.size()];
                this.formats = new Format[this.locators.size()];
                this.dataReady = false;
                int n2 = 0;
                while (n2 < this.locators.size()) {
                    SessionAddress sessionAddress2;
                    object = (RTPMediaLocator)this.locators.elementAt(n2);
                    this.mgrs[n2] = (RTPSessionMgr)RTPManager.newInstance();
                    this.mgrs[n2].addReceiveStreamListener(this);
                    InetAddress inetAddress = InetAddress.getByName(((RTPMediaLocator)object).getSessionAddress());
                    if (inetAddress.isMulticastAddress()) {
                        sessionAddress = new SessionAddress(inetAddress, ((RTPMediaLocator)object).getSessionPort(), ((RTPMediaLocator)object).getTTL());
                        sessionAddress2 = new SessionAddress(inetAddress, ((RTPMediaLocator)object).getSessionPort(), ((RTPMediaLocator)object).getTTL());
                    } else {
                        sessionAddress = new SessionAddress(InetAddress.getLocalHost(), ((RTPMediaLocator)object).getSessionPort());
                        sessionAddress2 = new SessionAddress(inetAddress, ((RTPMediaLocator)object).getSessionPort());
                    }
                    this.mgrs[n2].initialize(sessionAddress);
                    this.mgrs[n2].addTarget(sessionAddress2);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            Log.error("Cannot create the RTP Session: " + exception.getMessage());
            this.processError = this.sessionError;
            return false;
        }
        try {
            object = this.dataLock;
            synchronized (object) {
                while (!(this.dataReady || this.isInterrupted() || this.closed)) {
                    this.dataLock.wait();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "no RTP data was received.";
            return false;
        }
        return true;
    }

    protected void completeConfigure() {
        this.state = 180;
        super.completeConfigure();
    }

    protected void doFailedConfigure() {
        this.closeSessions();
        super.doFailedConfigure();
    }

    private void closeSessions() {
        Object object = this.closeSync;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.mgrs.length) {
                if (this.mgrs[n2] != null) {
                    this.mgrs[n2].removeTargets("Closing session from the RTP Handler");
                    this.mgrs[n2].dispose();
                    this.mgrs[n2] = null;
                }
                ++n2;
            }
        }
    }

    protected boolean doRealize() {
        return this.waitForRealize(this.processor);
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doFailedRealize() {
        this.closeSessions();
        super.doFailedRealize();
    }

    protected void doStart() {
        super.doStart();
        this.waitForStart(this.processor);
    }

    protected void doStop() {
        super.doStop();
        this.waitForStop(this.processor);
    }

    protected void doDeallocate() {
        this.processor.deallocate();
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notifyAll();
        }
    }

    protected void doClose() {
        this.closed = true;
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notify();
        }
        this.stop();
        if (this.processor != null) {
            this.processor.close();
        }
        this.closeSessions();
        super.doClose();
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent controllerEvent) {
        super.sendEvent(controllerEvent);
    }

    public void update(ReceiveStreamEvent receiveStreamEvent) {
        RTPSessionMgr rTPSessionMgr = (RTPSessionMgr)receiveStreamEvent.getSource();
        int n2 = 0;
        while (n2 < this.mgrs.length) {
            if (this.mgrs[n2] == rTPSessionMgr) break;
            ++n2;
        }
        if (n2 >= this.mgrs.length) {
            System.err.println("Unknown manager: " + rTPSessionMgr);
            return;
        }
        if (receiveStreamEvent instanceof RemotePayloadChangeEvent) {
            Log.comment("Received an RTP PayloadChangeEvent");
            Log.error("The RTP processor cannot handle mid-stream payload change.\n");
            this.sendEvent(new ControllerErrorEvent(this, "Cannot handle mid-stream payload change."));
            this.close();
        }
        if (receiveStreamEvent instanceof NewReceiveStreamEvent) {
            if (this.sources[n2] != null) {
                return;
            }
            ReceiveStream receiveStream = null;
            try {
                DataSource dataSource;
                receiveStream = ((NewReceiveStreamEvent)receiveStreamEvent).getReceiveStream();
                this.sources[n2] = receiveStream.getDataSource();
                RTPControl rTPControl = (RTPControl)this.sources[n2].getControl("javax.media.rtp.RTPControl");
                if (rTPControl != null) {
                    this.formats[n2] = rTPControl.getFormat();
                    if (this.formats[n2] instanceof AudioFormat) {
                        this.audioEnabled = true;
                    }
                    if (this.formats[n2] instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                if (this.source instanceof RTPSocket) {
                    ((RTPSocket)this.source).setChild(this.sources[n2]);
                } else {
                    ((com.sun.media.protocol.rtp.DataSource)this.source).setChild((com.sun.media.protocol.rtp.DataSource)this.sources[n2]);
                }
                int n3 = 0;
                while (n3 < this.sources.length) {
                    if (this.sources[n3] == null) {
                        return;
                    }
                    ++n3;
                }
                try {
                    dataSource = Manager.createMergingDataSource(this.sources);
                }
                catch (Exception exception) {
                    System.err.println("Cannot merge data sources.");
                    return;
                }
                try {
                    this.processor = Manager.createProcessor(dataSource);
                }
                catch (Exception exception) {
                    System.err.println("Cannot create the mix processor.");
                    return;
                }
                if (!this.waitForConfigure(this.processor)) {
                    return;
                }
                Object object = this.dataLock;
                synchronized (object) {
                    this.dataReady = true;
                    this.dataLock.notifyAll();
                }
            }
            catch (Exception exception) {
                System.err.println("NewReceiveStreamEvent exception " + exception.getMessage());
                return;
            }
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        Object object;
        super.setSource(dataSource);
        if (dataSource instanceof com.sun.media.protocol.rtp.DataSource) {
            object = dataSource.getLocator();
            String string = ((MediaLocator)object).getRemainder();
            int n2 = 0;
            while (string.charAt(n2) == '/') {
                ++n2;
            }
            this.locators = new Vector();
            try {
                RTPMediaLocator rTPMediaLocator;
                String string2;
                int n3;
                while (n2 < string.length() && (n3 = string.indexOf("&", n2)) != -1) {
                    string2 = string.substring(n2, n3);
                    rTPMediaLocator = new RTPMediaLocator("rtp://" + string2);
                    this.locators.addElement(rTPMediaLocator);
                    n2 = n3 + 1;
                }
                string2 = n2 != 0 ? string.substring(n2) : string;
                rTPMediaLocator = new RTPMediaLocator("rtp://" + string2);
                this.locators.addElement(rTPMediaLocator);
            }
            catch (Exception exception) {
                throw new IncompatibleSourceException();
            }
        } else if (!(dataSource instanceof RTPSocket)) {
            throw new IncompatibleSourceException();
        }
        object = (RTPControl)dataSource.getControl("javax.media.rtp.RTPControl");
        if (object != null) {
            object.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.processor.getVisualComponent();
    }

    public Control[] getControls() {
        return this.processor.getControls();
    }

    public void updateStats() {
        if (this.processor != null) {
            ((BasicProcessor)this.processor).updateStats();
        }
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        super.getTrackControls();
        return this.processor.getTrackControls();
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        super.getSupportedContentDescriptors();
        return this.processor.getSupportedContentDescriptors();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) throws NotConfiguredError {
        super.setContentDescriptor(contentDescriptor);
        return this.processor.setContentDescriptor(contentDescriptor);
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        super.getContentDescriptor();
        return this.processor.getContentDescriptor();
    }

    public DataSource getDataOutput() throws NotRealizedError {
        super.getDataOutput();
        return this.processor.getDataOutput();
    }

    private boolean waitForConfigure(Processor processor) {
        return new StateWaiter().waitForConfigure(processor);
    }

    private boolean waitForRealize(Processor processor) {
        return new StateWaiter().waitForRealize(processor);
    }

    private void waitForStart(Player player) {
        new StateWaiter().waitForStart(player, true);
    }

    private void waitForStop(Player player) {
        new StateWaiter().waitForStart(player, false);
    }

    private void waitForClose(Player player) {
        new StateWaiter().waitForClose(player);
    }

    class StateWaiter
    implements ControllerListener {
        boolean closeDown = false;
        Object stateLock = new Object();

        StateWaiter() {
        }

        public boolean waitForConfigure(Processor processor) {
            processor.addControllerListener(this);
            processor.configure();
            Object object = this.stateLock;
            synchronized (object) {
                while (processor.getState() != 180 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            processor.removeControllerListener(this);
            return !this.closeDown;
        }

        public boolean waitForRealize(Processor processor) {
            processor.addControllerListener(this);
            processor.realize();
            Object object = this.stateLock;
            synchronized (object) {
                while (processor.getState() != 300 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            processor.removeControllerListener(this);
            return !this.closeDown;
        }

        public void waitForStart(Player player, boolean bl) {
            player.addControllerListener(this);
            if (bl) {
                player.start();
            } else {
                player.stop();
            }
            Object object = this.stateLock;
            synchronized (object) {
                while ((bl && player.getState() != 600 || !bl && player.getState() == 600) && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            player.removeControllerListener(this);
        }

        public void waitForClose(Player player) {
            player.addControllerListener(this);
            player.close();
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            player.removeControllerListener(this);
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof ControllerClosedEvent || controllerEvent instanceof ControllerErrorEvent) {
                this.closeDown = true;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notify();
            }
        }
    }
}

