/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.util.MediaThread;
import com.sun.media.util.Registry;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12DeleteFileAction;
import com.sun.media.util.jdk12MakeDirectoryAction;
import com.sun.media.util.jdk12PriorityAction;
import com.sun.media.util.jdk12RandomAccessFileAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.DownloadProgressListener;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class CachedPullSourceStream
implements Runnable,
PullSourceStream,
Seekable,
CachedStream {
    private InputStream stream;
    private RandomAccessFile readRAF;
    private RandomAccessFile writeRAF;
    private String fileName;
    private int bufferSize;
    private byte[] buffer;
    private boolean eosReached;
    private boolean ioException;
    private long length;
    private File file;
    private String protocol;
    private boolean readAborted;
    private boolean paused;
    private boolean abort;
    private MediaThread downloadThread;
    private long contentLength;
    private int highMarkFactor;
    private boolean blockRead;
    private static int MAX_HIGH_MARK = 2000000;
    private static int DEFAULT_HIGH_MARK = 1000000;
    private static int MIN_HIGH_MARK = 8192;
    private int highMark;
    private int lowMark;
    private boolean enabled;
    private boolean jitterEnabled;
    private DownloadProgressListener listener;
    private int numKiloBytesUpdateIncrement;
    private boolean closed;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m;
    private Class[] cl;
    private Object[][] args;
    private int maxCacheSize;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public CachedPullSourceStream(InputStream inputStream, String string, long l2, String string2) throws IOException {
        int n2;
        Object object;
        block13: {
            this.readRAF = null;
            this.writeRAF = null;
            this.bufferSize = 2048;
            this.buffer = new byte[this.bufferSize];
            this.eosReached = false;
            this.ioException = false;
            this.readAborted = false;
            this.paused = false;
            this.abort = false;
            this.highMarkFactor = 10;
            this.blockRead = true;
            this.highMark = DEFAULT_HIGH_MARK;
            this.lowMark = 0;
            this.enabled = true;
            this.jitterEnabled = true;
            this.listener = null;
            this.numKiloBytesUpdateIncrement = -1;
            this.closed = true;
            this.m = new Method[1];
            this.cl = new Class[1];
            this.args = new Object[1][0];
            this.maxCacheSize = Integer.MAX_VALUE;
            this.stream = inputStream;
            this.contentLength = l2;
            this.fileName = string;
            this.protocol = string2;
            if (jmfSecurity != null) {
                object = null;
                n2 = 0;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        try {
                            object = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            object = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        object = "read file";
                        n2 = 2;
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        object = "write file";
                        n2 = 4;
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 4);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        object = "delete file";
                        n2 = 8;
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 8);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        break block13;
                    }
                    if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                        try {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Exception exception) {
                    if (n2 > 0) {
                        jmfSecurity.permissionFailureNotification(n2);
                    }
                    securityPrivelege = false;
                }
            }
        }
        if (!securityPrivelege) {
            throw new IOException("No security privilege for caching");
        }
        this.createFilesAndThread(string);
        object = Registry.get("secure.maxCacheSizeMB");
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
            if (n2 < 1) {
                n2 = 1;
            }
            this.maxCacheSize = n2 * 1000000;
        }
        this.highMark = this.getHighMark(l2);
        this.closed = false;
    }

    private int getHighMark(long l2) {
        if (l2 <= 0L) {
            return DEFAULT_HIGH_MARK;
        }
        long l3 = l2 / (long)this.highMarkFactor;
        if (l3 < (long)MIN_HIGH_MARK) {
            l3 = MIN_HIGH_MARK;
        } else if (l3 > (long)MAX_HIGH_MARK) {
            l3 = MAX_HIGH_MARK;
        }
        return (int)l3;
    }

    public void setEnabledBuffering(boolean bl) {
        this.jitterEnabled = bl;
    }

    public boolean getEnabledBuffering() {
        return this.jitterEnabled;
    }

    private void createFilesAndThread(String string) throws IOException {
        try {
            this.file = new File(string);
            String string2 = this.file.getParent();
            File file = null;
            if (string2 != null) {
                file = new File(string2);
            }
            if (securityPrivelege && jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor;
                Boolean bl;
                if (!(file == null || (bl = (Boolean)jdk12.doPrivM.invoke((Object)jdk12.ac, (constructor = jdk12MakeDirectoryAction.cons).newInstance(file))) != null && bl.booleanValue())) {
                    throw new IOException("Unable to create directory " + file);
                }
                constructor = jdk12RandomAccessFileAction.cons;
                this.writeRAF = (RandomAccessFile)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(this.file.getPath(), "rw"));
                if (this.writeRAF == null) {
                    throw new IOException("Cannot create cache file");
                }
                this.readRAF = (RandomAccessFile)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(this.file.getPath(), "r"));
                if (this.readRAF == null) {
                    throw new IOException("Cannot create cache file");
                }
                constructor = jdk12CreateThreadRunnableAction.cons;
                this.downloadThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = CachedPullSourceStream.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                this.downloadThread.setName("download");
                constructor = jdk12PriorityAction.cons;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.downloadThread;
                objectArray2[1] = new Integer(MediaThread.getVideoPriority());
                objectArray[0] = constructor.newInstance(objectArray2);
                jdk12.doPrivM.invoke((Object)jdk12.ac, objectArray);
            } else {
                if (file != null && !file.exists() && !file.mkdirs()) {
                    throw new IOException("Unable to create directory " + file);
                }
                this.writeRAF = new RandomAccessFile(this.file, "rw");
                this.readRAF = new RandomAccessFile(this.file, "r");
                this.downloadThread = new MediaThread(this, "download");
                this.downloadThread.useVideoPriority();
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    private synchronized void setLength(long l2) {
        this.length = l2;
    }

    private synchronized long getLength() {
        return this.length;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = 0;
        var2_2 = this.numKiloBytesUpdateIncrement;
        var3_3 = true;
        if (!this.ioException) ** GOTO lbl64
        return;
lbl-1000:
        // 1 sources

        {
            if (this.abort) {
                return;
            }
            try {
                if (this.contentLength > 0L && !this.protocol.equals("https")) {
                    while (this.stream.available() == 0) {
                        var4_5 = this;
                        synchronized (var4_5) {
                            try {
                                this.wait(25L);
                            }
                            catch (InterruptedException var5_9) {
                                // empty catch block
                            }
                        }
                        if (!this.abort) continue;
                        return;
                    }
                }
                while (this.paused) {
                    var4_6 = this;
                    synchronized (var4_6) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException var5_10) {
                            // empty catch block
                        }
                        if (this.abort) {
                            return;
                        }
                    }
                }
                var4_4 = this.stream.read(this.buffer, 0, this.buffer.length);
                if (var4_4 != -1) {
                    if (this.getLength() + (long)var4_4 > (long)this.maxCacheSize) {
                        Log.warning("MAX CACHESIZE of " + this.maxCacheSize + " reached ");
                        this.contentLength = var1_1;
                        this.eosReached = true;
                    }
                    this.writeRAF.write(this.buffer, 0, var4_4);
                    var5_11 = var1_1 += var4_4;
                    this.setLength(var5_11);
                    if (var5_11 == this.contentLength) {
                        this.eosReached = true;
                    }
                    if (this.listener != null && var1_1 >= var2_2) {
                        this.listener.downloadUpdate();
                        var2_2 += this.numKiloBytesUpdateIncrement;
                    }
                } else {
                    this.setLength(var1_1);
                    this.contentLength = var1_1;
                    this.eosReached = true;
                }
                this.loadUpdate();
                continue;
            }
            catch (IOException var4_7) {
                Log.warning(var4_7 + " : Check if you have enough space in the cache directory");
                this.ioException = true;
                this.eosReached = true;
                this.blockRead = false;
                break;
            }
lbl64:
            // 2 sources

            ** while (!this.eosReached)
        }
lbl65:
        // 2 sources

        if (this.listener != null) {
            this.listener.downloadUpdate();
        }
        if (this.writeRAF != null) {
            try {
                this.writeRAF.close();
                this.writeRAF = null;
            }
            catch (IOException var4_8) {
                // empty catch block
            }
            this.writeRAF = null;
        }
    }

    void startDownload() {
        if (this.enabled && this.downloadThread != null) {
            this.downloadThread.start();
        }
    }

    void pauseDownload() {
        if (this.downloadThread != null && !this.downloadThread.isAlive()) {
            return;
        }
        if (this.enabled) {
            CachedPullSourceStream cachedPullSourceStream = this;
            synchronized (cachedPullSourceStream) {
                if (!this.paused) {
                    this.paused = true;
                    this.notify();
                }
            }
        }
    }

    void resumeDownload() {
        if (this.downloadThread != null && !this.downloadThread.isAlive()) {
            return;
        }
        if (this.enabled) {
            CachedPullSourceStream cachedPullSourceStream = this;
            synchronized (cachedPullSourceStream) {
                if (this.paused) {
                    this.paused = false;
                    this.notify();
                }
            }
        }
    }

    public void abortDownload() {
        this.abort = true;
    }

    public void abortRead() {
        CachedPullSourceStream cachedPullSourceStream = this;
        synchronized (cachedPullSourceStream) {
            this.readAborted = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long seek(long l2) {
        long l3;
        block24: {
            long l4;
            block23: {
                long l5;
                block22: {
                    long l6;
                    block20: {
                        long l7;
                        boolean bl = false;
                        CachedPullSourceStream cachedPullSourceStream = this;
                        synchronized (cachedPullSourceStream) {
                            this.readAborted = false;
                        }
                        try {
                            if (!(this.jitterEnabled && this.drainCondition(l2) || l2 > this.getLength())) {
                                long l8 = this.doSeek(l2);
                                Object var10_11 = null;
                                if (!this.jitterEnabled) return l8;
                                this.drainCondition(l2);
                                return l8;
                            }
                            while (true) {
                                block21: {
                                    if (this.eosReached) {
                                        if (l2 <= this.getLength()) {
                                            l7 = this.doSeek(l2);
                                            break;
                                        }
                                        l6 = -1L;
                                        break block20;
                                    }
                                    if (this.jitterEnabled) {
                                        CachedPullSourceStream cachedPullSourceStream2 = this;
                                        synchronized (cachedPullSourceStream2) {
                                            do {
                                                if (!this.blockRead) {
                                                    break block21;
                                                }
                                                try {
                                                    this.wait(100L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                            } while (!this.readAborted);
                                            this.readAborted = false;
                                            l5 = -2L;
                                        }
                                        break block22;
                                    }
                                }
                                if (this.readAborted) {
                                    this.readAborted = false;
                                    l4 = -2L;
                                    break block23;
                                }
                                if (l2 <= this.getLength()) {
                                    l3 = this.doSeek(l2);
                                    break block24;
                                }
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(250L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_17 = null;
                            if (!this.jitterEnabled) throw throwable;
                            this.drainCondition(l2);
                            throw throwable;
                        }
                        Object var10_12 = null;
                        if (!this.jitterEnabled) return l7;
                        this.drainCondition(l2);
                        return l7;
                    }
                    Object var10_13 = null;
                    if (!this.jitterEnabled) return l6;
                    this.drainCondition(l2);
                    return l6;
                }
                Object var10_14 = null;
                if (!this.jitterEnabled) return l5;
                this.drainCondition(l2);
                return l5;
            }
            Object var10_15 = null;
            if (!this.jitterEnabled) return l4;
            this.drainCondition(l2);
            return l4;
        }
        Object var10_16 = null;
        if (!this.jitterEnabled) return l3;
        this.drainCondition(l2);
        return l3;
    }

    private long getWriteReadPtrOffset() {
        return this.getLength() - this.tell();
    }

    private synchronized void loadUpdate() {
        if (this.blockRead && (this.eosReached || this.getWriteReadPtrOffset() >= (long)this.highMark)) {
            this.blockRead = false;
            CachedPullSourceStream cachedPullSourceStream = this;
            synchronized (cachedPullSourceStream) {
                this.notify();
            }
        }
    }

    private synchronized boolean drainCondition() {
        return this.drainCondition(this.tell());
    }

    private synchronized boolean drainCondition(long l2) {
        l2 = this.getLength() - l2;
        if (this.eosReached) {
            if (this.blockRead) {
                this.blockRead = false;
                this.notify();
            }
            return false;
        }
        if (this.blockRead) {
            if (l2 < (long)this.highMark) {
                return true;
            }
            this.blockRead = false;
            this.notify();
            return false;
        }
        if (l2 < (long)this.lowMark) {
            this.blockRead = true;
            return true;
        }
        return false;
    }

    public boolean willReadBytesBlock(long l2, int n2) {
        if (this.jitterEnabled && this.drainCondition(l2)) {
            return true;
        }
        return l2 + (long)n2 > this.getLength();
    }

    public boolean willReadBytesBlock(int n2) {
        return this.willReadBytesBlock(this.tell(), n2);
    }

    private int waitUntilSeekWillSucceed(long l2) throws IOException {
        boolean bl = true;
        if (!(this.jitterEnabled && this.drainCondition(l2) || l2 > this.getLength())) {
            return 0;
        }
        while (true) {
            if (this.eosReached) {
                if (l2 <= this.getLength()) {
                    return 0;
                }
                return -1;
            }
            if (this.jitterEnabled) {
                CachedPullSourceStream cachedPullSourceStream = this;
                synchronized (cachedPullSourceStream) {
                    while (this.blockRead) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!this.readAborted) continue;
                        int n2 = -2;
                        return n2;
                    }
                }
            }
            if (this.readAborted) {
                return -2;
            }
            if (l2 <= this.getLength()) {
                return 0;
            }
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public long tell() {
        CachedPullSourceStream cachedPullSourceStream = this;
        synchronized (cachedPullSourceStream) {
            if (this.closed) {
                long l2 = -1L;
                return l2;
            }
            try {
                long l3 = this.readRAF.getFilePointer();
                return l3;
            }
            catch (IOException iOException) {
                long l4 = -1L;
                return l4;
            }
        }
    }

    private synchronized long doSeek(long l2) {
        if (this.closed) {
            return -1L;
        }
        try {
            this.readRAF.seek(l2);
            return this.readRAF.getFilePointer();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public synchronized int doRead(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            return -1;
        }
        try {
            int n4 = this.readRAF.read(byArray, n2, n3);
            return n4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            return -2;
        }
    }

    private synchronized void doClose() {
        try {
            this.closed = true;
            if (this.readRAF != null) {
                this.readRAF.close();
            }
            if (this.writeRAF != null) {
                this.writeRAF.close();
            }
            if (this.file == null) {
                return;
            }
            this.deleteFile(this.file);
            this.file = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isRandomAccess() {
        if (this.enabled) {
            return true;
        }
        try {
            Seekable seekable = (Seekable)((Object)this.stream);
            return seekable.isRandomAccess();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean willReadBlock() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block5: {
            int n5;
            block4: {
                try {
                    int n6 = this.waitUntilSeekWillSucceed(this.tell() + (long)n3);
                    if (n6 == -1) {
                        int n7 = -1;
                        Object var8_6 = null;
                        if (!this.jitterEnabled) return n7;
                        this.drainCondition();
                        return n7;
                    }
                    if (n6 != -2) {
                        n5 = this.doRead(byArray, n2, n3);
                        break block4;
                    }
                    n4 = n6;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (!this.jitterEnabled) throw throwable;
                    this.drainCondition();
                    throw throwable;
                }
            }
            Object var8_7 = null;
            if (!this.jitterEnabled) return n5;
            this.drainCondition();
            return n5;
        }
        Object var8_8 = null;
        if (!this.jitterEnabled) return n4;
        this.drainCondition();
        return n4;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public boolean endOfStream() {
        return false;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    void close() {
        if (!this.abort) {
            this.abortDownload();
        }
        if (this.downloadThread != null) {
            int n2 = 0;
            while (n2 < 20) {
                if (!this.downloadThread.isAlive()) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        this.doClose();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    long getContentProgress() {
        return this.length;
    }

    void addDownloadProgressListener(DownloadProgressListener downloadProgressListener, int n2) {
        this.listener = downloadProgressListener;
        if (n2 <= 0) {
            n2 = 1024;
        }
        this.numKiloBytesUpdateIncrement = n2 * 1024;
    }

    void removeDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.listener = null;
    }

    long getStartOffset() {
        return 0L;
    }

    long getEndOffset() {
        return this.length;
    }

    private boolean deleteFile(File file) {
        boolean bl = false;
        try {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 8);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                    }
                }
                catch (Exception exception) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12DeleteFileAction.cons;
                Boolean bl2 = (Boolean)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(file));
                bl = bl2;
            } else {
                bl = file.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    boolean isDownloading() {
        if (this.eosReached) {
            return false;
        }
        return this.length != -1L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

