/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class DirectAudioRenderer
extends AudioRenderer {
    static String NAME = "DirectAudioRenderer";
    static boolean loaded = false;
    private int nativeData = 0;

    public DirectAudioRenderer() {
        this.supportedFormats = new Format[]{new AudioFormat("LINEAR", 44100.0, -1, 2, 0, -1), new AudioFormat("LINEAR", 44100.0, -1, 1, 0, -1), new AudioFormat("LINEAR", 22050.0, -1, -1, 0, -1), new AudioFormat("LINEAR", 11025.0, -1, -1, 0, -1), new AudioFormat("LINEAR", 8000.0, -1, -1, 0, -1)};
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null && !this.initDevice(this.inputFormat)) {
            throw new ResourceUnavailableException("Cannot intialize audio device for playback");
        }
    }

    public void close() {
        super.close();
    }

    public void flush() {
        this.device.flush();
    }

    protected AudioOutput createDevice(AudioFormat audioFormat) {
        return new DirectAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        return true;
    }

    public float setRate(float f2) {
        return super.setRate(1.0f);
    }

    private native boolean nOpen(int var1, int var2, int var3, int var4);

    private native void nClose();

    private native void nPause();

    private native void nResume();

    private native void nDrain();

    private native void nFlush();

    private native void nSetGain(float var1);

    private native void nSetMute(boolean var1);

    private native long nGetSamplesPlayed();

    private native int nBufferAvailable();

    private native int nWrite(byte[] var1, int var2, int var3);

    static {
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmdaud");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                loaded = false;
            }
        }
    }

    class DirectAudioOutput
    implements AudioOutput {
        private int bufSize;
        private AudioFormat format;
        private double gain;
        private boolean muted;

        public boolean initialize(AudioFormat audioFormat, int n2) {
            if (!loaded) {
                return false;
            }
            this.format = audioFormat;
            n2 = (int)(audioFormat.getSampleRate() * (double)audioFormat.getSampleSizeInBits() * (double)audioFormat.getChannels() / 8.0 / 32.0);
            return DirectAudioRenderer.this.nOpen((int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), n2);
        }

        public void dispose() {
            DirectAudioRenderer.this.nClose();
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.dispose();
        }

        public void pause() {
            DirectAudioRenderer.this.nPause();
        }

        public void resume() {
            DirectAudioRenderer.this.nResume();
        }

        public void drain() {
            DirectAudioRenderer.this.nDrain();
        }

        public void flush() {
            DirectAudioRenderer.this.nFlush();
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public long getMediaNanoseconds() {
            long l2 = DirectAudioRenderer.this.nGetSamplesPlayed();
            long l3 = (long)((double)(1000000L * l2) / this.format.getSampleRate()) * 1000L;
            return l3;
        }

        public double getGain() {
            return this.gain;
        }

        public void setGain(double d2) {
            DirectAudioRenderer.this.nSetGain(DirectAudioRenderer.this.gainControl.getLevel());
            this.gain = d2;
        }

        public void setMute(boolean bl) {
            DirectAudioRenderer.this.nSetMute(bl);
            this.muted = bl;
        }

        public boolean getMute() {
            return this.muted;
        }

        public float setRate(float f2) {
            return 1.0f;
        }

        public float getRate() {
            return 1.0f;
        }

        public int bufferAvailable() {
            return DirectAudioRenderer.this.nBufferAvailable();
        }

        public int write(byte[] byArray, int n2, int n3) {
            return DirectAudioRenderer.this.nWrite(byArray, n2, n3);
        }
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer audioRenderer) {
            super(1.0f);
            this.renderer = audioRenderer;
        }

        public void setMute(boolean bl) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(bl);
            }
            super.setMute(bl);
        }

        public float setLevel(float f2) {
            float f3 = super.setLevel(f2);
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(f2);
            }
            return f3;
        }
    }
}

