/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.BasicClock;
import com.sun.media.Log;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.SunAudioOutput;
import javax.media.ClockStoppedException;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;

public class SunAudioRenderer
extends AudioRenderer {
    static String NAME = "SunAudio Renderer";
    public static String vendor = null;
    public static String version = null;
    public static boolean runningOnMac = false;
    public static boolean useSystemTime = false;
    private BasicClock clock = null;
    private long startMediaTime = 0L;
    public static long DEVICE_LATENCY;

    public SunAudioRenderer() {
        if (useSystemTime) {
            this.timeBase = new SystemTimeBase();
            this.clock = new BasicClock();
        }
        this.supportedFormats = new Format[1];
        this.supportedFormats[0] = new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1);
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (!SunAudioRenderer.grabDevice()) {
            throw new ResourceUnavailableException("AudioRenderer: Failed to initialize audio device.");
        }
    }

    public void close() {
        super.close();
    }

    protected AudioOutput createDevice(AudioFormat audioFormat) {
        return new SunAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        if (runningOnMac && !AudioPlayer.player.isAlive()) {
            System.out.println("Audio device is busy");
            return false;
        }
        return true;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (useSystemTime) {
            if (!(timeBase instanceof SystemTimeBase)) {
                Log.warning("AudioRenderer cannot be controlled by time bases other than its own: " + timeBase);
            }
            this.clock.setTimeBase(timeBase);
        } else {
            super.setTimeBase(timeBase);
        }
    }

    public void syncStart(Time time) {
        super.syncStart(time);
        if (useSystemTime) {
            this.clock.syncStart(time);
        }
    }

    public void stop() {
        super.stop();
        if (useSystemTime) {
            this.clock.stop();
        }
    }

    public void setStopTime(Time time) {
        if (useSystemTime) {
            this.clock.setStopTime(time);
        } else {
            super.setStopTime(time);
        }
    }

    public Time getStopTime() {
        if (useSystemTime) {
            return this.clock.getStopTime();
        }
        return super.getStopTime();
    }

    public void setMediaTime(Time time) {
        if (useSystemTime) {
            this.clock.setMediaTime(time);
            this.startMediaTime = time.getNanoseconds();
        } else {
            super.setMediaTime(time);
        }
    }

    public Time getMediaTime() {
        return useSystemTime ? this.clock.getMediaTime() : super.getMediaTime();
    }

    public long getMediaNanoseconds() {
        if (useSystemTime) {
            long l2 = this.clock.getMediaNanoseconds();
            if (l2 - this.startMediaTime < DEVICE_LATENCY) {
                return this.startMediaTime;
            }
            return l2 - DEVICE_LATENCY;
        }
        return super.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return useSystemTime ? this.clock.getSyncTime() : super.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return useSystemTime ? this.clock.getTimeBase() : super.getTimeBase();
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return useSystemTime ? this.clock.mapToTimeBase(time) : super.mapToTimeBase(time);
    }

    public float getRate() {
        return useSystemTime ? this.clock.getRate() : super.getRate();
    }

    public float setRate(float f2) {
        return super.setRate(1.0f);
    }

    static {
        try {
            vendor = System.getProperty("java.vendor");
            version = System.getProperty("java.version");
            if (vendor != null && (vendor = vendor.toUpperCase()).startsWith("APPLE") && version.startsWith("1.1")) {
                runningOnMac = true;
                useSystemTime = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEVICE_LATENCY = runningOnMac ? 7000000000L : 0L;
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer audioRenderer) {
            super(false);
            this.renderer = audioRenderer;
        }

        public void setMute(boolean bl) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(bl);
            }
            super.setMute(bl);
        }

        public float getLevel() {
            return -1.0f;
        }
    }
}

