/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.audio.SunAudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.SunAudioPlayThread;
import com.sun.media.renderer.audio.device.jdk12CreateThreadAction;
import com.sun.media.util.jdk12;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class SunAudioOutput
extends InputStream
implements AudioOutput {
    protected AudioStream audioStream;
    protected int bufLength;
    protected byte[] buffer;
    protected static int EOM = -1;
    protected boolean paused = false;
    protected boolean started = false;
    protected boolean flushing = false;
    private boolean startAfterWrite = false;
    protected AudioFormat format;
    private int SUN_MAGIC = 779316836;
    private int HDR_SIZE = 24;
    private int FILE_LENGTH = 0;
    private int SAMPLE_RATE = 8000;
    private int ENCODING = 1;
    private int CHANNELS = 1;
    int in = 0;
    int out = 0;
    boolean eom = false;
    int samplesPlayed = 0;
    private boolean isMuted = false;
    private double gain = 0.0;
    private byte[] silence;
    private static final int END_OF_MEDIA_PADDING_LENGTH = 800;
    private int endOfMediaPaddingLength;
    private byte[] conversionBuffer;
    static final int SLEEP_TIME = 50;
    protected boolean internalDelayUpdate = false;
    private SunAudioPlayThread timeUpdatingThread = null;
    protected int sunAudioInitialCount = 0;
    protected int sunAudioFinalCount = 0;
    protected int silenceCount = 0;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$renderer$audio$device$SunAudioPlayThread;

    public boolean initialize(AudioFormat audioFormat, int n2) {
        Object object;
        this.format = audioFormat;
        this.bufLength = 12000;
        this.buffer = new byte[this.bufLength];
        this.silence = new byte[this.bufLength];
        int n3 = 0;
        while (n3 < this.bufLength) {
            this.silence[n3] = 127;
            ++n3;
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12CreateThreadAction.cons;
                this.timeUpdatingThread = (SunAudioPlayThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$renderer$audio$device$SunAudioPlayThread == null ? (class$com$sun$media$renderer$audio$device$SunAudioPlayThread = SunAudioOutput.class$("com.sun.media.renderer.audio.device.SunAudioPlayThread")) : class$com$sun$media$renderer$audio$device$SunAudioPlayThread));
            }
            catch (Exception exception) {}
        } else {
            this.timeUpdatingThread = new SunAudioPlayThread();
        }
        this.timeUpdatingThread.setStream(this);
        this.setPaddingLength(800);
        object = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
        try {
            dataOutputStream.writeInt(this.SUN_MAGIC);
            dataOutputStream.writeInt(this.HDR_SIZE);
            dataOutputStream.writeInt(this.FILE_LENGTH);
            dataOutputStream.writeInt(this.ENCODING);
            dataOutputStream.writeInt(this.SAMPLE_RATE);
            dataOutputStream.writeInt(this.CHANNELS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        this.write(byArray, 0, byArray.length);
        String string = audioFormat.getEncoding();
        int n4 = (int)audioFormat.getSampleRate();
        if (audioFormat.getChannels() != 1 || n4 != 8000 || !string.equals("ULAW")) {
            System.out.println("AudioPlay:Unsupported Audio Format");
            return false;
        }
        try {
            this.audioStream = new AudioStream((InputStream)this);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            this.audioStream = null;
            return false;
        }
        return true;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void pause() {
        if (this.audioStream != null) {
            this.timeUpdatingThread.pause();
            AudioPlayer.player.stop((InputStream)this.audioStream);
        }
        this.paused = true;
    }

    public synchronized void resume() {
        if (this.audioStream != null && (!this.started || this.paused)) {
            this.started = true;
            AudioPlayer.player.start((InputStream)this.audioStream);
            this.timeUpdatingThread.start();
        }
        this.paused = false;
    }

    public synchronized void dispose() {
        if (this.audioStream != null) {
            this.timeUpdatingThread.kill();
            AudioPlayer.player.stop((InputStream)this.audioStream);
        }
        this.buffer = null;
    }

    public void drain() {
        SunAudioOutput sunAudioOutput = this;
        synchronized (sunAudioOutput) {
            int n2 = this.endOfMediaPaddingLength;
            while (n2 > 0) {
                int n3 = this.write(this.silence, 0, n2);
                n2 -= n3;
            }
            while (this.in != this.out && !this.paused) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (SunAudioRenderer.runningOnMac) {
                try {
                    Thread.sleep(SunAudioRenderer.DEVICE_LATENCY / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void flush() {
        this.in = 0;
        this.out = 0;
        this.sunAudioInitialCount = this.sunAudioFinalCount = this.samplesPlayed;
        this.flushing = true;
        this.notifyAll();
    }

    public long getMediaNanoseconds() {
        return this.audioStream == null ? 0L : (long)this.samplesPlayed * 125000L;
    }

    public void setMute(boolean bl) {
        this.isMuted = bl;
    }

    public boolean getMute() {
        return this.isMuted;
    }

    public void setGain(double d2) {
    }

    public double getGain() {
        return 0.0;
    }

    public float setRate(float f2) {
        return 1.0f;
    }

    public float getRate() {
        return 1.0f;
    }

    public int dataAvailable() {
        if (this.in == this.out) {
            return 0;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.bufLength - (this.out - this.in);
    }

    public int bufferAvailable() {
        if (SunAudioRenderer.runningOnMac) {
            return 0;
        }
        return this.bufLength - this.dataAvailable() - 1;
    }

    public synchronized int read() {
        while (this.in == this.out) {
            if (this.eom) {
                this.eom = false;
                return EOM;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n2 = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        return n2;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        if (n3 <= 0) {
            return -1;
        }
        if (n3 > 4 && !this.internalDelayUpdate) {
            this.internalDelayUpdate = true;
            this.timeUpdatingThread.setInternalDelay(n3);
        }
        if (this.dataAvailable() == 0) {
            System.arraycopy(this.silence, 0, byArray, n2, n4);
            this.silenceCount += n4;
            return n4;
        }
        int n5 = this.read();
        if (n5 < 0) {
            return -1;
        }
        byArray[n2] = (byte)n5;
        int n6 = 1;
        if (this.in != this.out) {
            --n3;
            if (this.out < this.in) {
                int n7 = this.in - this.out;
                if (n7 > n3) {
                    n7 = n3;
                }
                System.arraycopy(this.buffer, this.out, byArray, n2 + 1, n7);
                this.out += n7;
                n6 += n7;
            } else if (this.out > this.in) {
                int n8 = this.bufLength - this.out;
                if (n8 >= n3) {
                    n8 = n3;
                    System.arraycopy(this.buffer, this.out, byArray, n2 + 1, n8);
                    this.out += n8;
                    if (this.out >= this.bufLength) {
                        this.out = 0;
                    }
                    n6 += n8;
                } else {
                    System.arraycopy(this.buffer, this.out, byArray, n2 + 1, n8);
                    this.out += n8;
                    if (this.out >= this.bufLength) {
                        this.out = 0;
                    }
                    int n9 = n8;
                    n6 += n8;
                    int n10 = n3 - n8;
                    int n11 = n10 <= (n8 = this.in - this.out) ? n10 : n8;
                    System.arraycopy(this.buffer, 0, byArray, n2 + 1 + n9, n11);
                    this.out += n11;
                    n6 += n11;
                }
            }
        }
        if (this.isMuted) {
            System.arraycopy(this.silence, 0, byArray, n2, n4);
        } else if (n6 < n4) {
            System.arraycopy(this.silence, 0, byArray, n2 + n6, n4 - n6);
            this.silenceCount += n4 - n6;
        } else if (this.silenceCount > 0) {
            if (this.silenceCount > n6) {
                this.silenceCount -= n6;
                n6 = 0;
            } else {
                n6 -= this.silenceCount;
                this.silenceCount = 0;
            }
        }
        this.timeUpdatingThread.resetSampleCountTime();
        this.sunAudioInitialCount = this.sunAudioFinalCount;
        this.sunAudioFinalCount += n6;
        this.notifyAll();
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int write(byte[] var1_1, int var2_2, int var3_3) {
        this.flushing = false;
        if (var3_3 > 0) ** GOTO lbl9
        return 0;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException var4_4) {
                // empty catch block
            }
lbl9:
            // 3 sources

            ** while ((this.in + 1) % this.buffer.length == this.out)
        }
lbl10:
        // 1 sources

        if (this.flushing) {
            return 0;
        }
        var4_5 = 0;
        if (this.in < this.out) {
            var5_6 = this.out - this.in - 1;
            var6_8 = var5_6 < var3_3 ? var5_6 : var3_3;
            System.arraycopy(var1_1, var2_2, this.buffer, this.in, var6_8);
            this.in += var6_8;
            var4_5 += var6_8;
        } else {
            var8_11 = this.out == 0 ? this.bufLength - this.in - 1 : this.bufLength - this.in;
            if (var8_11 >= var3_3) {
                var6_9 = var3_3;
                System.arraycopy(var1_1, var2_2, this.buffer, this.in, var6_9);
                this.in += var6_9;
                if (this.in >= this.bufLength) {
                    this.in = 0;
                }
                var4_5 += var6_9;
            } else {
                var6_10 = var8_11;
                System.arraycopy(var1_1, var2_2, this.buffer, this.in, var6_10);
                this.in += var6_10;
                if (this.in >= this.bufLength) {
                    this.in = 0;
                }
                var4_5 += var6_10;
                var3_3 -= var6_10;
                var7_12 = var6_10;
                if (this.out > 0) {
                    var5_7 = this.out - this.in - 1;
                    var6_10 = var5_7 < var3_3 ? var5_7 : var3_3;
                    System.arraycopy(var1_1, var2_2 + var7_12, this.buffer, 0, var6_10);
                    var4_5 += var6_10;
                    this.in = var6_10;
                }
            }
        }
        this.notifyAll();
        return var4_5;
    }

    protected void setPaddingLength(int n2) {
        this.endOfMediaPaddingLength = n2;
        if (this.endOfMediaPaddingLength > this.silence.length) {
            this.endOfMediaPaddingLength = this.silence.length;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

