/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.WindowUtil;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class XLibRenderer
extends BasicVideoRenderer
implements DynamicPlugIn {
    private static boolean available = true;
    private static int jawtAvail = WindowUtil.getJAWTAvail();
    private int blitter = 0;
    protected Object data = null;
    private int defBitsPerPixel = 32;
    private int defRedMask = 255;
    private int defGreenMask = 65280;
    private int defBlueMask = 0xFF0000;
    private int offsetX = 0;
    private int offsetY = 0;
    private int bytesPerPixel = 4;
    private int bitsPerPixel;
    private int rMask;
    private int gMask;
    private int bMask;
    private int pixelStride;
    private int lineStride;
    private int lastOutWidth = -1;
    private int lastOutHeight = -1;
    private boolean firstTime = true;
    protected VideoFormat defaultFormat;

    private native void xlibSetJAWT(int var1);

    private synchronized native boolean xlibInitialize();

    private synchronized native boolean xlibSetComponent(Object var1);

    private synchronized native boolean xlibSetInputFormat(int var1, int var2, int var3);

    private synchronized native boolean xlibSetOutputSize(int var1, int var2);

    private synchronized native boolean xlibDraw(Object var1, long var2, int var4);

    private synchronized native boolean xlibFree();

    public XLibRenderer() {
        super("XLib Renderer");
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmxlib");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            available = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            available = false;
        }
        if (!available) {
            throw new RuntimeException("Could not load jmxlib library");
        }
        this.xlibSetJAWT(jawtAvail);
        if (this.xlibInitialize()) {
            ColorModel colorModel = Toolkit.getDefaultToolkit().getColorModel();
            if (!(colorModel instanceof DirectColorModel)) {
                throw new RuntimeException("Cannot render to non-TrueColor visuals");
            }
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n2 = 1;
            this.defBitsPerPixel = directColorModel.getPixelSize();
            Class clazz = Format.intArray;
            if (this.defBitsPerPixel == 16 || this.defBitsPerPixel == 15) {
                this.defBitsPerPixel = 16;
                clazz = Format.shortArray;
                this.bytesPerPixel = 2;
            }
            if (this.defBitsPerPixel == 24) {
                this.defBitsPerPixel = 32;
                clazz = Format.intArray;
            }
            this.defRedMask = directColorModel.getRedMask();
            this.defBlueMask = directColorModel.getBlueMask();
            this.defGreenMask = directColorModel.getGreenMask();
            this.defaultFormat = new RGBFormat(null, -1, clazz, -1.0f, this.defBitsPerPixel, this.defRedMask, this.defGreenMask, this.defBlueMask, n2, -1, 0, -1);
            this.supportedFormats = new VideoFormat[1];
            this.supportedFormats[0] = this.defaultFormat;
            this.close();
        } else {
            available = false;
        }
    }

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("XLib not available");
        }
    }

    public void reset() {
    }

    public void close() {
        if (available && this.blitter != 0) {
            this.xlibFree();
        }
    }

    public Format setInputFormat(Format format) {
        if (!available) {
            return null;
        }
        if (!(format instanceof RGBFormat)) {
            return null;
        }
        if (!(Toolkit.getDefaultToolkit().getColorModel() instanceof DirectColorModel)) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            Object object;
            if (this.inputFormat instanceof RGBFormat) {
                object = (RGBFormat)this.inputFormat;
                this.bitsPerPixel = ((RGBFormat)object).getBitsPerPixel();
                this.rMask = ((RGBFormat)object).getRedMask();
                this.gMask = ((RGBFormat)object).getGreenMask();
                this.bMask = ((RGBFormat)object).getBlueMask();
                this.lineStride = ((RGBFormat)object).getLineStride();
                this.pixelStride = ((RGBFormat)object).getPixelStride();
            } else if (this.inputFormat instanceof IndexedColorFormat) {
                this.lineStride = ((IndexedColorFormat)format).getLineStride();
            } else {
                return null;
            }
            object = this;
            synchronized (object) {
                if (this.blitter != 0) {
                    this.xlibSetInputFormat(this.inWidth, this.inHeight, this.lineStride);
                }
            }
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if (this.component != null) {
                this.component.setSize(this.outWidth, this.outHeight);
            }
            return format;
        }
        return null;
    }

    protected synchronized void removingComponent() {
        if (this.blitter != 0) {
            this.xlibFree();
        }
    }

    protected int doProcess(Buffer buffer) {
        return this.doProcess(buffer, false);
    }

    protected int doProcess(Buffer buffer, boolean bl) {
        boolean bl2 = false;
        if (!available || this.component == null) {
            return 0;
        }
        if (!bl) {
            if (!buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
                return 1;
            }
            this.data = this.getInputData(buffer);
        } else if (this.data == null) {
            return 1;
        }
        XLibRenderer xLibRenderer = this;
        synchronized (xLibRenderer) {
            int n2;
            if (!this.componentAvailable || this.data == null) {
                int n3 = 0;
                return n3;
            }
            if (this.blitter == 0 || this.firstTime) {
                n2 = 0;
                this.firstTime = false;
                if (this.blitter == 0) {
                    n2 = WindowUtil.getWindowHandle(this.component);
                    if (n2 == 0) {
                        int n4 = 0;
                        return n4;
                    }
                    this.xlibInitialize();
                    this.xlibSetComponent(this.component);
                    this.xlibSetInputFormat(this.inWidth, this.inHeight, this.lineStride);
                    bl2 = true;
                    this.inputFormat = new VideoFormat(null);
                }
                if (this.blitter == 0) {
                    int n5 = 1;
                    return n5;
                }
            }
            if (this.outWidth > 0 && this.outHeight > 0) {
                if (this.outWidth != this.lastOutWidth || this.outHeight != this.lastOutHeight || bl2) {
                    this.outWidth &= 0xFFFFFFFE;
                    this.lastOutWidth = this.outWidth;
                    this.lastOutHeight = this.outHeight;
                    if (this.blitter != 0) {
                        this.xlibSetOutputSize(this.outWidth, this.outHeight);
                    }
                }
                long l2 = this.getNativeData(this.data);
                if (this.data == null) {
                    int n6 = 0;
                    return n6;
                }
                int n7 = this.xlibDraw(this.data, l2, this.bytesPerPixel) ? 0 : 1;
                return n7;
            }
            n2 = 1;
            return n2;
        }
    }

    public Format[] getBaseInputFormats() {
        Format[] formatArray = new Format[]{new RGBFormat()};
        return formatArray;
    }

    public Format[] getBaseOutputFormats() {
        Format[] formatArray = new Format[]{};
        return formatArray;
    }

    protected synchronized void repaint() {
        if (!this.isStarted() && this.data != null) {
            this.doProcess(null, true);
        }
    }
}

