/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSourceStream;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class BufferControlImpl
implements BufferControl {
    private long currBuffer = Integer.MAX_VALUE;
    private long currThreshold = Integer.MAX_VALUE;
    private long defBuffer = Integer.MAX_VALUE;
    private long defThreshold = Integer.MAX_VALUE;
    private long maxBuffer = Integer.MAX_VALUE;
    private long maxThreshold = Integer.MAX_VALUE;
    BufferControlPanel controlComp = null;
    boolean threshold_enabled = true;
    private static final int AUDIO_DEFAULT_BUFFER = 250;
    private static final int AUDIO_DEFAULT_THRESHOLD = 125;
    private static final int AUDIO_MAX_BUFFER = 4000;
    private static final int AUDIO_MAX_THRESHOLD = 2000;
    private static final int VIDEO_DEFAULT_BUFFER = 135;
    private static final int VIDEO_DEFAULT_THRESHOLD = 0;
    private static final int VIDEO_MAX_BUFFER = 4000;
    private static final int VIDEO_MAX_THRESHOLD = 0;
    private static final int NOT_SPECIFIED = Integer.MAX_VALUE;
    private int bufValue = Integer.MAX_VALUE;
    private int threshValue = Integer.MAX_VALUE;
    private boolean inited = false;
    private Vector sourcestreamlist = new Vector(1);

    protected void addSourceStream(RTPSourceStream rTPSourceStream) {
        this.sourcestreamlist.addElement(rTPSourceStream);
        rTPSourceStream.setBufferControl(this);
    }

    protected void removeSourceStream(RTPSourceStream rTPSourceStream) {
        this.sourcestreamlist.removeElement(rTPSourceStream);
    }

    protected void initBufferControl(Format format) {
        if (format instanceof AudioFormat) {
            this.defBuffer = this.defBuffer == Integer.MAX_VALUE ? 250L : this.currBuffer;
            this.defThreshold = this.defThreshold == Integer.MAX_VALUE ? 125L : this.currThreshold;
            this.maxBuffer = this.maxBuffer == Integer.MAX_VALUE ? 4000L : this.maxBuffer;
            this.maxThreshold = this.maxThreshold == Integer.MAX_VALUE ? 2000L : this.maxThreshold;
            this.currBuffer = this.currBuffer == Integer.MAX_VALUE ? this.defBuffer : this.currBuffer;
            long l2 = this.currThreshold = this.currThreshold == Integer.MAX_VALUE ? this.defThreshold : this.currThreshold;
        }
        if (format instanceof VideoFormat) {
            this.defBuffer = this.defBuffer == Integer.MAX_VALUE ? 135L : this.currBuffer;
            this.defThreshold = this.defThreshold == Integer.MAX_VALUE ? 0L : this.currThreshold;
            this.maxBuffer = this.maxBuffer == Integer.MAX_VALUE ? 4000L : this.maxBuffer;
            this.maxThreshold = this.maxThreshold == Integer.MAX_VALUE ? 0L : this.maxThreshold;
            this.currBuffer = this.currBuffer == Integer.MAX_VALUE ? this.defBuffer : this.currBuffer;
            long l3 = this.currThreshold = this.currThreshold == Integer.MAX_VALUE ? this.defThreshold : this.currThreshold;
        }
        if (this.currBuffer == -2L) {
            this.currBuffer = this.maxBuffer;
        }
        if (this.currBuffer == -1L) {
            this.currBuffer = this.defBuffer;
        }
        if (this.currThreshold == -2L) {
            this.currThreshold = this.maxThreshold;
        }
        if (this.currThreshold == -1L) {
            this.currThreshold = this.defThreshold;
        }
        if (this.controlComp != null) {
            this.controlComp.updateBuffer(this.currBuffer);
            this.controlComp.updateThreshold(this.currThreshold);
        }
        this.inited = true;
    }

    public long getBufferLength() {
        return this.currBuffer;
    }

    public long setBufferLength(long l2) {
        if (!this.inited) {
            this.currBuffer = l2;
            return l2;
        }
        if (l2 == -1L) {
            l2 = this.defBuffer;
        }
        if (l2 == -2L) {
            l2 = this.maxBuffer;
        }
        if (l2 < this.currThreshold) {
            return this.currBuffer;
        }
        this.currBuffer = l2 >= this.maxBuffer ? this.maxBuffer : (l2 <= 0L || l2 == this.defBuffer ? this.defBuffer : l2);
        int n2 = 0;
        while (n2 < this.sourcestreamlist.size()) {
            ((RTPSourceStream)this.sourcestreamlist.elementAt(n2)).updateBuffer(this.currBuffer);
            ++n2;
        }
        if (this.controlComp != null) {
            this.controlComp.updateBuffer(this.currBuffer);
        }
        return this.currBuffer;
    }

    public long getMinimumThreshold() {
        return this.currThreshold;
    }

    public long setMinimumThreshold(long l2) {
        if (!this.inited) {
            this.currThreshold = l2;
            return l2;
        }
        if (l2 == -1L) {
            l2 = this.defThreshold;
        }
        if (l2 == -2L) {
            l2 = this.maxThreshold;
        }
        if (l2 > this.currBuffer) {
            return this.currThreshold;
        }
        this.currThreshold = l2 >= this.maxThreshold ? this.maxThreshold : (l2 == this.defThreshold ? this.defThreshold : l2);
        if (l2 < 0L) {
            this.currThreshold = 0L;
        }
        int n2 = 0;
        while (n2 < this.sourcestreamlist.size()) {
            ((RTPSourceStream)this.sourcestreamlist.elementAt(n2)).updateThreshold(this.currThreshold);
            ++n2;
        }
        if (this.controlComp != null) {
            this.controlComp.updateThreshold(this.currThreshold);
        }
        return this.currThreshold;
    }

    public void setEnabledThreshold(boolean bl) {
        this.threshold_enabled = bl;
    }

    public boolean getEnabledThreshold() {
        return this.threshold_enabled;
    }

    public Component getControlComponent() {
        if (this.controlComp == null) {
            this.controlComp = new BufferControlPanel();
        }
        return this.controlComp;
    }

    class BufferControlPanel
    extends Panel {
        Panel buffersize = new Panel(new FlowLayout());
        Panel threshold = null;
        TextField bsize;
        TextField btext = null;
        Choice bchoice = null;
        Choice tchoice = null;
        TextField tsize;
        TextField ttext = null;
        Button bb;
        Button tb = null;

        public BufferControlPanel() {
            super(new BorderLayout());
            this.buffersize.add(new Label("BufferSize"));
            this.bsize = new TextField(15);
            this.updateBuffer(BufferControlImpl.this.getBufferLength());
            this.bsize.setEnabled(false);
            this.buffersize.add(this.bsize);
            this.buffersize.add(new Label("Update"));
            this.bchoice = new Choice();
            this.buffersize.add(this.bchoice);
            this.bchoice.add("DEFAULT");
            this.bchoice.add("MAX");
            this.bchoice.add("User Defined");
            this.bchoice.addItemListener(new ItemListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = bufferControlPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getItem().equals("User Defined")) {
                        this.this$1.btext.setEnabled(true);
                    } else {
                        this.this$1.btext.setEnabled(false);
                    }
                }
            });
            this.buffersize.add(new Label("If User Defined, Enter here:"));
            this.btext = new TextField(10);
            this.buffersize.add(this.btext);
            this.btext.setEnabled(false);
            this.bb = new Button("Commit");
            this.buffersize.add(this.bb);
            this.bb.addActionListener(new ActionListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = bufferControlPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BufferControlPanel.access$000(this.this$1);
                }
            });
            this.threshold = new Panel(new FlowLayout());
            this.threshold.add(new Label("Threshold"));
            this.tsize = new TextField(15);
            this.updateThreshold(BufferControlImpl.this.getMinimumThreshold());
            this.tsize.setEnabled(false);
            this.threshold.add(this.tsize);
            this.threshold.add(new Label("Update"));
            this.tchoice = new Choice();
            this.threshold.add(this.tchoice);
            this.tchoice.add("DEFAULT");
            this.tchoice.add("MAX");
            this.tchoice.add("User Defined");
            this.tchoice.addItemListener(new ItemListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = bufferControlPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getItem().equals("User Defined")) {
                        this.this$1.ttext.setEnabled(true);
                    } else {
                        this.this$1.ttext.setEnabled(false);
                    }
                }
            });
            this.threshold.add(new Label("If User Defined, Enter here:"));
            this.ttext = new TextField(10);
            this.threshold.add(this.ttext);
            this.ttext.setEnabled(false);
            this.tb = new Button("Commit");
            this.threshold.add(this.tb);
            this.tb.addActionListener(new ActionListener(this){
                private final /* synthetic */ BufferControlPanel this$1;
                {
                    this.this$1 = bufferControlPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BufferControlPanel.access$100(this.this$1);
                }
            });
            this.add((Component)this.buffersize, "North");
            this.add((Component)new Label("Actual buffer & threshold sizes (in millisec) not displayed until media type is determined"), "Center");
            this.add((Component)this.threshold, "South");
            this.setVisible(true);
        }

        private void buffersizeUpdate() {
            String string = this.bchoice.getSelectedItem();
            long l2 = -1L;
            if (string.equals("MAX")) {
                l2 = -2L;
            } else if (string.equals("DEFAULT")) {
                l2 = -1L;
            } else {
                string = this.btext.getText();
                l2 = new Long(string);
            }
            l2 = BufferControlImpl.this.setBufferLength(l2);
            this.updateBuffer(l2);
        }

        private void thresholdUpdate() {
            String string = this.tchoice.getSelectedItem();
            long l2 = -1L;
            if (string.equals("DEFAULT")) {
                l2 = -1L;
            } else if (string.equals("MAX")) {
                l2 = -2L;
            } else {
                string = this.ttext.getText();
                l2 = new Long(string);
            }
            l2 = BufferControlImpl.this.setMinimumThreshold(l2);
            this.updateThreshold(l2);
        }

        public void updateBuffer(long l2) {
            if (l2 != Integer.MAX_VALUE && l2 != -2L && l2 != -1L) {
                this.bsize.setText(new Long(l2).toString());
            }
        }

        public void updateThreshold(long l2) {
            if (l2 != Integer.MAX_VALUE && l2 != -2L && l2 != -1L) {
                this.tsize.setText(new Long(l2).toString());
            }
        }

        static /* synthetic */ void access$000(BufferControlPanel bufferControlPanel) {
            bufferControlPanel.buffersizeUpdate();
        }

        static /* synthetic */ void access$100(BufferControlPanel bufferControlPanel) {
            bufferControlPanel.thresholdUpdate();
        }
    }
}

