/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.SSRCCache;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class FormatInfo {
    private SSRCCache cache = null;
    public static final int PAYLOAD_NOTFOUND = -1;
    Format[] formatList = new Format[64];
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    public FormatInfo() {
        this.initFormats();
    }

    public void setCache(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
    }

    public void add(int n2, Format format) {
        Format format2;
        if (n2 >= this.formatList.length) {
            this.expandTable(n2);
        }
        if ((format2 = this.formatList[n2]) != null) {
            return;
        }
        this.formatList[n2] = format;
        if (this.cache != null && format instanceof VideoFormat) {
            this.cache.clockrate[n2] = 90000;
        }
        if (this.cache != null && format instanceof AudioFormat) {
            this.cache.clockrate[n2] = mpegAudio.matches(format) ? 90000 : (int)((AudioFormat)format).getSampleRate();
        }
    }

    private void expandTable(int n2) {
        Format[] formatArray = new Format[n2 + 1];
        int n3 = 0;
        while (n3 < this.formatList.length) {
            formatArray[n3] = this.formatList[n3];
            ++n3;
        }
        this.formatList = formatArray;
    }

    public Format get(int n2) {
        return n2 >= this.formatList.length ? null : this.formatList[n2];
    }

    public int getPayload(Format format) {
        if (format.getEncoding() != null && format.getEncoding().equals("g729a/rtp")) {
            format = new AudioFormat("g729/rtp");
        }
        int n2 = 0;
        while (n2 < this.formatList.length) {
            if (format.matches(this.formatList[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void initFormats() {
        this.formatList[0] = new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
        this.formatList[3] = new AudioFormat("gsm/rtp", 8000.0, -1, 1);
        this.formatList[4] = new AudioFormat("g723/rtp", 8000.0, -1, 1);
        this.formatList[5] = new AudioFormat("dvi/rtp", 8000.0, 4, 1);
        this.formatList[14] = new AudioFormat("mpegaudio/rtp", -1.0, -1, -1);
        this.formatList[15] = new AudioFormat("g728/rtp", 8000.0, -1, 1);
        this.formatList[16] = new AudioFormat("dvi/rtp", 11025.0, 4, 1);
        this.formatList[17] = new AudioFormat("dvi/rtp", 22050.0, 4, 1);
        this.formatList[18] = new AudioFormat("g729/rtp", 8000.0, -1, 1);
        this.formatList[26] = new VideoFormat("jpeg/rtp");
        this.formatList[31] = new VideoFormat("h261/rtp");
        this.formatList[32] = new VideoFormat("mpeg/rtp");
        this.formatList[34] = new VideoFormat("h263/rtp");
        this.formatList[42] = new VideoFormat("h263-1998/rtp");
    }

    public static boolean isSupported(int n2) {
        switch (n2) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 34: {
                return true;
            }
        }
        return false;
    }
}

