/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.util.Signed;
import javax.media.rtp.rtcp.Feedback;

public class RTCPReportBlock
implements Feedback {
    int ssrc;
    int fractionlost;
    int packetslost;
    long lastseq;
    int jitter;
    long lsr;
    long dlsr;
    long receiptTime;

    public long getSSRC() {
        return this.ssrc;
    }

    public int getFractionLost() {
        return this.fractionlost;
    }

    public long getNumLost() {
        return this.packetslost;
    }

    public long getXtndSeqNum() {
        return this.lastseq;
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getLSR() {
        return this.lsr;
    }

    public long getDLSR() {
        return this.dlsr;
    }

    public String toString() {
        long l2 = this.ssrc;
        if (this.ssrc < 0) {
            l2 = Signed.UnsignedInt(this.ssrc);
        }
        return "\t\tFor source " + l2 + "\n\t\t\tFraction of packets lost: " + this.fractionlost + " (" + (double)this.fractionlost / 256.0 + ")" + "\n\t\t\tPackets lost: " + this.packetslost + "\n\t\t\tLast sequence number: " + this.lastseq + "\n\t\t\tJitter: " + this.jitter + "\n\t\t\tLast SR packet received at time " + this.lsr + "\n\t\t\tDelay since last SR packet received: " + this.dlsr + " (" + (double)this.dlsr / 65536.0 + " seconds)\n";
    }

    public static String toString(RTCPReportBlock[] rTCPReportBlockArray) {
        String string = "";
        int n2 = 0;
        while (n2 < rTCPReportBlockArray.length) {
            string = string + rTCPReportBlockArray[n2];
            ++n2;
        }
        return string;
    }
}

