/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.RTPMediaThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class PacketForwarder
implements Runnable {
    PacketSource source = null;
    PacketConsumer consumer = null;
    RTPMediaThread thread;
    boolean closed = false;
    private boolean paused;
    public IOException exception = null;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$rtp$util$RTPMediaThread;

    public PacketForwarder(PacketSource packetSource, PacketConsumer packetConsumer) {
        this.source = packetSource;
        this.consumer = packetConsumer;
        this.closed = false;
        this.exception = null;
    }

    public void startPF() {
        this.startPF(null);
    }

    public void startPF(String string) {
        Object object;
        if (this.thread != null) {
            throw new IllegalArgumentException("Called start more than once");
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                if (((String)object).endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (string == null) {
            string = "RTPMediaThread";
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12CreateThreadRunnableAction.cons;
                this.thread = (RTPMediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$rtp$util$RTPMediaThread == null ? (class$com$sun$media$rtp$util$RTPMediaThread = PacketForwarder.class$("com.sun.media.rtp.util.RTPMediaThread")) : class$com$sun$media$rtp$util$RTPMediaThread, this));
                this.thread.setName(string);
                object = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(this.thread, new Integer(MediaThread.getNetworkPriority())));
            }
            catch (Exception exception) {}
        } else {
            this.thread = new RTPMediaThread(this, string);
            this.thread.useNetworkPriority();
        }
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void setVideoPriority() {
        this.thread.useVideoNetworkPriority();
    }

    public PacketSource getSource() {
        return this.source;
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public String getId() {
        if (this.thread == null) {
            System.err.println("the packetforwarders thread is null");
            return null;
        }
        return this.thread.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block16: {
            if (this.closed || this.exception != null) {
                if (this.source == null) return;
                this.source.closeSource();
                return;
            }
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        break block16;
                    }
                    if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable throwable) {
                    jmfSecurity.permissionFailureNotification(128);
                }
            }
        }
        try {
            try {
                while (true) {
                    try {
                        do {
                            Packet packet = this.source.receiveFrom();
                            if (this.checkForClose()) {
                                Object var3_5 = null;
                                this.consumer.closeConsumer();
                                return;
                            }
                            if (packet == null) continue;
                            this.consumer.sendTo(packet);
                        } while (!this.checkForClose());
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (!this.checkForClose()) continue;
                        Object var3_7 = null;
                        this.consumer.closeConsumer();
                        return;
                    }
                    break;
                }
                Object var3_6 = null;
                this.consumer.closeConsumer();
                return;
            }
            catch (IOException iOException) {
                if (this.checkForClose()) {
                    Object var3_8 = null;
                    this.consumer.closeConsumer();
                    return;
                }
                this.exception = iOException;
                Object var3_9 = null;
                this.consumer.closeConsumer();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            this.consumer.closeConsumer();
            throw throwable;
        }
    }

    private boolean checkForClose() {
        if (this.closed && this.thread != null) {
            if (this.source != null) {
                this.source.closeSource();
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.closed = true;
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

