/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp;

import com.sun.media.rtsp.Debug;
import com.sun.media.rtsp.MessageProcessor;
import com.sun.media.rtsp.RtspManager;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Connection
extends Thread
implements Runnable {
    public int connectionId;
    private Socket socket;
    private RtspManager rtspManager;
    private MessageProcessor mp;
    private boolean connectionIsAlive;

    public Connection(RtspManager rtspManager, int n2, byte[] byArray, int n3) throws UnknownHostException, ConnectException {
        this.rtspManager = rtspManager;
        this.connectionId = n2;
        String string = new String(byArray);
        InetAddress inetAddress = InetAddress.getByName(string);
        try {
            this.socket = new Socket(inetAddress, n3);
            this.start();
        }
        catch (IOException iOException) {
            throw new ConnectException();
        }
    }

    public Connection(RtspManager rtspManager, int n2, Socket socket) {
        this.rtspManager = rtspManager;
        this.connectionId = n2;
        this.socket = socket;
        this.start();
    }

    public boolean sendData(byte[] byArray) {
        boolean bl = false;
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public void run() {
        this.connectionIsAlive = true;
        while (this.connectionIsAlive) {
            try {
                InputStream inputStream = this.socket.getInputStream();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                byte by = dataInputStream.readByte();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(by);
                while (!this.eomReached(byteArrayOutputStream.toByteArray())) {
                    byteArrayOutputStream.write(dataInputStream.readByte());
                }
                int n2 = this.getContentLength(new String(byteArrayOutputStream.toByteArray()));
                int n3 = 0;
                while (n3 < n2) {
                    byteArrayOutputStream.write(dataInputStream.readByte());
                    ++n3;
                }
                if (this.mp == null) {
                    this.mp = new MessageProcessor(this.connectionId, this.rtspManager);
                }
                this.mp.processMessage(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                this.connectionIsAlive = false;
            }
        }
    }

    private boolean eomReached(byte[] byArray) {
        boolean bl = false;
        int n2 = byArray.length;
        if (n2 >= 4 && byArray[n2 - 4] == 13 && byArray[n2 - 3] == 10 && byArray[n2 - 2] == 13 && byArray[n2 - 1] == 10) {
            bl = true;
        }
        return bl;
    }

    private int getContentLength(String string) {
        int n2;
        int n3 = string.indexOf("Content-length");
        if (n3 == -1) {
            n3 = string.indexOf("Content-Length");
        }
        if (n3 == -1) {
            n2 = 0;
        } else {
            n3 = string.indexOf(58, n3) + 2;
            int n4 = string.indexOf(13, n3);
            String string2 = string.substring(n3, n4);
            n2 = new Integer(string2);
        }
        return n2;
    }

    public void cleanup() {
        Debug.println((Object)("RTSP::Connection:cleanup, id=" + this.connectionId));
        this.close();
        this.rtspManager.removeConnection(this.connectionId);
    }

    public void close() {
        this.connectionIsAlive = false;
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getIpAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }
}

