/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.Region;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class BufferedPanelLight
extends Container {
    protected boolean buffered;
    protected boolean autoFlushing;
    protected Image background;
    protected boolean windowCreated;
    protected transient Image buffer;
    protected transient Graphics bufferGraphics;
    protected transient Region damage;
    protected Object lock = new Object();

    public BufferedPanelLight(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
        this.buffered = true;
        this.autoFlushing = true;
        this.background = null;
        this.windowCreated = false;
        this.buffer = null;
        this.bufferGraphics = null;
        this.damage = new Region();
    }

    public BufferedPanelLight() {
        this(null);
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean bl) {
        if (bl != this.buffered) {
            this.buffered = bl;
            if (bl) {
                this.repaint();
            }
        }
    }

    public boolean isAutoFlushing() {
        return this.autoFlushing;
    }

    public void setAutoFlushing(boolean bl) {
        if (bl != this.autoFlushing) {
            this.autoFlushing = bl;
        }
    }

    public Image getBackgroundTile() {
        return this.background;
    }

    public void setBackgroundTile(Image image) {
        this.background = image;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        if (this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        super.reshape(n2, n3, n4, n5);
        if (this.windowCreated && (n4 != rectangle.width || n5 != rectangle.height) && this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void flushBuffer() {
        Dimension dimension = this.getSize();
        super.repaint(0L, 0, 0, dimension.width, dimension.height);
    }

    void createBufferImage() {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            this.buffer = this.createImage(dimension.width, dimension.height);
            if (this.buffer != null) {
                this.bufferGraphics = this.buffer.getGraphics();
            }
        }
    }

    protected void renderBuffer() {
        Region region;
        if (this.damage.isEmpty()) {
            return;
        }
        if (this.buffer == null) {
            return;
        }
        Region region2 = this.damage;
        synchronized (region2) {
            region = this.damage;
            this.damage = new Region();
        }
        Enumeration enumeration = region.rectangles();
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle = (Rectangle)enumeration.nextElement();
            this.render(rectangle);
        }
    }

    protected void render(Rectangle rectangle) {
        Component[] componentArray = this.getComponents();
        Image image = this.buffer;
        synchronized (image) {
            this.bufferGraphics.setClip(rectangle);
            this.paintBackground(this.bufferGraphics);
            this.bufferGraphics.setColor(this.getForeground());
            int n2 = componentArray.length - 1;
            while (n2 >= 0) {
                Rectangle rectangle2;
                Component component = componentArray[n2];
                if (this.isLightweight(component) && component.isVisible() && (rectangle2 = component.getBounds()).intersects(rectangle)) {
                    Graphics graphics = this.bufferGraphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    component.paint(graphics);
                    graphics.dispose();
                }
                --n2;
            }
            this.bufferGraphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void paintBackground(Graphics var1_1) {
        block4: {
            block3: {
                var2_2 = this.getSize();
                if (this.background != null) break block3;
                var1_1.setColor(this.getBackground());
                var1_1.fillRect(0, 0, var2_2.width, var2_2.height);
                break block4;
            }
            var3_3 = new Rectangle(0, 0, this.background.getWidth(this), this.background.getHeight(this));
            var4_4 = var1_1.getClipBounds();
            ** GOTO lbl18
            {
                if (var4_4 == null || var4_4.intersects(var3_3)) {
                    var1_1.drawImage(this.background, var3_3.x, var3_3.y, this);
                }
                var3_3.x += var3_3.width;
                do {
                    if (var3_3.x < var2_2.width) continue block0;
                    var3_3.x = 0;
                    var3_3.y += var3_3.height;
lbl18:
                    // 2 sources

                } while (var3_3.y < var2_2.height);
            }
        }
    }

    boolean isLightweight(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        if (this.buffered) {
            Region region = this.damage;
            synchronized (region) {
                this.damage.addRectangle(new Rectangle(n2, n3, n4, n5));
            }
            if (this.autoFlushing) {
                this.flushBuffer();
            }
        } else {
            super.repaint(l2, n2, n3, n4, n5);
        }
    }

    public void update(Graphics graphics) {
        if (this.buffered) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }

    public void paint(Graphics graphics) {
        if (this.buffered && this.buffer != null) {
            this.renderBuffer();
            graphics.drawImage(this.buffer, 0, 0, this);
        } else {
            super.paint(graphics);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.damage = new Region();
    }
}

