/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.ColumnData;
import com.sun.media.ui.RowData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class ColumnList
extends Canvas
implements MouseListener,
FocusListener,
KeyListener,
ComponentListener {
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_DATE = 4;
    private static final int MARGIN_VERT = 2;
    private static final int MARGIN_HORZ = 6;
    private static final Color COLOR_HEADER_BG = Color.lightGray;
    private static final Color COLOR_HEADER_FG = Color.black;
    private static final Color COLOR_SHADOW_TOP = Color.white;
    private static final Color COLOR_SHADOW_BOTTOM = Color.darkGray;
    private static final Color COLOR_SEL_BG = Color.white;
    private static final Color COLOR_SEL_FG = Color.black;
    private Vector vectorColumns = new Vector();
    private Vector vectorRows = new Vector();
    private boolean boolFocus = false;
    private boolean boolSetColumnWidthAsPreferred = false;
    private int nScrollPosHorz = 0;
    private int nScrollPosVert = 0;
    private int nCurrentIndex = 0;
    private int nVisibleRows = 1;
    private Font fontHeader = new Font("Dialog", 0, 12);
    private Font fontItem = new Font("Dialog", 0, 12);
    private int nHeightHeader;
    private int nHeightRow;

    public ColumnList(String[] stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ColumnData columnData = new ColumnData(stringArray[n3], 3);
            this.vectorColumns.addElement(columnData);
            ++n3;
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addRow(Object[] objectArray) {
        RowData rowData = new RowData(objectArray);
        this.vectorRows.addElement(rowData);
        this.repaint();
    }

    public void removeRow(int n2) {
        this.vectorRows.removeElementAt(n2);
        this.repaint();
    }

    public void setCellValue(Object object, int n2, int n3) {
        RowData rowData = (RowData)this.vectorRows.elementAt(n2);
        rowData.setValue(object, n3);
        this.repaint();
    }

    public void setColumnWidth(int n2, int n3) {
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n3);
        columnData.nWidth = n2;
        this.repaint();
    }

    public void setColumnWidth(int n2) {
        int n3 = this.vectorColumns.size();
        int n4 = 0;
        while (n4 < n3) {
            ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n4);
            columnData.nWidth = n2;
            ++n4;
        }
        this.repaint();
    }

    public void setColumnWidthAsPreferred(int n2) {
        int n3;
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n2);
        columnData.nWidth = n3 = this.getPreferredColumnWidth(n2);
        this.repaint();
    }

    public void setColumnWidthAsPreferred() {
        ColumnData columnData;
        int n2 = this.vectorColumns.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            columnData = (ColumnData)this.vectorColumns.elementAt(n4);
            columnData.nWidth = n5 = this.getPreferredColumnWidth(n4);
            n3 += n5;
            ++n4;
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < 1) {
            this.boolSetColumnWidthAsPreferred = true;
        }
        rectangle.width -= 2;
        if (rectangle.width > n3) {
            int n6 = (rectangle.width - n3) / n2;
            n3 = rectangle.width;
            n4 = 0;
            while (n4 < n2) {
                columnData = (ColumnData)this.vectorColumns.elementAt(n4);
                columnData.nWidth = n4 < n2 - 1 ? (columnData.nWidth += n6) : n3;
                n3 -= columnData.nWidth;
                ++n4;
            }
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.height += this.nHeightHeader;
        int n2 = this.nHeightRow;
        dimension.height += (n2 *= this.vectorRows.size());
        int n3 = this.vectorColumns.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.getPreferredColumnWidth(n4);
            dimension.width += n5;
            ++n4;
        }
        dimension.width += 3;
        dimension.height += 3;
        return dimension;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics2 = image != null ? image.getGraphics() : graphics;
        this.paint(graphics2);
        if (image != null) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        ColumnData columnData;
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle(rectangle);
        super.paint(graphics);
        graphics.setColor(COLOR_SHADOW_BOTTOM);
        graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 2, rectangle2.height - 2);
        graphics.setColor(COLOR_SHADOW_TOP);
        graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
        int n6 = this.vectorColumns.size();
        int n7 = this.vectorRows.size();
        ++rectangle2.x;
        ++rectangle2.y;
        int n8 = rectangle2.x;
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        graphics.setFont(this.fontHeader);
        int n9 = fontMetrics.getHeight();
        rectangle2.height = this.nHeightHeader;
        int n10 = this.nScrollPosHorz;
        while (n10 < n6) {
            columnData = (ColumnData)this.vectorColumns.elementAt(n10);
            rectangle2.width = columnData.nWidth;
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width - 1) {
                rectangle2.width = rectangle.x + rectangle.width - 1 - rectangle2.x;
            }
            graphics.setColor(COLOR_HEADER_BG);
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.setColor(COLOR_SHADOW_TOP);
            graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height - 2);
            graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width - 2, rectangle2.y);
            graphics.setColor(COLOR_SHADOW_BOTTOM);
            graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            string = columnData.strName;
            n5 = string.length();
            n4 = fontMetrics.stringWidth(string);
            while (n4 > rectangle2.width - 12 && n5 > 0) {
                string = string.substring(0, --n5) + "...";
                n4 = fontMetrics.stringWidth(string);
            }
            n3 = rectangle2.x + (rectangle2.width - n4) / 2;
            n2 = rectangle2.y + rectangle2.height - (rectangle2.height - n9) / 2 - fontMetrics.getMaxDescent();
            graphics.setColor(this.getForeground());
            graphics.drawString(string, n3, n2);
            rectangle2.x += rectangle2.width;
            ++n10;
        }
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        n9 = fontMetrics.getHeight();
        rectangle2.y += rectangle2.height;
        rectangle2.height = this.nHeightRow;
        int n11 = this.nScrollPosVert;
        while (n11 < n7) {
            rectangle2.x = n8;
            if (n11 == this.nCurrentIndex) {
                rectangle2.width = rectangle.width - 3;
                graphics.setColor(COLOR_SEL_BG);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(COLOR_SEL_FG);
                if (this.boolFocus) {
                    this.drawDottedLine(graphics, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width - 1, rectangle2.y);
                    this.drawDottedLine(graphics, rectangle2.x, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
                }
            } else {
                graphics.setColor(this.getForeground());
            }
            RowData rowData = (RowData)this.vectorRows.elementAt(n11);
            n10 = this.nScrollPosHorz;
            while (n10 < n6) {
                columnData = (ColumnData)this.vectorColumns.elementAt(n10);
                rectangle2.width = columnData.nWidth;
                if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width - 1) {
                    rectangle2.width = rectangle.x + rectangle.width - 1 - rectangle2.x;
                }
                string = rowData.getValue(n10).toString();
                n5 = string.length();
                n4 = fontMetrics.stringWidth(string);
                while (n4 > rectangle2.width - 12 && n5 > 0) {
                    string = string.substring(0, --n5) + "...";
                    n4 = fontMetrics.stringWidth(string);
                }
                n3 = rectangle2.x + 6;
                n2 = rectangle2.y + rectangle2.height - (rectangle2.height - n9) / 2 - fontMetrics.getMaxDescent();
                graphics.drawString(string, n3, n2);
                rectangle2.x += rectangle2.width;
                ++n10;
            }
            rectangle2.y += rectangle2.height;
            ++n11;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2;
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if ((n4 -= 1 + this.nHeightHeader) >= 0 && (n2 = n4 / this.nHeightRow) >= 0 && n2 < this.vectorRows.size() - this.nScrollPosVert) {
            this.nCurrentIndex = n2 + this.nScrollPosVert;
        }
        this.requestFocus();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        int n3 = this.nCurrentIndex;
        if (n2 == 40) {
            ++n3;
        } else if (n2 == 38) {
            --n3;
        } else if (n2 == 36) {
            n3 = 0;
        } else if (n2 == 35) {
            n3 = this.vectorRows.size() - 1;
        } else if (n2 == 33) {
            n3 -= this.nVisibleRows;
        } else if (n2 == 34) {
            n3 += this.nVisibleRows;
        }
        if (n3 > this.vectorRows.size() - 1) {
            n3 = this.vectorRows.size() - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 != this.nCurrentIndex) {
            this.nCurrentIndex = n3;
            if (this.nScrollPosVert + this.nVisibleRows < this.nCurrentIndex) {
                this.nScrollPosVert = this.nCurrentIndex - this.nVisibleRows + 1;
            }
            if (this.nScrollPosVert > this.nCurrentIndex) {
                this.nScrollPosVert = this.nCurrentIndex;
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.boolFocus) {
            return;
        }
        this.boolFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.boolFocus) {
            return;
        }
        this.boolFocus = false;
        this.repaint();
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.boolSetColumnWidthAsPreferred) {
            this.boolSetColumnWidthAsPreferred = false;
            this.setColumnWidthAsPreferred();
        }
        Rectangle rectangle = this.getBounds();
        rectangle.height -= 3 + this.nHeightHeader;
        this.nVisibleRows = rectangle.height / this.nHeightRow;
        if (this.nVisibleRows < 1) {
            this.nVisibleRows = 1;
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void init() throws Exception {
        this.setFont(this.fontItem);
        this.computeHeights();
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(this);
    }

    private int getPreferredColumnWidth(int n2) {
        ColumnData columnData = (ColumnData)this.vectorColumns.elementAt(n2);
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        String string = columnData.strName;
        int n3 = fontMetrics.stringWidth(string) + 12 + 2;
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        int n4 = this.vectorRows.size();
        int n5 = 0;
        while (n5 < n4) {
            RowData rowData = (RowData)this.vectorRows.elementAt(n5);
            string = rowData.getValue(n2).toString();
            int n6 = fontMetrics.stringWidth(string) + 12;
            n3 = Math.max(n3, n6);
            ++n5;
        }
        return n3;
    }

    private void computeHeights() {
        FontMetrics fontMetrics = this.getFontMetrics(this.fontHeader);
        this.nHeightHeader = fontMetrics.getHeight();
        this.nHeightHeader += 2;
        this.nHeightHeader += 4;
        Font font = this.getFont();
        fontMetrics = this.getFontMetrics(font);
        this.nHeightRow = fontMetrics.getHeight();
        this.nHeightRow += 4;
    }

    private void drawDottedLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n2 == n4 && n3 == n5) {
            this.drawDot(graphics, n2, n3);
            return;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 > n5) {
            n6 = n3;
            n3 = n5;
            n5 = n6;
        }
        if (n4 - n2 > n5 - n3) {
            double d2 = (double)(n5 - n3) / (double)(n4 - n2);
            n7 = n2;
            while (n7 <= n4) {
                n6 = (int)Math.rint((double)n3 + (double)(n7 - n2) * d2);
                this.drawDot(graphics, n7, n6);
                ++n7;
            }
        } else {
            double d3 = (n4 - n2) / (n5 - n3);
            n6 = n3;
            while (n6 <= n5) {
                n7 = (int)Math.rint((double)n2 + (double)(n6 - n3) * d3);
                this.drawDot(graphics, n7, n6);
                ++n6;
            }
        }
    }

    private void drawDot(Graphics graphics, int n2, int n3) {
        if ((n2 + n3) % 2 == 0) {
            graphics.drawLine(n2, n3, n2, n3);
        }
    }
}

