/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.BasicPlayer;
import com.sun.media.ui.ColumnList;
import com.sun.media.ui.TabControl;
import com.sun.media.ui.UrlLabel;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.CachingControl;
import javax.media.Control;
import javax.media.Controller;
import javax.media.Duration;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.Player;
import javax.media.Time;
import javax.media.control.BitRateControl;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;

public class PropertySheet
extends Dialog
implements WindowListener,
ActionListener {
    private Player player;
    private Vector vectorControlBitRate = new Vector(1);
    private Vector vectorLabelBitRate = new Vector(1);
    private FrameRateControl controlFrameRate = null;
    private Vector vectorTrackFormats = new Vector();
    private int nAudioTrackCount = 0;
    private int nVideoTrackCount = 0;
    private Vector vectorMiscControls = new Vector();
    private Button buttonClose;
    private Label labelDuration = null;
    private Label labelPosition = null;
    private Label labelBitRate = null;
    private Label labelFrameRate = null;
    private ColumnList columnListAudio;
    private ColumnList columnListVideo;
    private static final String STR_UNKNOWN = JMFI18N.getResource("propertysheet.unknown");
    private static final String STR_UNBOUNDED = JMFI18N.getResource("propertysheet.unbounded");

    public PropertySheet(Frame frame, Player player) {
        super(frame, JMFI18N.getResource("propertysheet.title"), false);
        this.player = player;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(Color.lightGray);
        Panel panel = this.createPanelButtons();
        this.add((Component)panel, "South");
        panel = this.createPanelProperties();
        this.add((Component)panel, "Center");
        Canvas canvas = new Canvas();
        this.add((Component)canvas, "North");
        canvas = new Canvas();
        this.add((Component)canvas, "East");
        canvas = new Canvas();
        this.add((Component)canvas, "West");
        this.pack();
        this.addWindowListener(this);
        this.setResizable(false);
        Dimension dimension = this.getPreferredSize();
        if (dimension.width > 480) {
            dimension.width = 480;
        }
        ((Component)this).setBounds(100, 100, dimension.width, dimension.height);
        this.repaint();
    }

    private Panel createPanelProperties() throws Exception {
        TabControl tabControl = new TabControl(0);
        Panel panel = this.createPanelGeneral();
        tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.general"));
        if (this.nVideoTrackCount > 0) {
            panel = this.createPanelVideo(this.vectorTrackFormats);
            tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.video"));
        }
        if (this.nAudioTrackCount > 0) {
            panel = this.createPanelAudio(this.vectorTrackFormats);
            tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.audio"));
        }
        if (!this.vectorMiscControls.isEmpty()) {
            panel = this.createPanelMisc();
            tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.misc"));
        }
        this.update();
        return tabControl;
    }

    private Panel createPanelGeneral() throws Exception {
        Label label;
        String string = null;
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout(8, 4));
        panel.add((Component)panel2, "North");
        Panel panel3 = new Panel(new GridLayout(0, 1, 4, 4));
        panel2.add((Component)panel3, "West");
        Panel panel4 = new Panel(new GridLayout(0, 1, 4, 4));
        panel2.add((Component)panel4, "Center");
        if (this.player instanceof BasicPlayer) {
            BasicPlayer basicPlayer = (BasicPlayer)this.player;
            MediaLocator mediaLocator = basicPlayer.getMediaLocator();
            if (mediaLocator != null) {
                string = mediaLocator.toString();
            }
            if (string != null) {
                label = new Label(JMFI18N.getResource("propertysheet.general.medialocation"), 2);
                panel3.add(label);
                UrlLabel urlLabel = new UrlLabel(string);
                panel4.add(urlLabel);
            }
            if ((string = basicPlayer.getContentType()) != null) {
                string = new ContentDescriptor(string).toString();
                label = new Label(JMFI18N.getResource("propertysheet.general.contenttype"), 2);
                panel3.add(label);
                label = new Label(string);
                panel4.add(label);
            }
        }
        label = new Label(JMFI18N.getResource("propertysheet.general.duration"), 2);
        panel3.add(label);
        this.labelDuration = new Label();
        panel4.add(this.labelDuration);
        label = new Label(JMFI18N.getResource("propertysheet.general.position"), 2);
        panel3.add(label);
        this.labelPosition = new Label();
        panel4.add(this.labelPosition);
        this.nAudioTrackCount = 0;
        this.nVideoTrackCount = 0;
        Control[] controlArray = this.player.getControls();
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (controlArray[n2] != null) {
                if (controlArray[n2] instanceof FormatControl && (!(controlArray[n2] instanceof Owned) || !(((Owned)((Object)controlArray[n2])).getOwner() instanceof SourceStream) && !(((Owned)((Object)controlArray[n2])).getOwner() instanceof DataSource))) {
                    Format format = ((FormatControl)controlArray[n2]).getFormat();
                    this.vectorTrackFormats.addElement(format);
                    if (format instanceof AudioFormat) {
                        ++this.nAudioTrackCount;
                    } else if (format instanceof VideoFormat) {
                        ++this.nVideoTrackCount;
                    }
                }
                if (!(controlArray[n2] instanceof TrackControl)) {
                    if (controlArray[n2] instanceof BitRateControl) {
                        BitRateControl bitRateControl = (BitRateControl)controlArray[n2];
                        if (bitRateControl instanceof Owned && ((Owned)((Object)bitRateControl)).getOwner() instanceof Controller) {
                            this.vectorControlBitRate.addElement(bitRateControl);
                            label = new Label(JMFI18N.getResource("propertysheet.general.bitrate"), 2);
                            panel3.add(label);
                            this.labelBitRate = new Label();
                            this.vectorLabelBitRate.addElement(this.labelBitRate);
                            panel4.add(this.labelBitRate);
                        } else {
                            this.vectorMiscControls.addElement(controlArray[n2]);
                        }
                    } else if (controlArray[n2] instanceof FrameRateControl) {
                        FrameRateControl frameRateControl = (FrameRateControl)controlArray[n2];
                        if (frameRateControl instanceof Owned && ((Owned)((Object)frameRateControl)).getOwner() instanceof Controller) {
                            this.controlFrameRate = frameRateControl;
                            label = new Label(JMFI18N.getResource("propertysheet.general.framerate"), 2);
                            panel3.add(label);
                            this.labelFrameRate = new Label();
                            panel4.add(this.labelFrameRate);
                        } else {
                            this.vectorMiscControls.addElement(controlArray[n2]);
                        }
                    } else if (!(controlArray[n2] instanceof GainControl || controlArray[n2] instanceof MonitorControl || controlArray[n2] instanceof Owned && (((Owned)((Object)controlArray[n2])).getOwner() instanceof CaptureDevice || ((Owned)((Object)controlArray[n2])).getOwner() instanceof SourceStream || ((Owned)((Object)controlArray[n2])).getOwner() instanceof DataSource) || controlArray[n2] instanceof CachingControl)) {
                        this.vectorMiscControls.addElement(controlArray[n2]);
                    }
                }
            }
            ++n2;
        }
        return panel;
    }

    private Panel createPanelVideo(Vector vector) throws Exception {
        String[] stringArray = new String[]{JMFI18N.getResource("propertysheet.video.track"), JMFI18N.getResource("propertysheet.video.encoding"), JMFI18N.getResource("propertysheet.video.size"), JMFI18N.getResource("propertysheet.video.framerate")};
        Panel panel = new Panel(new BorderLayout());
        this.columnListVideo = new ColumnList(stringArray);
        Object[] objectArray = new String[stringArray.length];
        int n2 = vector.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Object e2 = vector.elementAt(n4);
            if (e2 instanceof VideoFormat) {
                VideoFormat videoFormat = (VideoFormat)e2;
                objectArray[0] = new String("" + ++n3);
                objectArray[1] = videoFormat.getEncoding();
                Dimension dimension = videoFormat.getSize();
                objectArray[2] = dimension == null ? new String(STR_UNKNOWN) : new String("" + dimension.width + " x " + dimension.height);
                float f2 = videoFormat.getFrameRate();
                objectArray[3] = f2 == -1.0f ? STR_UNKNOWN : "" + f2;
                this.columnListVideo.addRow(objectArray);
            }
            ++n4;
        }
        this.columnListVideo.setColumnWidthAsPreferred();
        panel.add((Component)this.columnListVideo, "Center");
        return panel;
    }

    private Panel createPanelAudio(Vector vector) throws Exception {
        String[] stringArray = new String[]{JMFI18N.getResource("propertysheet.audio.track"), JMFI18N.getResource("propertysheet.audio.encoding"), JMFI18N.getResource("propertysheet.audio.samplerate"), JMFI18N.getResource("propertysheet.audio.bitspersample"), JMFI18N.getResource("propertysheet.audio.channels")};
        Panel panel = new Panel(new BorderLayout());
        this.columnListAudio = new ColumnList(stringArray);
        Object[] objectArray = new String[stringArray.length];
        int n2 = vector.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Object e2 = vector.elementAt(n4);
            if (e2 instanceof AudioFormat) {
                AudioFormat audioFormat = (AudioFormat)e2;
                objectArray[0] = new String("" + ++n3);
                objectArray[1] = audioFormat.getEncoding();
                double d2 = audioFormat.getSampleRate();
                objectArray[2] = d2 == -1.0 ? STR_UNKNOWN : "" + d2;
                int n5 = audioFormat.getSampleSizeInBits();
                objectArray[3] = n5 == -1 ? STR_UNKNOWN : "" + n5;
                n5 = audioFormat.getChannels();
                objectArray[4] = n5 == -1 ? STR_UNKNOWN : (n5 == 1 ? "" + n5 + " (" + JMFI18N.getResource("propertysheet.audio.channels.mono") + ")" : (n5 == 2 ? "" + n5 + " (" + JMFI18N.getResource("propertysheet.audio.channels.stereo") + ")" : "" + n5));
                this.columnListAudio.addRow(objectArray);
            }
            ++n4;
        }
        this.columnListAudio.setColumnWidthAsPreferred();
        panel.add((Component)this.columnListAudio, "Center");
        return panel;
    }

    private Panel createPanelMisc() throws Exception {
        Panel panel;
        Panel panel2 = panel = new Panel(new BorderLayout(6, 6));
        int n2 = this.vectorMiscControls.size();
        int n3 = 0;
        while (n3 < n2) {
            Control control = (Control)this.vectorMiscControls.elementAt(n3);
            Component component = control.getControlComponent();
            if (component != null && component.getParent() == null) {
                Panel panel3 = new Panel(new BorderLayout(6, 6));
                panel3.add(component, "West");
                Panel panel4 = new Panel(new BorderLayout(6, 6));
                panel4.add((Component)panel3, "North");
                panel2.add((Component)panel4, "Center");
                panel2 = panel4;
            }
            ++n3;
        }
        return panel;
    }

    private Panel createPanelButtons() throws Exception {
        Panel panel = new Panel(new FlowLayout(2));
        Panel panel2 = new Panel(new GridLayout(1, 0, 6, 6));
        panel.add(panel2);
        this.buttonClose = new Button(JMFI18N.getResource("propertysheet.close"));
        this.buttonClose.addActionListener(this);
        panel2.add(this.buttonClose);
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.buttonClose.getLabel())) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    void update() {
        this.updateBitRate();
        this.updateFrameRate();
        this.updateMediaTime();
        this.updateDuration();
    }

    void updateDuration() {
        if (this.labelDuration != null) {
            Time time = this.player.getDuration();
            this.labelDuration.setText(this.formatTime(time));
        }
    }

    void updateBitRate() {
        if (this.vectorLabelBitRate.size() > 0) {
            int n2 = 0;
            while (n2 < this.vectorLabelBitRate.size()) {
                Label label = (Label)this.vectorLabelBitRate.elementAt(n2);
                BitRateControl bitRateControl = (BitRateControl)this.vectorControlBitRate.elementAt(n2);
                int n3 = bitRateControl.getBitRate();
                label.setText(Float.toString((float)n3 / 1000.0f) + " " + JMFI18N.getResource("propertysheet.kbps"));
                ++n2;
            }
        }
    }

    void updateFrameRate() {
        if (this.labelFrameRate != null && this.controlFrameRate != null) {
            float f2 = this.controlFrameRate.getFrameRate();
            this.labelFrameRate.setText(Float.toString(f2) + " " + JMFI18N.getResource("propertysheet.fps"));
        }
    }

    void clearBRFR() {
        if (this.labelFrameRate != null) {
            this.labelFrameRate.setText("0.0 " + JMFI18N.getResource("propertysheet.fps"));
        }
        if (this.labelBitRate != null) {
            this.labelBitRate.setText("0.0 " + JMFI18N.getResource("propertysheet.kbps"));
        }
    }

    void updateMediaTime() {
        if (this.labelPosition != null) {
            Time time = this.player.getMediaTime();
            this.labelPosition.setText(this.formatTime(time));
        }
    }

    private String formatTime(Time time) {
        String string = new String(STR_UNKNOWN);
        if (time == null || time == Time.TIME_UNKNOWN || time == Duration.DURATION_UNKNOWN) {
            return string;
        }
        if (time == Duration.DURATION_UNBOUNDED) {
            return STR_UNBOUNDED;
        }
        long l2 = time.getNanoseconds();
        int n2 = (int)(l2 / 1000000000L);
        int n3 = n2 / 3600;
        int n4 = (n2 - n3 * 3600) / 60;
        n2 = n2 - n3 * 3600 - n4 * 60;
        l2 = l2 % 1000000000L / 10000000L;
        int n5 = n3 / 10;
        int n6 = n4 / 10;
        int n7 = n2 / 10;
        long l3 = l2 / 10L;
        string = new String("" + n5 + (n3 %= 10) + ":" + n6 + (n4 %= 10) + ":" + n7 + (n2 %= 10) + "." + l3 + (l2 %= 10L));
        return string;
    }
}

