/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Scroll
extends Component
implements MouseListener,
MouseMotionListener {
    Image imageGrabber = BasicComp.fetchImage("grabber.gif");
    Image imageGrabberX;
    Image imageGrabberDown = BasicComp.fetchImage("grabber-pressed.gif");
    Graphics paintG = null;
    boolean grabbed;
    boolean entered;
    int grabberPosition;
    int leftBorder = 8;
    int rightBorder = 8;
    int sliderWidth;
    int width;
    int height;
    int displayPercent;
    float[] detents;
    Dimension dimension;
    float lower = 0.0f;
    float upper = 1.0f;
    float range = 1.0f;
    float value = 0.5f;
    boolean dragging = false;
    boolean grabberVisible = true;
    ActionListener actionListener = null;

    public Scroll() {
        this(null, null);
    }

    public Scroll(float[] fArray) {
        this(fArray, null);
    }

    public Scroll(float[] fArray, Color color) {
        this.imageGrabberX = BasicComp.fetchImage("grabber-disabled.gif");
        this.detents = fArray;
        if (color != null) {
            this.setBackground(color);
        }
        this.width = 115;
        this.height = 18;
        this.displayPercent = 100;
        this.dimension = new Dimension(this.width, this.height);
        this.sliderWidth = this.width - this.leftBorder - this.rightBorder;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.grabbed = false;
        this.entered = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setValue(float f2) {
        this.lower = 0.0f;
        this.upper = 1.0f;
        this.range = this.upper - this.lower;
        this.setSliderPosition(f2 - this.lower, this.range);
        this.repaint();
    }

    public float getValue() {
        return this.value;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public Point getPosition() {
        return new Point(this.grabberPosition + this.leftBorder, 10);
    }

    public void setDisplayPercent(int n2) {
        if (n2 != this.displayPercent) {
            this.displayPercent = n2;
            if (this.displayPercent > 100) {
                this.displayPercent = 100;
            } else if (this.displayPercent < 0) {
                this.displayPercent = 0;
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n2;
        Dimension dimension = this.getSize();
        int n3 = dimension.height / 2 - 2;
        this.paintG = graphics;
        int n4 = this.grabberPosition + this.leftBorder - 5;
        graphics.setColor(this.getBackground());
        n3 = this.getSize().height / 2 - 2;
        graphics.draw3DRect(2, n3, dimension.width - 4, 3, false);
        if (this.displayPercent < 100) {
            graphics.setColor(Color.green);
            n2 = this.sliderWidth * this.displayPercent / 100 + 3;
            graphics.drawLine(n2, n3 += 2, dimension.width - 4, n3);
        }
        if (this.detents != null && this.detents.length != 0) {
            this.paintG.setColor(Color.black);
            int n5 = 0;
            while (n5 < this.detents.length) {
                n2 = this.leftBorder + (int)(this.detents[n5] * (float)this.sliderWidth / this.range);
                this.paintG.drawLine(n2, 12, n2, 15);
                ++n5;
            }
        }
        if (this.grabberVisible) {
            Image image = this.isEnabled() ? (this.grabbed || this.entered ? this.imageGrabberDown : this.imageGrabber) : this.imageGrabberX;
            this.paintG.drawImage(image, n4, 4, this);
        }
    }

    private int limitGrabber(int n2) {
        int n3 = n2 - this.leftBorder;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.sliderWidth) {
            n3 = this.sliderWidth;
        }
        return n3;
    }

    private void setSliderPosition(float f2, float f3) {
        this.grabberPosition = (int)(f2 / f3 * (float)this.sliderWidth);
    }

    private void seek() {
        this.value = (float)this.grabberPosition / (float)this.sliderWidth;
        if (this.detents != null && this.detents.length > 0 && this.dragging) {
            float f2 = 0.05f;
            int n2 = 0;
            while (n2 < this.detents.length) {
                if (Math.abs(this.detents[n2] - this.value) <= f2) {
                    this.value = this.detents[n2];
                }
                ++n2;
            }
        }
        this.repaint();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "scroll"));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) == 0 && (n2 & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = true;
            this.grabberPosition = this.limitGrabber(mouseEvent.getX());
            this.seek();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) == 0 && (n2 & 4) == 0 && this.isEnabled()) {
            this.dragging = false;
            this.grabbed = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 8) == 0 && (n2 & 4) == 0 && this.isEnabled()) {
            this.dragging = true;
            this.grabberPosition = this.limitGrabber(mouseEvent.getX());
            this.seek();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.entered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.entered = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setSize(int n2, int n3) {
        super.setSize(n2, n3);
        this.paintG = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }
}

