/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.VideoSize;
import com.sun.media.util.JMFI18N;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

class VideoSizeControl
extends Panel
implements ItemListener,
ComponentListener {
    private Choice comboSize;
    private Panel panelCustom;
    private TextField textWidth;
    private TextField textHeight;
    private Label labelX;
    private Hashtable htSizes = new Hashtable();
    private VideoSize sizeVideoDefault = null;
    private ActionListener listener;
    public static final String ACTION_SIZE_CHANGED = "Size Changed";
    static final String CUSTOM_STRING = JMFI18N.getResource("formatchooser.custom");

    public VideoSizeControl() {
        this((VideoSize)null);
    }

    public VideoSizeControl(VideoSize videoSize) {
        this.sizeVideoDefault = videoSize;
        this.init();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.comboSize.setEnabled(bl);
        this.textWidth.setEnabled(bl);
        this.textHeight.setEnabled(bl);
        this.labelX.setEnabled(bl);
        if (bl) {
            this.updateFields();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public VideoSize getVideoSize() {
        VideoSize videoSize;
        String string = this.comboSize.getSelectedItem();
        Object v = this.htSizes.get(string);
        if (v == null || !(v instanceof VideoSize) || string.equals(CUSTOM_STRING)) {
            int n2;
            int n3;
            try {
                n3 = Integer.valueOf(this.textWidth.getText());
            }
            catch (Exception exception) {
                n3 = 0;
            }
            try {
                n2 = Integer.valueOf(this.textHeight.getText());
            }
            catch (Exception exception) {
                n2 = 0;
            }
            videoSize = new VideoSize(n3, n2);
        } else {
            videoSize = (VideoSize)v;
        }
        return videoSize;
    }

    public void addItem(VideoSize videoSize) {
        String string;
        if (videoSize == null) {
            videoSize = new VideoSize(-1, -1);
            string = CUSTOM_STRING;
        } else {
            string = videoSize.toString();
        }
        if (this.htSizes.containsKey(string)) {
            return;
        }
        this.comboSize.addItem(string);
        this.htSizes.put(string, videoSize);
        if (this.comboSize.getItemCount() == 1) {
            this.updateFields();
        }
    }

    public void removeAll() {
        this.comboSize.removeAll();
        this.htSizes = new Hashtable();
        this.updateFields();
    }

    public void select(VideoSize videoSize) {
        if (videoSize == null) {
            this.comboSize.select(CUSTOM_STRING);
        } else {
            this.comboSize.select(videoSize.toString());
        }
        this.updateFields();
    }

    public void select(int n2) {
        this.comboSize.select(n2);
        this.updateFields();
    }

    public int getItemCount() {
        return this.comboSize.getItemCount();
    }

    private void init() {
        this.setLayout(new GridLayout(0, 1, 4, 4));
        this.comboSize = new Choice();
        this.comboSize.addItem(CUSTOM_STRING);
        this.comboSize.addItemListener(this);
        this.add(this.comboSize);
        this.panelCustom = new Panel(null);
        this.panelCustom.addComponentListener(this);
        this.add(this.panelCustom);
        this.textWidth = this.sizeVideoDefault == null ? new TextField(3) : new TextField("" + this.sizeVideoDefault.width, 3);
        this.panelCustom.add((Component)this.textWidth, "Center");
        this.labelX = new Label("x", 1);
        this.panelCustom.add((Component)this.labelX, "West");
        this.textHeight = this.sizeVideoDefault == null ? new TextField(3) : new TextField("" + this.sizeVideoDefault.height, 3);
        this.panelCustom.add((Component)this.textHeight, "Center");
        this.updateFields();
    }

    private void updateFields() {
        boolean bl;
        String string = this.comboSize.getSelectedItem();
        if (string == null || string.equals(CUSTOM_STRING)) {
            bl = true;
        } else {
            VideoSize videoSize = (VideoSize)this.htSizes.get(string);
            this.textWidth.setText("" + videoSize.width);
            this.textHeight.setText("" + videoSize.height);
            bl = false;
        }
        this.textWidth.setEnabled(bl);
        this.textHeight.setEnabled(bl);
        this.labelX.setEnabled(bl);
    }

    private void resizeCustomFields() {
        Dimension dimension = this.panelCustom.getSize();
        Dimension dimension2 = this.labelX.getPreferredSize();
        int n2 = (dimension.width - dimension2.width) / 2;
        this.textWidth.setBounds(0, 0, n2, dimension.height);
        this.labelX.setBounds(n2, 0, dimension2.width, dimension.height);
        this.textHeight.setBounds(n2 + dimension2.width, 0, n2, dimension.height);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object != this.comboSize) {
            return;
        }
        this.updateFields();
        if (this.listener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_SIZE_CHANGED);
            this.listener.actionPerformed(actionEvent);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeCustomFields();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

