/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class H263Format
extends VideoFormat {
    private static String ENCODING = "h263";
    protected int advancedPrediction = -1;
    protected int arithmeticCoding = -1;
    protected int errorCompensation = -1;
    protected int hrDB = -1;
    protected int pbFrames = -1;
    protected int unrestrictedVector = -1;

    public H263Format() {
        super(ENCODING);
    }

    public H263Format(Dimension dimension, int n2, Class clazz, float f2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(ENCODING, dimension, n2, clazz, f2);
        this.advancedPrediction = n3;
        this.arithmeticCoding = n4;
        this.errorCompensation = n5;
        this.hrDB = n6;
        this.pbFrames = n7;
        this.unrestrictedVector = n8;
    }

    public int getAdvancedPrediction() {
        return this.advancedPrediction;
    }

    public int getArithmeticCoding() {
        return this.arithmeticCoding;
    }

    public int getErrorCompensation() {
        return this.errorCompensation;
    }

    public int getHrDB() {
        return this.hrDB;
    }

    public int getPBFrames() {
        return this.pbFrames;
    }

    public int getUnrestrictedVector() {
        return this.unrestrictedVector;
    }

    public String toString() {
        return "H.263 video format";
    }

    public boolean equals(Object object) {
        if (object instanceof H263Format) {
            H263Format h263Format = (H263Format)object;
            return super.equals(object) && this.advancedPrediction == h263Format.advancedPrediction && this.arithmeticCoding == h263Format.arithmeticCoding && this.errorCompensation == h263Format.errorCompensation && this.hrDB == h263Format.hrDB && this.pbFrames == h263Format.pbFrames && this.unrestrictedVector == h263Format.unrestrictedVector;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof H263Format)) {
            return true;
        }
        H263Format h263Format = (H263Format)format;
        return !(this.advancedPrediction != -1 && h263Format.advancedPrediction != -1 && this.advancedPrediction != h263Format.advancedPrediction || this.arithmeticCoding != -1 && h263Format.arithmeticCoding != -1 && this.arithmeticCoding != h263Format.arithmeticCoding || this.errorCompensation != -1 && h263Format.errorCompensation != -1 && this.errorCompensation != h263Format.errorCompensation || this.hrDB != -1 && h263Format.hrDB != -1 && this.hrDB != h263Format.hrDB || this.pbFrames != -1 && h263Format.pbFrames != -1 && this.pbFrames != h263Format.pbFrames || this.unrestrictedVector != -1 && h263Format.unrestrictedVector != -1 && this.unrestrictedVector != h263Format.unrestrictedVector);
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof H263Format)) {
            return format2;
        }
        H263Format h263Format = (H263Format)format;
        H263Format h263Format2 = (H263Format)format2;
        h263Format2.advancedPrediction = this.advancedPrediction != -1 ? this.advancedPrediction : h263Format.advancedPrediction;
        h263Format2.arithmeticCoding = this.arithmeticCoding != -1 ? this.arithmeticCoding : h263Format.arithmeticCoding;
        h263Format2.errorCompensation = this.errorCompensation != -1 ? this.errorCompensation : h263Format.errorCompensation;
        h263Format2.hrDB = this.hrDB != -1 ? this.hrDB : h263Format.hrDB;
        h263Format2.pbFrames = this.pbFrames != -1 ? this.pbFrames : h263Format.pbFrames;
        h263Format2.unrestrictedVector = this.unrestrictedVector != -1 ? this.unrestrictedVector : h263Format.unrestrictedVector;
        return h263Format2;
    }

    public Object clone() {
        H263Format h263Format = new H263Format();
        h263Format.copy(this);
        return h263Format;
    }

    protected void copy(Format format) {
        super.copy(format);
        H263Format h263Format = (H263Format)format;
        this.advancedPrediction = h263Format.advancedPrediction;
        this.arithmeticCoding = h263Format.arithmeticCoding;
        this.errorCompensation = h263Format.errorCompensation;
        this.hrDB = h263Format.hrDB;
        this.pbFrames = h263Format.pbFrames;
        this.unrestrictedVector = h263Format.unrestrictedVector;
    }
}

