/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.util.JMAppsCfg;
import jmapps.util.JMFUtils;

public class CaptureDialog
extends JMDialog
implements ItemListener {
    private JMAppsCfg cfgJMApps;
    private Vector vectorDevices = null;
    private Vector vectorAudioDevices = null;
    private Vector vectorVideoDevices = null;
    private Panel panelDevices;
    private Checkbox checkUseVideo = null;
    private Checkbox checkUseAudio = null;
    private Choice comboVideoDevice = null;
    private Choice comboAudioDevice = null;
    private Panel panelVideoFormat = null;
    private Panel panelAudioFormat = null;
    private AudioFormatChooser chooserAudio = null;
    private VideoFormatChooser chooserVideo = null;
    private Button buttonOK;
    private Button buttonCancel;

    public CaptureDialog(Frame frame, JMAppsCfg jMAppsCfg) {
        super(frame, JMFI18N.getResource("jmstudio.capture.title"), true);
        this.cfgJMApps = jMAppsCfg;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isVideoDeviceUsed() {
        boolean bl = false;
        if (this.checkUseVideo != null) {
            bl = this.checkUseVideo.getState();
        }
        return bl;
    }

    public boolean isAudioDeviceUsed() {
        boolean bl = false;
        if (this.checkUseAudio != null) {
            bl = this.checkUseAudio.getState();
        }
        return bl;
    }

    public CaptureDeviceInfo getVideoDevice() {
        CaptureDeviceInfo captureDeviceInfo = null;
        if (this.comboVideoDevice != null && this.isVideoDeviceUsed()) {
            int n2 = this.comboVideoDevice.getSelectedIndex();
            captureDeviceInfo = (CaptureDeviceInfo)this.vectorVideoDevices.elementAt(n2);
        }
        return captureDeviceInfo;
    }

    public CaptureDeviceInfo getAudioDevice() {
        CaptureDeviceInfo captureDeviceInfo = null;
        if (this.comboAudioDevice != null && this.isAudioDeviceUsed()) {
            int n2 = this.comboAudioDevice.getSelectedIndex();
            captureDeviceInfo = (CaptureDeviceInfo)this.vectorAudioDevices.elementAt(n2);
        }
        return captureDeviceInfo;
    }

    public VideoFormat getVideoFormat() {
        VideoFormat videoFormat = null;
        if (this.chooserVideo != null && this.isVideoDeviceUsed()) {
            videoFormat = (VideoFormat)this.chooserVideo.getFormat();
        }
        return videoFormat;
    }

    public AudioFormat getAudioFormat() {
        AudioFormat audioFormat = null;
        if (this.chooserAudio != null && this.isAudioDeviceUsed()) {
            audioFormat = (AudioFormat)this.chooserAudio.getFormat();
        }
        return audioFormat;
    }

    public DataSource createCaptureDataSource() {
        DataSource dataSource = null;
        String string = null;
        String string2 = null;
        CaptureDeviceInfo captureDeviceInfo = this.getAudioDevice();
        if (captureDeviceInfo != null && this.isAudioDeviceUsed()) {
            string = captureDeviceInfo.getName();
        }
        if ((captureDeviceInfo = this.getVideoDevice()) != null && this.isVideoDeviceUsed()) {
            string2 = captureDeviceInfo.getName();
        }
        dataSource = JMFUtils.createCaptureDataSource(string, this.getAudioFormat(), string2, this.getVideoFormat());
        return dataSource;
    }

    private void init() throws Exception {
        Panel panel;
        this.setLayout(new BorderLayout());
        JMPanel jMPanel = new JMPanel(new BorderLayout());
        jMPanel.setEmptyBorder(6, 6, 6, 6);
        jMPanel.setBackground(Color.lightGray);
        this.add((Component)jMPanel, "Center");
        this.vectorDevices = CaptureDeviceManager.getDeviceList(null);
        if (this.vectorDevices == null || this.vectorDevices.size() < 1) {
            Label label = new Label(JMFI18N.getResource("jmstudio.capture.nodevices"));
            jMPanel.add((Component)label, "Center");
        } else {
            this.panelDevices = new Panel(new GridLayout(1, 0, 6, 6));
            jMPanel.add((Component)this.panelDevices, "Center");
            panel = this.createVideoPanel();
            if (panel != null) {
                this.panelDevices.add(panel);
            }
            if ((panel = this.createAudioPanel()) != null) {
                this.panelDevices.add(panel);
            }
        }
        panel = new JMPanel(new FlowLayout(1));
        jMPanel.add((Component)panel, "South");
        JMPanel jMPanel2 = this.vectorDevices != null && this.vectorDevices.size() > 0 ? this.createButtonPanel(new String[]{JMDialog.ACTION_OK, JMDialog.ACTION_CANCEL}) : this.createButtonPanel(new String[]{JMDialog.ACTION_OK});
        panel.add(jMPanel2);
        this.pack();
        this.setResizable(false);
    }

    private Panel createVideoPanel() throws Exception {
        CaptureDeviceInfo captureDeviceInfo;
        boolean bl = true;
        VideoFormat videoFormat = null;
        JMAppsCfg.CaptureDeviceData captureDeviceData = null;
        int n2 = this.vectorDevices.size();
        this.vectorVideoDevices = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            captureDeviceInfo = (CaptureDeviceInfo)this.vectorDevices.elementAt(n3);
            Format[] formatArray = captureDeviceInfo.getFormats();
            int n4 = 0;
            while (n4 < formatArray.length) {
                if (formatArray[n4] instanceof VideoFormat) {
                    this.vectorVideoDevices.addElement(captureDeviceInfo);
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        if (this.vectorVideoDevices.isEmpty()) {
            return null;
        }
        if (this.cfgJMApps != null) {
            captureDeviceData = this.cfgJMApps.getLastCaptureVideoData();
        }
        if (captureDeviceData != null) {
            bl = captureDeviceData.boolUse;
            if (captureDeviceData.format instanceof VideoFormat) {
                videoFormat = (VideoFormat)captureDeviceData.format;
            }
        }
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        jMPanel.setEtchedBorder();
        JMPanel jMPanel2 = new JMPanel(new BorderLayout(6, 6));
        jMPanel2.setEmptyBorder(6, 6, 6, 6);
        jMPanel.add((Component)jMPanel2, "Center");
        Panel panel = jMPanel2;
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "North");
        this.checkUseVideo = new Checkbox(JMFI18N.getResource("jmstudio.capture.video.usedevice"), bl);
        this.checkUseVideo.addItemListener(this);
        panel2.add((Component)this.checkUseVideo, "West");
        panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "Center");
        panel = panel2;
        panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "North");
        this.comboVideoDevice = new Choice();
        panel2.add((Component)this.comboVideoDevice, "Center");
        n2 = this.vectorVideoDevices.size();
        boolean bl2 = false;
        n3 = 0;
        while (n3 < n2) {
            captureDeviceInfo = (CaptureDeviceInfo)this.vectorVideoDevices.elementAt(n3);
            String string = captureDeviceInfo.getName();
            this.comboVideoDevice.addItem(string);
            if (!bl2 && captureDeviceData != null && captureDeviceData.strDeviceName != null) {
                bl2 = captureDeviceData.strDeviceName.equals(string);
            }
            ++n3;
        }
        if (bl2) {
            this.comboVideoDevice.select(captureDeviceData.strDeviceName);
        }
        this.comboVideoDevice.addItemListener(this);
        this.comboVideoDevice.setEnabled(bl);
        this.panelVideoFormat = new Panel(new BorderLayout(6, 6));
        panel.add((Component)this.panelVideoFormat, "Center");
        this.createVideoChooser(videoFormat);
        if (this.chooserVideo != null) {
            this.chooserVideo.setEnabled(bl);
        }
        return jMPanel;
    }

    private void createVideoChooser(VideoFormat videoFormat) {
        if (this.panelVideoFormat == null) {
            return;
        }
        this.panelVideoFormat.removeAll();
        int n2 = this.comboVideoDevice.getSelectedIndex();
        CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)this.vectorVideoDevices.elementAt(n2);
        Format[] formatArray = captureDeviceInfo.getFormats();
        this.chooserVideo = new VideoFormatChooser(formatArray, videoFormat, false, null, true);
        this.panelVideoFormat.add((Component)this.chooserVideo, "Center");
    }

    private Panel createAudioPanel() throws Exception {
        CaptureDeviceInfo captureDeviceInfo;
        boolean bl = true;
        AudioFormat audioFormat = null;
        JMAppsCfg.CaptureDeviceData captureDeviceData = null;
        int n2 = this.vectorDevices.size();
        this.vectorAudioDevices = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            captureDeviceInfo = (CaptureDeviceInfo)this.vectorDevices.elementAt(n3);
            Format[] formatArray = captureDeviceInfo.getFormats();
            int n4 = 0;
            while (n4 < formatArray.length) {
                if (formatArray[n4] instanceof AudioFormat) {
                    this.vectorAudioDevices.addElement(captureDeviceInfo);
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        if (this.vectorAudioDevices.isEmpty()) {
            return null;
        }
        if (this.cfgJMApps != null) {
            captureDeviceData = this.cfgJMApps.getLastCaptureAudioData();
        }
        if (captureDeviceData != null) {
            bl = captureDeviceData.boolUse;
            if (captureDeviceData.format instanceof AudioFormat) {
                audioFormat = (AudioFormat)captureDeviceData.format;
            }
        }
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        jMPanel.setEtchedBorder();
        JMPanel jMPanel2 = new JMPanel(new BorderLayout(6, 6));
        jMPanel2.setEmptyBorder(6, 6, 6, 6);
        jMPanel.add((Component)jMPanel2, "Center");
        Panel panel = jMPanel2;
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "North");
        this.checkUseAudio = new Checkbox(JMFI18N.getResource("jmstudio.capture.audio.usedevice"), bl);
        this.checkUseAudio.addItemListener(this);
        panel2.add((Component)this.checkUseAudio, "West");
        panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "Center");
        panel = panel2;
        panel2 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel2, "North");
        this.comboAudioDevice = new Choice();
        panel2.add((Component)this.comboAudioDevice, "Center");
        n2 = this.vectorAudioDevices.size();
        boolean bl2 = false;
        n3 = 0;
        while (n3 < n2) {
            captureDeviceInfo = (CaptureDeviceInfo)this.vectorAudioDevices.elementAt(n3);
            String string = captureDeviceInfo.getName();
            this.comboAudioDevice.addItem(string);
            if (!bl2 && captureDeviceData != null && captureDeviceData.strDeviceName != null) {
                bl2 = captureDeviceData.strDeviceName.equals(string);
            }
            ++n3;
        }
        if (bl2) {
            this.comboAudioDevice.select(captureDeviceData.strDeviceName);
        }
        this.comboAudioDevice.addItemListener(this);
        this.comboAudioDevice.setEnabled(bl);
        this.panelAudioFormat = new Panel(new BorderLayout(6, 6));
        panel.add((Component)this.panelAudioFormat, "Center");
        this.createAudioChooser(audioFormat);
        if (this.chooserAudio != null) {
            this.chooserAudio.setEnabled(bl);
        }
        return jMPanel;
    }

    private void createAudioChooser(AudioFormat audioFormat) {
        if (this.panelAudioFormat == null) {
            return;
        }
        this.panelAudioFormat.removeAll();
        int n2 = this.comboAudioDevice.getSelectedIndex();
        CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)this.vectorAudioDevices.elementAt(n2);
        Format[] formatArray = captureDeviceInfo.getFormats();
        this.chooserAudio = new AudioFormatChooser(formatArray, audioFormat, false, null);
        this.panelAudioFormat.add((Component)this.chooserAudio, "Center");
    }

    private void saveCfgData() {
        if (this.cfgJMApps == null) {
            return;
        }
        JMAppsCfg.CaptureDeviceData captureDeviceData = this.cfgJMApps.createCaptureDeviceDataObject();
        captureDeviceData.boolUse = this.isAudioDeviceUsed();
        if (this.comboAudioDevice != null) {
            captureDeviceData.strDeviceName = this.comboAudioDevice.getSelectedItem();
        }
        if (this.chooserAudio != null) {
            captureDeviceData.format = this.chooserAudio.getFormat();
        }
        this.cfgJMApps.setLastCaptureAudioData(captureDeviceData);
        captureDeviceData = this.cfgJMApps.createCaptureDeviceDataObject();
        captureDeviceData.boolUse = this.isVideoDeviceUsed();
        if (this.comboVideoDevice != null) {
            captureDeviceData.strDeviceName = this.comboVideoDevice.getSelectedItem();
        }
        if (this.chooserVideo != null) {
            captureDeviceData.format = this.chooserVideo.getFormat();
        }
        this.cfgJMApps.setLastCaptureVideoData(captureDeviceData);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(JMDialog.ACTION_OK)) {
            this.setAction(JMDialog.ACTION_OK);
            this.saveCfgData();
        } else {
            this.setAction(JMDialog.ACTION_CANCEL);
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkUseVideo) {
            boolean bl = this.checkUseVideo.getState();
            this.comboVideoDevice.setEnabled(bl);
            this.chooserVideo.setEnabled(bl);
        } else if (object == this.checkUseAudio) {
            boolean bl = this.checkUseAudio.getState();
            this.comboAudioDevice.setEnabled(bl);
            this.chooserAudio.setEnabled(bl);
        } else if (object == this.comboVideoDevice) {
            this.createVideoChooser(null);
            this.validate();
        } else if (object == this.comboAudioDevice) {
            this.createAudioChooser(null);
            this.validate();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setAction(JMDialog.ACTION_CANCEL);
        this.dispose();
    }

    public String toString() {
        CaptureDeviceInfo captureDeviceInfo;
        MediaLocator mediaLocator;
        String string = "";
        CaptureDeviceInfo captureDeviceInfo2 = this.getAudioDevice();
        if (captureDeviceInfo2 != null && this.isAudioDeviceUsed()) {
            mediaLocator = captureDeviceInfo2.getLocator();
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + mediaLocator.toString();
        }
        if ((captureDeviceInfo = this.getVideoDevice()) != null && this.isVideoDeviceUsed()) {
            mediaLocator = captureDeviceInfo.getLocator();
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + mediaLocator.toString();
        }
        return string;
    }
}

