/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.ui.TabControl;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import jmapps.ui.ImageArea;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.ProgressDialog;
import jmapps.ui.ProgressThread;
import jmapps.ui.TrackPanelAudio;
import jmapps.ui.TrackPanelVideo;
import jmapps.util.JMAppsCfg;

public class SaveAsDialog
extends JMDialog
implements ControllerListener,
DataSinkListener,
ItemListener {
    private JMAppsCfg cfgJMApps;
    private String inputURL;
    private DataSource dataSource = null;
    private Processor processor = null;
    private DataSink dataSink = null;
    private TrackControl[] arrTrackControls;
    private int nAudioTrackCount = 0;
    private int nVideoTrackCount = 0;
    private String strContentType = null;
    private String strContentTypeExt = null;
    private boolean boolSaving = false;
    private ProgressDialog dlgProgress = null;
    private ProgressThread threadProgress = null;
    private Format captureFormat = null;
    private TabControl tabControl;
    private Hashtable hashtablePanelsAudio = new Hashtable();
    private Hashtable hashtablePanelsVideo = new Hashtable();
    private Button buttonSave;
    private Button buttonCancel;
    private Choice comboContentType;
    private Image imageAudioEn = null;
    private Image imageAudioDis = null;
    private Image imageVideoEn = null;
    private Image imageVideoDis = null;
    private String strFailMessage = null;
    private ContentDescriptor[] supportedCDs;
    private static final String STR_MSVIDEO = JMFI18N.getResource("jmstudio.saveas.type.msvideo");
    private static final String STR_QUICKTIME = JMFI18N.getResource("jmstudio.saveas.type.quicktime");
    private static final String STR_AIFF = JMFI18N.getResource("jmstudio.saveas.type.aiff");
    private static final String STR_GSM = JMFI18N.getResource("jmstudio.saveas.type.gsm");
    private static final String STR_WAVE = JMFI18N.getResource("jmstudio.saveas.type.wave");
    private static final String STR_BASIC_AUDIO = JMFI18N.getResource("jmstudio.saveas.type.basicaudio");
    private static final String STR_MPEG_AUDIO = JMFI18N.getResource("jmstudio.saveas.type.mpegaudio");
    Object stateLock = new Object();
    boolean stateFailed = false;

    public SaveAsDialog(Frame frame, String string, Format format, JMAppsCfg jMAppsCfg) {
        super(frame, JMFI18N.getResource("jmstudio.saveas.title"), false);
        this.cfgJMApps = jMAppsCfg;
        this.inputURL = string;
        this.captureFormat = format;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SaveAsDialog(Frame frame, DataSource dataSource, JMAppsCfg jMAppsCfg) {
        super(frame, JMFI18N.getResource("jmstudio.saveas.title"), false);
        this.cfgJMApps = jMAppsCfg;
        this.dataSource = dataSource;
        this.inputURL = "Capture";
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.imageAudioEn = ImageArea.loadImage("audio.gif", this, true);
        this.imageAudioDis = ImageArea.loadImage("audio-disabled.gif", this, true);
        this.imageVideoEn = ImageArea.loadImage("video.gif", this, true);
        this.imageVideoDis = ImageArea.loadImage("video-disabled.gif", this, true);
        this.frameOwner.setCursor(new Cursor(3));
        if (this.dataSource == null) {
            try {
                FormatControl[] formatControlArray;
                MediaLocator mediaLocator = new MediaLocator(this.inputURL);
                this.dataSource = Manager.createDataSource(mediaLocator);
                if (this.captureFormat != null && this.dataSource instanceof CaptureDevice && (formatControlArray = ((CaptureDevice)((Object)this.dataSource)).getFormatControls()) != null && formatControlArray.length > 0) {
                    formatControlArray[0].setFormat(this.captureFormat);
                }
            }
            catch (Exception exception) {
                MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.datasource.createfor") + " '" + this.inputURL + "'.", exception);
                this.frameOwner.setCursor(Cursor.getDefaultCursor());
                throw exception;
            }
        }
        this.strContentType = this.dataSource.getContentType();
        try {
            this.processor = Manager.createProcessor(this.dataSource);
        }
        catch (NoPlayerException noPlayerException) {
            MessageDialog.createErrorDialog(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.create"), noPlayerException);
            this.frameOwner.setCursor(Cursor.getDefaultCursor());
            throw noPlayerException;
        }
        this.processor.addControllerListener(this);
        boolean bl = this.waitForState(this.processor, 180);
        if (!bl) {
            this.frameOwner.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.supportedCDs = this.processor.getSupportedContentDescriptors();
        this.arrTrackControls = this.processor.getTrackControls();
        int n2 = 0;
        while (n2 < this.arrTrackControls.length) {
            Format format = this.arrTrackControls[n2].getFormat();
            if (format instanceof VideoFormat) {
                ++this.nVideoTrackCount;
            }
            if (format instanceof AudioFormat) {
                ++this.nAudioTrackCount;
            }
            ++n2;
        }
        this.setLayout(new BorderLayout());
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        jMPanel.setEmptyBorder(6, 6, 6, 6);
        jMPanel.setBackground(Color.lightGray);
        this.add((Component)jMPanel, "Center");
        Panel panel = this.createPanelGeneral();
        jMPanel.add((Component)panel, "North");
        panel = this.createPanelProperties();
        jMPanel.add((Component)panel, "Center");
        panel = new JMPanel(new FlowLayout(1));
        jMPanel.add((Component)panel, "South");
        JMPanel jMPanel2 = this.createButtonPanel(new String[]{JMDialog.ACTION_SAVE, JMDialog.ACTION_CANCEL});
        panel.add(jMPanel2);
        this.changeContentType();
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width += 64;
        ((Component)this).setSize(dimension);
        this.addWindowListener(this);
        this.setResizable(false);
        this.setVisible(true);
        this.frameOwner.setCursor(Cursor.getDefaultCursor());
    }

    private Panel createPanelProperties() throws Exception {
        String string = JMFI18N.getResource("jmstudio.saveas.audio");
        String string2 = JMFI18N.getResource("jmstudio.saveas.video");
        this.tabControl = new TabControl(0);
        int n2 = 0;
        int n3 = 0;
        int n4 = this.arrTrackControls.length;
        int n5 = 0;
        while (n5 < n4) {
            JMAppsCfg.TrackData trackData;
            String string3;
            Format format = this.arrTrackControls[n5].getFormat();
            if (format instanceof AudioFormat) {
                string3 = this.nAudioTrackCount < 2 ? new String(string) : new String(string + " " + ++n2);
                TrackPanelAudio trackPanelAudio = new TrackPanelAudio(this.arrTrackControls[n5], this);
                this.tabControl.addPage(trackPanelAudio, string3, this.imageAudioEn);
                this.hashtablePanelsAudio.put(string3, trackPanelAudio);
                if (this.cfgJMApps != null && (trackData = this.cfgJMApps.getLastSaveFileTrackData(string3)) != null) {
                    trackPanelAudio.setDefaults(trackData.boolEnable, trackData.format);
                }
            } else if (format instanceof VideoFormat) {
                string3 = this.nVideoTrackCount < 2 ? new String(string2) : new String(string2 + " " + ++n3);
                TrackPanelVideo trackPanelVideo = new TrackPanelVideo(this.arrTrackControls[n5], this);
                this.tabControl.addPage(trackPanelVideo, string3, this.imageVideoEn);
                this.hashtablePanelsVideo.put(string3, trackPanelVideo);
                if (this.cfgJMApps != null && (trackData = this.cfgJMApps.getLastSaveFileTrackData(string3)) != null) {
                    trackPanelVideo.setDefaults(trackData.boolEnable, trackData.format);
                }
            }
            ++n5;
        }
        return this.tabControl;
    }

    private Panel createPanelGeneral() throws Exception {
        String string;
        Panel panel = new Panel(new GridLayout(0, 1, 4, 4));
        Panel panel2 = new Panel(new BorderLayout());
        panel.add(panel2);
        Label label = new Label(JMFI18N.getResource("jmstudio.saveas.format"));
        panel2.add((Component)label, "West");
        this.comboContentType = new Choice();
        this.comboContentType.addItemListener(this);
        int n2 = 0;
        while (n2 < this.supportedCDs.length) {
            if (this.supportedCDs[n2] instanceof FileTypeDescriptor) {
                String string2 = this.supportedCDs[n2].getContentType();
                string = this.transCDToDesc(string2);
                if (!(this.nAudioTrackCount < 1 && (string.equals(STR_AIFF) || string.equals(STR_GSM) || string.equals(STR_WAVE) || string.equals(STR_BASIC_AUDIO) || string.equals(STR_MPEG_AUDIO)))) {
                    this.comboContentType.addItem(string);
                }
            }
            ++n2;
        }
        string = null;
        if (this.cfgJMApps != null) {
            string = this.cfgJMApps.getLastSaveFileContentType();
        }
        if (string == null) {
            string = this.transCDToDesc(ContentDescriptor.mimeTypeToPackageName(this.strContentType));
        }
        this.comboContentType.select(string);
        panel2.add((Component)this.comboContentType, "Center");
        return panel;
    }

    private String transCDToDesc(String string) {
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("video.x_msvideo"))) {
            return STR_MSVIDEO;
        }
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("video.quicktime"))) {
            return STR_QUICKTIME;
        }
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_aiff"))) {
            return STR_AIFF;
        }
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_gsm"))) {
            return STR_GSM;
        }
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_wav"))) {
            return STR_WAVE;
        }
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("audio.basic"))) {
            return STR_BASIC_AUDIO;
        }
        if (string.equals(ContentDescriptor.mimeTypeToPackageName("audio.mpeg"))) {
            return STR_MPEG_AUDIO;
        }
        return string;
    }

    private void doSave() {
        String string = null;
        String string2 = null;
        String string3 = null;
        Component component = null;
        FileDialog fileDialog = new FileDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveas.filedialog"), 1);
        int n2 = this.inputURL.indexOf(58);
        string3 = n2 > 2 ? this.inputURL.substring(n2 + 1) : new String(this.inputURL);
        if (string3.indexOf(47) == 0 && string3.indexOf(58) == 2) {
            string3 = string3.substring(1);
        }
        if ((n2 = string3.lastIndexOf(46)) >= 0 && this.strContentTypeExt != null) {
            string3 = string3.substring(0, n2 + 1) + this.strContentTypeExt;
        } else if (n2 < 0 && this.strContentTypeExt != null) {
            string3 = "Unknown." + this.strContentTypeExt;
        }
        string2 = this.cfgJMApps.getLastSaveFileDir();
        n2 = Math.max(string3.lastIndexOf(47), string3.lastIndexOf(92));
        if (n2 > -1) {
            if (string2 == null) {
                string2 = string3.substring(0, n2);
            }
            string3 = string3.substring(n2 + 1);
        }
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.setFile(string3);
        ((Component)fileDialog).setVisible(true);
        string3 = fileDialog.getFile();
        if (string3 == null || string3.length() == 0) {
            return;
        }
        string2 = fileDialog.getDirectory();
        if (string2 != null) {
            string3 = string2.trim() + string3.trim();
            this.cfgJMApps.setLastSaveFileDir(string2);
        } else {
            string3 = string3.trim();
        }
        if (this.cfgJMApps != null) {
            String string4 = this.comboContentType.getSelectedItem();
            this.cfgJMApps.setLastSaveFileContentType(string4);
        }
        this.setCursor(new Cursor(3));
        try {
            TrackControl trackControl;
            JMAppsCfg.TrackData trackData;
            String string5;
            this.processor.setContentDescriptor(new FileTypeDescriptor(this.strContentType));
            Enumeration enumeration = this.hashtablePanelsVideo.keys();
            while (enumeration.hasMoreElements()) {
                string5 = (String)enumeration.nextElement();
                TrackPanelVideo trackPanelVideo = (TrackPanelVideo)this.hashtablePanelsVideo.get(string5);
                trackPanelVideo.updateTrack();
                if (this.cfgJMApps == null) continue;
                trackData = this.cfgJMApps.createTrackDataObject();
                trackControl = trackPanelVideo.getTrackControl();
                trackData.boolEnable = trackControl.isEnabled();
                trackData.format = trackControl.getFormat();
                this.cfgJMApps.setLastSaveFileTrackData(trackData, string5);
            }
            enumeration = this.hashtablePanelsAudio.keys();
            while (enumeration.hasMoreElements()) {
                string5 = (String)enumeration.nextElement();
                TrackPanelAudio trackPanelAudio = (TrackPanelAudio)this.hashtablePanelsAudio.get(string5);
                trackPanelAudio.updateTrack();
                if (this.cfgJMApps == null) continue;
                trackData = this.cfgJMApps.createTrackDataObject();
                trackControl = trackPanelAudio.getTrackControl();
                trackData.boolEnable = trackControl.isEnabled();
                trackData.format = trackControl.getFormat();
                this.cfgJMApps.setLastSaveFileTrackData(trackData, string5);
            }
            boolean bl = this.waitForState(this.processor, 300);
            if (!bl) {
                this.setCursor(Cursor.getDefaultCursor());
                this.processor.close();
                this.dispose();
                return;
            }
            string = "file:";
            DataSource dataSource = this.processor.getDataOutput();
            int n3 = string3.lastIndexOf(File.separatorChar);
            String string6 = n3 >= 0 ? string3.substring(n3 + 1, string3.length()) : string3;
            if (string6.indexOf(".") == -1) {
                string3 = string3 + "." + this.strContentTypeExt;
            }
            MediaLocator mediaLocator = new MediaLocator(string + string3);
            this.dataSink = Manager.createDataSink(dataSource, mediaLocator);
            this.boolSaving = true;
            MonitorControl monitorControl = (MonitorControl)this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                component = monitorControl.getControlComponent();
            }
            Time time = this.processor.getDuration();
            int n4 = (int)time.getSeconds();
            this.dataSink.addDataSinkListener(this);
            try {
                this.dataSink.open();
            }
            catch (Exception exception) {
                this.processor.close();
                throw exception;
            }
            this.dataSink.start();
            this.processor.start();
            this.dlgProgress = n4 > 0 && time != Duration.DURATION_UNBOUNDED && time != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), 0, n4, (ActionListener)this) : new ProgressDialog(this.frameOwner, JMFI18N.getResource("jmstudio.saveprogress.title"), JMFI18N.getResource("jmstudio.saveprogress.label"), component, (ActionListener)this);
            this.dlgProgress.setVisible(true);
            this.threadProgress = new ProgressThread(this.processor, this.dlgProgress);
            this.threadProgress.start();
        }
        catch (Exception exception) {
            this.boolSaving = false;
            MessageDialog.createErrorDialogModeless(this.frameOwner, null, exception);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (string.equals(JMDialog.ACTION_CANCEL)) {
            this.stopSaving();
            this.dispose();
        } else if (string.equals(JMDialog.ACTION_SAVE)) {
            this.doSave();
        } else if ((string.equals(ProgressDialog.ACTION_ABORT) || string.equals(ProgressDialog.ACTION_STOP)) && this.boolSaving) {
            this.stopSaving();
        } else if (string.equals(ProgressDialog.ACTION_PAUSE) && this.boolSaving) {
            this.processor.stop();
            this.dlgProgress.setPauseButtonText(ProgressDialog.ACTION_RESUME);
            this.threadProgress.pauseThread();
        } else if (string.equals(ProgressDialog.ACTION_RESUME) && this.boolSaving) {
            this.processor.start();
            this.dlgProgress.setPauseButtonText(ProgressDialog.ACTION_PAUSE);
            this.threadProgress.resumeThread();
        } else if (string.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            Object object2 = actionEvent.getSource();
            if (object2 instanceof TrackPanelAudio) {
                this.tabControl.setPageImage((Panel)object2, this.imageAudioEn);
            }
        } else if (string.equals("ACTION_AUDIO_TRACK_DISABLED")) {
            Object object3 = actionEvent.getSource();
            if (object3 instanceof TrackPanelAudio) {
                this.tabControl.setPageImage((Panel)object3, this.imageAudioDis);
            }
        } else if (string.equals("ACTION_VIDEO_TRACK_ENABLED")) {
            Object object4 = actionEvent.getSource();
            if (object4 instanceof TrackPanelVideo) {
                this.tabControl.setPageImage((Panel)object4, this.imageVideoEn);
            }
        } else if (string.equals("ACTION_VIDEO_TRACK_DISABLED") && (object = actionEvent.getSource()) instanceof TrackPanelVideo) {
            this.tabControl.setPageImage((Panel)object, this.imageVideoDis);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.comboContentType) {
            this.changeContentType();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.stopSaving();
        this.dispose();
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ControllerErrorEvent) {
            this.strFailMessage = ((ControllerErrorEvent)controllerEvent).getMessage();
            if (this.boolSaving) {
                this.stopSaving();
                MessageDialog.createErrorDialogModeless(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.savefile") + "\n" + JMFI18N.getResource("jmstudio.error.controller") + "\n" + this.strFailMessage);
            } else {
                MessageDialog.createErrorDialogModeless(this.frameOwner, JMFI18N.getResource("jmstudio.error.controller") + "\n" + this.strFailMessage);
            }
        } else if (controllerEvent instanceof EndOfMediaEvent && this.boolSaving) {
            this.stopSaving();
        }
    }

    public void dataSinkUpdate(DataSinkEvent dataSinkEvent) {
        if (dataSinkEvent instanceof EndOfStreamEvent) {
            this.closeDataSink();
        } else if (dataSinkEvent instanceof DataSinkErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialogModeless(this.frameOwner, JMFI18N.getResource("jmstudio.error.processor.writefile"));
        }
    }

    private void closeDataSink() {
        SaveAsDialog saveAsDialog = this;
        synchronized (saveAsDialog) {
            if (this.dataSink != null) {
                this.dataSink.close();
            }
            this.dataSink = null;
        }
    }

    private void stopSaving() {
        this.boolSaving = false;
        if (this.threadProgress != null) {
            this.threadProgress.terminateNormaly();
            this.threadProgress = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.processor.close();
        }
        if (this.dlgProgress != null) {
            this.dlgProgress.dispose();
            this.dlgProgress = null;
        }
    }

    private synchronized boolean waitForState(Processor processor, int n2) {
        processor.addControllerListener(new StateListener());
        this.stateFailed = false;
        if (n2 == 180) {
            processor.configure();
        } else if (n2 == 300) {
            processor.realize();
        }
        while (processor.getState() < n2 && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return !this.stateFailed;
    }

    private void changeContentType() {
        String string = this.comboContentType.getSelectedItem();
        if (string.equals(STR_MSVIDEO)) {
            this.strContentType = "video.x_msvideo";
            this.strContentTypeExt = "avi";
        } else if (string.equals(STR_QUICKTIME)) {
            this.strContentType = "video.quicktime";
            this.strContentTypeExt = "mov";
        } else if (string.equals(STR_AIFF)) {
            this.strContentType = "audio.x_aiff";
            this.strContentTypeExt = "aif";
        } else if (string.equals(STR_GSM)) {
            this.strContentType = "audio.x_gsm";
            this.strContentTypeExt = "gsm";
        } else if (string.equals(STR_WAVE)) {
            this.strContentType = "audio.x_wav";
            this.strContentTypeExt = "wav";
        } else if (string.equals(STR_BASIC_AUDIO)) {
            this.strContentType = "audio.basic";
            this.strContentTypeExt = "au";
        } else if (string.equals(STR_MPEG_AUDIO)) {
            this.strContentType = "audio.mpeg";
            this.strContentTypeExt = "mp3";
        } else {
            this.strContentType = string;
            this.strContentTypeExt = "movie";
        }
        if (this.processor.setContentDescriptor(new FileTypeDescriptor(this.strContentType)) == null) {
            System.err.println("Error setting content descriptor on processor");
        }
        Enumeration enumeration = this.hashtablePanelsVideo.elements();
        while (enumeration.hasMoreElements()) {
            TrackPanelVideo trackPanelVideo = (TrackPanelVideo)enumeration.nextElement();
            trackPanelVideo.setContentType(this.strContentType);
        }
        enumeration = this.hashtablePanelsAudio.elements();
        while (enumeration.hasMoreElements()) {
            TrackPanelAudio trackPanelAudio = (TrackPanelAudio)enumeration.nextElement();
            trackPanelAudio.setContentType(this.strContentType);
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof ControllerClosedEvent) {
                SaveAsDialog.this.stateFailed = true;
            }
            if (controllerEvent instanceof ControllerEvent) {
                Object object = SaveAsDialog.this.stateLock;
                synchronized (object) {
                    SaveAsDialog.this.stateLock.notifyAll();
                }
            }
        }
    }
}

