/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.rtp.util.Signed;
import com.sun.media.util.JMFI18N;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.TimeoutEvent;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import jmapps.rtp.ViewParticipantInfo;
import jmapps.rtp.ViewParticipantList;
import jmapps.rtp.ViewReceiverReport;
import jmapps.rtp.ViewReportBlock;
import jmapps.rtp.ViewRtpStreamInfo;
import jmapps.rtp.ViewSenderReport;
import jmapps.ui.JMPanel;
import jmapps.ui.TreeControl;
import jmapps.ui.TreeNode;

public class PanelParticipants
extends JMPanel
implements ComponentListener,
ActionListener,
SessionListener,
ReceiveStreamListener,
RemoteListener {
    private SessionManager mngrSession;
    private TreeControl controlTree = null;
    private JMPanel panelView = null;
    private CardLayout layoutView = null;
    private JMPanel panelCurrentView = null;
    private static final int MARGINH = 6;
    public static final String PARTICIPANTS = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants");
    public static final String REMOTE_RECEIVE_STREAM = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.remotereceivestream");
    public static final String UNKNOWN_STREAM = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.unknownstream");
    public static final String REPORT = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.report");
    public static final String LATEST_SENDER_REPORT = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.latestsenderreport");
    public static final String REPORT_BLOCK = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.reportblock");
    public static final String REPORT_BLOCK_BY_ME = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.reportblockbyme");
    public static final String SENDER_REPORT_BLOCK = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.senderreportblock");

    public PanelParticipants(SessionManager sessionManager) {
        this.mngrSession = sessionManager;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.addComponentListener(this);
        this.setLayout(null);
        this.controlTree = new TreeControl();
        this.add(this.controlTree);
        this.layoutView = new CardLayout();
        this.panelView = new JMPanel(this.layoutView);
        this.panelView.setEtchedBorder();
        this.add(this.panelView);
        TreeNode treeNode = this.controlTree.createRootElement(PARTICIPANTS);
        ViewParticipantList viewParticipantList = new ViewParticipantList(this.mngrSession);
        treeNode.setUserData(viewParticipantList);
        this.fillParticipantsNode(treeNode);
        this.controlTree.setCurrentElement(treeNode);
        treeNode.addActionListener(this);
        this.setViewPanel(treeNode);
        this.mngrSession.addSessionListener(this);
        this.mngrSession.addReceiveStreamListener(this);
        this.mngrSession.addRemoteListener(this);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(480, 360);
        return dimension;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null || !(object instanceof TreeNode)) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (!string.equals("Node Added")) {
            if (string.equals("Node Removed")) {
                this.removeViewPanel((TreeNode)object);
            } else if (!string.equals("Node Expanded") && !string.equals("Node Collapsed")) {
                if (string.equals("Node Set Current")) {
                    this.setViewPanel((TreeNode)object);
                } else if (string.equals("Node Reset Current")) {
                    // empty if block
                }
            }
        }
    }

    public void update(SessionEvent sessionEvent) {
        if (sessionEvent instanceof NewParticipantEvent) {
            Participant participant = ((NewParticipantEvent)sessionEvent).getParticipant();
            this.addParticipant(participant);
        }
    }

    public void update(RemoteEvent remoteEvent) {
        Object object;
        TreeNode treeNode;
        Participant participant;
        if (remoteEvent instanceof ReceiverReportEvent && (participant = ((ReceiverReportEvent)remoteEvent).getReport().getParticipant()) != null && participant.getStreams().size() == 0 && (treeNode = this.findParticipantListNode()) != null) {
            object = treeNode.getUserData();
            if (object != null && object instanceof ViewParticipantList) {
                ((ViewParticipantList)object).updateFields();
            }
            ReceiverReport receiverReport = ((ReceiverReportEvent)remoteEvent).getReport();
            this.addReport(participant, (Report)receiverReport);
        }
        if (remoteEvent instanceof SenderReportEvent && (participant = ((SenderReportEvent)remoteEvent).getReport().getParticipant()) != null && participant.getStreams().size() > 0 && (treeNode = this.findParticipantListNode()) != null) {
            object = treeNode.getUserData();
            if (object != null && object instanceof ViewParticipantList) {
                ((ViewParticipantList)object).updateFields();
            }
            SenderReport senderReport = ((SenderReportEvent)remoteEvent).getReport();
            this.addReport(participant, (Report)senderReport);
        }
    }

    public void update(ReceiveStreamEvent receiveStreamEvent) {
        ReceiveStream receiveStream;
        Participant participant;
        if (receiveStreamEvent instanceof TimeoutEvent || receiveStreamEvent instanceof ByeEvent) {
            participant = null;
            receiveStream = null;
            if (receiveStreamEvent instanceof TimeoutEvent && ((TimeoutEvent)receiveStreamEvent).participantLeaving()) {
                participant = ((TimeoutEvent)receiveStreamEvent).getParticipant();
            }
            if (receiveStreamEvent instanceof ByeEvent && ((ByeEvent)receiveStreamEvent).participantLeaving()) {
                participant = ((ByeEvent)receiveStreamEvent).getParticipant();
            } else if (receiveStreamEvent instanceof TimeoutEvent) {
                receiveStream = ((TimeoutEvent)receiveStreamEvent).getReceiveStream();
            } else if (receiveStreamEvent instanceof ByeEvent) {
                receiveStream = ((ByeEvent)receiveStreamEvent).getReceiveStream();
            }
            if (participant != null) {
                this.removeParticipant(participant);
            }
            if (receiveStream != null) {
                this.removeRtpStream(receiveStream);
            }
        }
        if (receiveStreamEvent instanceof NewReceiveStreamEvent) {
            receiveStream = ((NewReceiveStreamEvent)receiveStreamEvent).getReceiveStream();
            participant = receiveStream.getParticipant();
            if (participant == null) {
                return;
            }
            TreeNode treeNode = this.findParticipantNode(participant);
            if (treeNode == null) {
                this.addParticipant(participant);
            }
            this.addRtpStream(participant, (RTPStream)receiveStream);
            treeNode = this.findParticipantListNode();
            Object object = treeNode.getUserData();
            if (object != null && object instanceof ViewParticipantList) {
                ((ViewParticipantList)object).updateFields();
            }
        }
        if (receiveStreamEvent instanceof InactiveReceiveStreamEvent) {
            // empty if block
        }
        if (receiveStreamEvent instanceof ActiveReceiveStreamEvent) {
            // empty if block
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.layoutComponents();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void fillParticipantsNode(TreeNode treeNode) {
        LocalParticipant localParticipant;
        Vector vector = this.mngrSession.getRemoteParticipants();
        if (!vector.contains(localParticipant = this.mngrSession.getLocalParticipant())) {
            vector.addElement(localParticipant);
        }
        Vector vector2 = this.mngrSession.getActiveParticipants();
        int n2 = vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            localParticipant = vector2.elementAt(n3);
            if (!vector.contains(localParticipant)) {
                vector.addElement(localParticipant);
            }
            ++n3;
        }
        vector2 = this.mngrSession.getPassiveParticipants();
        n2 = vector2.size();
        n3 = 0;
        while (n3 < n2) {
            localParticipant = vector2.elementAt(n3);
            if (!vector.contains(localParticipant)) {
                vector.addElement(localParticipant);
            }
            ++n3;
        }
        n2 = vector.size();
        n3 = 0;
        while (n3 < n2) {
            localParticipant = vector.elementAt(n3);
            if (localParticipant != null && localParticipant instanceof Participant) {
                String string = ((Participant)localParticipant).getCNAME();
                TreeNode treeNode2 = this.controlTree.createSubElement(treeNode, string);
                ViewParticipantInfo viewParticipantInfo = new ViewParticipantInfo(this.mngrSession, localParticipant);
                treeNode2.setUserData(viewParticipantInfo);
                this.fillParticipantInfoNode(treeNode2, localParticipant);
                treeNode2.addActionListener(this);
            }
            ++n3;
        }
    }

    private void fillParticipantInfoNode(TreeNode treeNode, Participant participant) {
        if (participant == null) {
            return;
        }
        Vector vector = participant.getStreams();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = vector.elementAt(n3);
            if (e2 != null && e2 instanceof RTPStream) {
                this.addRtpStream(treeNode, (RTPStream)e2);
            }
            ++n3;
        }
        Vector vector2 = participant.getReports();
        n2 = vector2.size();
        n3 = 0;
        while (n3 < n2) {
            Object e3 = vector2.elementAt(n3);
            if (e3 != null && e3 instanceof Report) {
                this.addReport(treeNode, (Report)e3);
            }
            ++n3;
        }
    }

    private void fillStreamInfoNode(TreeNode treeNode, RTPStream rTPStream) {
        if (rTPStream == null) {
            return;
        }
        SenderReport senderReport = rTPStream.getSenderReport();
        if (senderReport != null) {
            String string = this.createStreamLatestReportNodeName();
            TreeNode treeNode2 = this.controlTree.createSubElement(treeNode, string);
            ViewSenderReport viewSenderReport = new ViewSenderReport(this.mngrSession, senderReport);
            treeNode2.setUserData(viewSenderReport);
            this.fillReportInfoNode(treeNode2, senderReport);
            treeNode2.addActionListener(this);
        }
    }

    private void fillReportInfoNode(TreeNode treeNode, Report report) {
        this.updateReportBlocks(treeNode, report);
    }

    private void addParticipant(Participant participant) {
        if (participant == null) {
            return;
        }
        TreeNode treeNode = this.findParticipantListNode();
        TreeNode treeNode2 = this.findParticipantNode(participant);
        if (treeNode2 != null) {
            return;
        }
        String string = participant.getCNAME();
        treeNode2 = this.controlTree.createSubElement(treeNode, string);
        ViewParticipantInfo viewParticipantInfo = new ViewParticipantInfo(this.mngrSession, participant);
        treeNode2.setUserData(viewParticipantInfo);
        this.fillParticipantInfoNode(treeNode2, participant);
        treeNode2.addActionListener(this);
        Object object = treeNode.getUserData();
        if (object != null && object instanceof ViewParticipantList) {
            ((ViewParticipantList)object).updateFields();
        }
    }

    private void removeParticipant(Participant participant) {
        TreeNode treeNode = this.findParticipantNode(participant);
        if (treeNode == null) {
            return;
        }
        TreeNode treeNode2 = this.findParticipantListNode();
        this.controlTree.destroySubElement(treeNode2, treeNode);
        Object object = treeNode2.getUserData();
        if (object != null && object instanceof ViewParticipantList) {
            ((ViewParticipantList)object).updateFields();
        }
    }

    private void addRtpStream(Participant participant, RTPStream rTPStream) {
        TreeNode treeNode = this.findParticipantNode(participant);
        this.addRtpStream(treeNode, rTPStream);
    }

    private void addRtpStream(TreeNode treeNode, RTPStream rTPStream) {
        if (treeNode == null) {
            return;
        }
        TreeNode treeNode2 = this.findStreamNode(treeNode, rTPStream);
        if (treeNode2 != null) {
            return;
        }
        String string = this.createStreamNodeName(rTPStream);
        treeNode2 = this.controlTree.createSubElement(treeNode, string);
        ViewRtpStreamInfo viewRtpStreamInfo = new ViewRtpStreamInfo(this.mngrSession, rTPStream);
        treeNode2.setUserData(viewRtpStreamInfo);
        this.fillStreamInfoNode(treeNode2, rTPStream);
        treeNode2.addActionListener(this);
    }

    private void removeRtpStream(RTPStream rTPStream) {
        Participant participant = rTPStream.getParticipant();
        if (participant == null) {
            return;
        }
        TreeNode treeNode = this.findParticipantNode(participant);
        this.removeRtpStream(treeNode, rTPStream);
    }

    private void removeRtpStream(TreeNode treeNode, RTPStream rTPStream) {
        if (treeNode == null) {
            return;
        }
        TreeNode treeNode2 = this.findStreamNode(treeNode, rTPStream);
        if (treeNode2 == null) {
            return;
        }
        this.controlTree.destroySubElement(treeNode, treeNode2);
    }

    private void addReport(Participant participant, Report report) {
        if (participant == null) {
            return;
        }
        TreeNode treeNode = this.findParticipantNode(participant);
        this.addReport(treeNode, report);
    }

    private void addReport(TreeNode treeNode, Report report) {
        Object object;
        if (treeNode == null) {
            return;
        }
        String string = this.createReportNodeName(report);
        TreeNode treeNode2 = treeNode.getSubElement(string);
        if (treeNode2 != null) {
            object = treeNode2.getUserData();
            if (object != null) {
                if (object instanceof ViewReceiverReport && report instanceof ReceiverReport) {
                    ((ViewReceiverReport)object).updateFields((ReceiverReport)report);
                } else if (object instanceof ViewSenderReport && report instanceof SenderReport) {
                    ((ViewSenderReport)object).updateFields((SenderReport)report);
                }
            }
            this.updateReportBlocks(treeNode2, report);
        } else {
            treeNode2 = this.controlTree.createSubElement(treeNode, string);
            object = report instanceof SenderReport ? new ViewSenderReport(this.mngrSession, (SenderReport)report) : (report instanceof ReceiverReport ? new ViewReceiverReport((ReceiverReport)report) : null);
            treeNode2.setUserData(object);
            this.fillReportInfoNode(treeNode2, report);
            treeNode2.addActionListener(this);
            object = treeNode.getUserData();
            if (object != null && object instanceof ViewParticipantInfo) {
                ((ViewParticipantInfo)object).updateFields(report);
            }
        }
        if (report instanceof SenderReport) {
            treeNode2 = this.findStreamNode(treeNode, ((SenderReport)report).getStream());
            if (treeNode2 != null) {
                treeNode2 = this.findStreamLatestReportNode(treeNode2);
            }
            if (treeNode2 != null) {
                object = treeNode2.getUserData();
                if (object != null && object instanceof ViewSenderReport) {
                    ((ViewSenderReport)object).updateFields((SenderReport)report);
                }
                this.updateReportBlocks(treeNode2, report);
            }
        }
    }

    private void updateReportBlocks(TreeNode treeNode, Report report) {
        block13: {
            block12: {
                Object object;
                ViewReportBlock viewReportBlock;
                if (report == null) {
                    return;
                }
                if (!(report instanceof SenderReport)) break block12;
                SenderReport senderReport = (SenderReport)report;
                Feedback feedback = senderReport.getSenderFeedback();
                String string = REPORT_BLOCK_BY_ME;
                TreeNode treeNode2 = treeNode.getSubElement(string);
                if (treeNode2 == null) {
                    treeNode2 = this.controlTree.createSubElement(treeNode, string);
                    viewReportBlock = new ViewReportBlock(feedback);
                    treeNode2.setUserData(viewReportBlock);
                    treeNode2.addActionListener(this);
                } else {
                    object = treeNode2.getUserData();
                    if (object != null && object instanceof ViewReportBlock) {
                        ((ViewReportBlock)object).updateFields(feedback);
                    }
                }
                Vector vector = senderReport.getFeedbackReports();
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    feedback = (Feedback)vector.elementAt(n3);
                    string = SENDER_REPORT_BLOCK + " " + n3;
                    treeNode2 = treeNode.getSubElement(string);
                    if (treeNode2 == null) {
                        treeNode2 = this.controlTree.createSubElement(treeNode, string);
                        viewReportBlock = new ViewReportBlock(feedback);
                        treeNode2.setUserData(viewReportBlock);
                        treeNode2.addActionListener(this);
                    } else {
                        object = treeNode2.getUserData();
                        if (object != null && object instanceof ViewReportBlock) {
                            ((ViewReportBlock)object).updateFields(feedback);
                        }
                    }
                    ++n3;
                }
                break block13;
            }
            if (!(report instanceof ReceiverReport)) break block13;
            ReceiverReport receiverReport = (ReceiverReport)report;
            Vector vector = receiverReport.getFeedbackReports();
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                Feedback feedback = (Feedback)vector.elementAt(n5);
                String string = REPORT_BLOCK + " " + n5;
                TreeNode treeNode3 = treeNode.getSubElement(string);
                if (treeNode3 == null) {
                    treeNode3 = this.controlTree.createSubElement(treeNode, string);
                    ViewReportBlock viewReportBlock = new ViewReportBlock(feedback);
                    treeNode3.setUserData(viewReportBlock);
                    treeNode3.addActionListener(this);
                } else {
                    Object object = treeNode3.getUserData();
                    if (object != null && object instanceof ViewReportBlock) {
                        ((ViewReportBlock)object).updateFields(feedback);
                    }
                }
                ++n5;
            }
        }
    }

    private TreeNode findParticipantListNode() {
        TreeNode treeNode = this.controlTree.getRootElement();
        return treeNode;
    }

    private TreeNode findParticipantNode(Participant participant) {
        TreeNode treeNode = this.controlTree.getRootElement();
        TreeNode treeNode2 = treeNode.getSubElement(participant.getCNAME());
        return treeNode2;
    }

    private TreeNode findStreamNode(TreeNode treeNode, RTPStream rTPStream) {
        String string = this.createStreamNodeName(rTPStream);
        TreeNode treeNode2 = treeNode.getSubElement(string);
        return treeNode2;
    }

    private TreeNode findStreamLatestReportNode(TreeNode treeNode) {
        String string = this.createStreamLatestReportNodeName();
        TreeNode treeNode2 = treeNode.getSubElement(string);
        return treeNode2;
    }

    private String createStreamNodeName(RTPStream rTPStream) {
        if (rTPStream == null) {
            return null;
        }
        String string = rTPStream instanceof ReceiveStream ? REMOTE_RECEIVE_STREAM + ": " : UNKNOWN_STREAM + ": ";
        string = string + rTPStream.getParticipant().getCNAME();
        return string;
    }

    private String createReportNodeName(Report report) {
        long l2 = report.getSSRC();
        String string = REPORT + " " + Signed.UnsignedInt((int)l2);
        return string;
    }

    private String createStreamLatestReportNodeName() {
        String string = LATEST_SENDER_REPORT;
        return string;
    }

    private void setViewPanel(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        Object object = treeNode.getUserData();
        String string = treeNode.getFullPathName();
        if (object != null && object instanceof JMPanel) {
            this.panelCurrentView = (JMPanel)object;
            if (this.panelCurrentView.getParent() == null) {
                this.panelView.add((Component)this.panelCurrentView, string);
            }
            this.layoutView.show(this.panelView, string);
        }
    }

    private void removeViewPanel(TreeNode treeNode) {
        Object object = treeNode.getUserData();
        if (object != null && object instanceof JMPanel && ((JMPanel)object).getParent() == this.panelView) {
            this.panelView.remove((JMPanel)object);
        }
        this.setViewPanel(this.controlTree.getCurrentElement());
    }

    private void layoutComponents() {
        Dimension dimension = this.getSize();
        int n2 = (dimension.width - 6) / 2;
        if (this.controlTree != null) {
            this.controlTree.setBounds(0, 0, n2, dimension.height);
        }
        if (this.panelView != null) {
            this.panelView.setBounds(n2 + 6, 0, dimension.width - (n2 + 6), dimension.height);
            this.panelView.doLayout();
        }
        this.repaint();
    }
}

