/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.rtp.util.Signed;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import javax.media.rtp.rtcp.Feedback;
import jmapps.ui.JMPanel;

public class ViewReportBlock
extends JMPanel {
    private Feedback feedback;
    private Label fieldDlsr;
    private Label fieldFractionLost;
    private Label fieldLostPackets;
    private Label fieldJitter;
    private Label fieldLsr;
    private Label fieldSsrc;
    private Label fieldXtndSeqNum;
    private static final String LABEL_DLSR = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.dlsr");
    private static final String LABEL_FRACTION_LOST = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.fractionlost");
    private static final String LABEL_LOST_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.lostpackets");
    private static final String LABEL_JITTER = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.jitter");
    private static final String LABEL_LSR = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.lsr");
    private static final String LABEL_SSRC = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.ssrc");
    private static final String LABEL_XTNDSEQNUM = JMFI18N.getResource("jmstudio.rtpsessionctrl.feedback.xtndseqnum");

    public ViewReportBlock(Feedback feedback) {
        this.feedback = feedback;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        JMPanel jMPanel = new JMPanel(new BorderLayout(6, 6));
        this.add((Component)jMPanel, "North");
        JMPanel jMPanel2 = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel.add((Component)jMPanel2, "West");
        JMPanel jMPanel3 = new JMPanel(new GridLayout(0, 1, 0, 0));
        jMPanel.add((Component)jMPanel3, "Center");
        Label label = new Label(LABEL_DLSR);
        jMPanel2.add(label);
        this.fieldDlsr = new Label();
        jMPanel3.add(this.fieldDlsr);
        label = new Label(LABEL_FRACTION_LOST);
        jMPanel2.add(label);
        this.fieldFractionLost = new Label();
        jMPanel3.add(this.fieldFractionLost);
        label = new Label(LABEL_LOST_PACKETS);
        jMPanel2.add(label);
        this.fieldLostPackets = new Label();
        jMPanel3.add(this.fieldLostPackets);
        label = new Label(LABEL_JITTER);
        jMPanel2.add(label);
        this.fieldJitter = new Label();
        jMPanel3.add(this.fieldJitter);
        label = new Label(LABEL_LSR);
        jMPanel2.add(label);
        this.fieldLsr = new Label();
        jMPanel3.add(this.fieldLsr);
        label = new Label(LABEL_SSRC);
        jMPanel2.add(label);
        this.fieldSsrc = new Label();
        jMPanel3.add(this.fieldSsrc);
        label = new Label(LABEL_XTNDSEQNUM);
        jMPanel2.add(label);
        this.fieldXtndSeqNum = new Label();
        jMPanel3.add(this.fieldXtndSeqNum);
        this.updateFields(this.feedback);
    }

    public void updateFields(Feedback feedback) {
        if (feedback == null) {
            return;
        }
        this.feedback = feedback;
        this.fieldDlsr.setText("" + (double)feedback.getDLSR() / 65536.0);
        this.fieldFractionLost.setText("" + (double)feedback.getFractionLost() / 256.0);
        this.fieldLostPackets.setText("" + feedback.getNumLost());
        this.fieldJitter.setText("" + feedback.getJitter());
        this.fieldLsr.setText("" + feedback.getLSR());
        this.fieldSsrc.setText("" + Signed.UnsignedInt((int)feedback.getSSRC()));
        this.fieldXtndSeqNum.setText("" + feedback.getXtndSeqNum());
    }
}

