/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import jmapps.ui.ImageArea;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;

public class WizardDialog
extends JMDialog {
    public static final String ACTION_FINISH = JMFI18N.getResource("jmstudio.wizard.finish");
    public static final String ACTION_CANCEL = JMFI18N.getResource("jmstudio.wizard.cancel");
    public static final String ACTION_NEXT = JMFI18N.getResource("jmstudio.wizard.next");
    public static final String ACTION_BACK = JMFI18N.getResource("jmstudio.wizard.back");
    private String strResultAction = ACTION_CANCEL;
    private String strImage;
    private JMPanel panelPages;
    private Button buttonBack;
    private Button buttonNext;
    private Button buttonFinish;
    private Button buttonCancel;
    private Vector vectorPages = null;
    private Panel panelCurPage = null;
    private CardLayout layoutCard;
    protected Frame frameOwner = null;

    public WizardDialog(Frame frame, String string, boolean bl, String string2) {
        this(frame, string, bl, string2, null);
    }

    public WizardDialog(Frame frame, String string, boolean bl, String string2, Panel[] panelArray) {
        super(frame, string, bl);
        this.frameOwner = frame;
        this.strImage = string2;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPages(panelArray);
    }

    public String getAction() {
        return this.strResultAction;
    }

    public Panel getCurrentPage() {
        return this.panelCurPage;
    }

    public void setPages(Panel[] panelArray) {
        if (panelArray != null) {
            this.panelCurPage = null;
            int n2 = panelArray.length;
            this.vectorPages = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                this.vectorPages.addElement(panelArray[n3]);
                ++n3;
            }
        }
        this.setNextPage();
    }

    protected void init() throws Exception {
        Panel panel;
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(6, 6));
        this.setResizable(false);
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        panel2.setBackground(Color.lightGray);
        this.add((Component)panel2, "Center");
        if (this.strImage != null) {
            panel = new Panel(new BorderLayout());
            panel2.add((Component)panel, "West");
            Image image = ImageArea.loadImage(this.strImage, this, true);
            ImageArea imageArea = new ImageArea(image);
            imageArea.setInsets(12, 12, 12, 12);
            panel.add((Component)imageArea, "North");
        }
        this.layoutCard = new CardLayout(6, 6);
        this.panelPages = new JMPanel(this.layoutCard);
        this.panelPages.setEmptyBorder(6, 6, 6, 6);
        panel2.add((Component)this.panelPages, "Center");
        panel = this.createPanelButtons();
        panel2.add((Component)panel, "South");
    }

    private Panel createPanelButtons() {
        Panel panel = new Panel(new FlowLayout(2));
        Panel panel2 = new Panel(new GridLayout(1, 0, 6, 6));
        panel.add(panel2);
        this.buttonBack = new Button(ACTION_BACK);
        this.buttonBack.addActionListener(this);
        panel2.add(this.buttonBack);
        this.buttonNext = new Button(ACTION_NEXT);
        this.buttonNext.addActionListener(this);
        panel2.add(this.buttonNext);
        this.buttonFinish = new Button(ACTION_FINISH);
        this.buttonFinish.addActionListener(this);
        panel2.add(this.buttonFinish);
        this.buttonCancel = new Button(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this);
        panel2.add(this.buttonCancel);
        return panel;
    }

    protected void setNextPage() {
        if (this.panelCurPage != null && !this.onPageDone(this.panelCurPage)) {
            return;
        }
        Panel panel = this.getNextPage(this.panelCurPage);
        this.setPage(panel);
    }

    protected void setPrevPage() {
        Panel panel = this.getPrevPage(this.panelCurPage);
        this.setPage(panel);
    }

    private void setPage(Panel panel) {
        if (panel == null) {
            return;
        }
        this.panelCurPage = panel;
        this.onPageActivate(this.panelCurPage);
        this.panelPages.add((Component)this.panelCurPage, this.panelCurPage.getName());
        this.layoutCard.show(this.panelPages, this.panelCurPage.getName());
        if (this.isFirstPage(this.panelCurPage)) {
            this.buttonBack.setEnabled(false);
            if (this.getFocusOwner() == this.buttonBack) {
                this.buttonNext.requestFocus();
            }
        } else {
            this.buttonBack.setEnabled(true);
        }
        if (this.isLastPage(this.panelCurPage)) {
            this.buttonNext.setEnabled(false);
            this.buttonFinish.setEnabled(true);
            if (this.getFocusOwner() == this.buttonNext) {
                this.buttonFinish.requestFocus();
            }
        } else {
            this.buttonNext.setEnabled(true);
            this.buttonFinish.setEnabled(false);
        }
        this.validate();
        this.panelCurPage.validate();
    }

    protected boolean onPageDone(Panel panel) {
        return true;
    }

    protected boolean onPageActivate(Panel panel) {
        return true;
    }

    protected boolean onFinish() {
        return true;
    }

    protected Panel getFirstPage() {
        Panel panel = null;
        if (this.vectorPages != null && !this.vectorPages.isEmpty()) {
            panel = (Panel)this.vectorPages.firstElement();
        }
        return panel;
    }

    protected Panel getLastPage() {
        Panel panel = null;
        if (this.vectorPages != null && !this.vectorPages.isEmpty()) {
            panel = (Panel)this.vectorPages.lastElement();
        }
        return panel;
    }

    protected Panel getNextPage(Panel panel) {
        int n2;
        Panel panel2 = null;
        if (panel == null) {
            panel2 = this.getFirstPage();
        } else if (this.vectorPages != null && !this.vectorPages.isEmpty() && (n2 = this.vectorPages.indexOf(panel)) >= 0 && n2 < this.vectorPages.size() - 1) {
            panel2 = (Panel)this.vectorPages.elementAt(n2 + 1);
        }
        return panel2;
    }

    protected Panel getPrevPage(Panel panel) {
        int n2;
        Panel panel2 = null;
        if (panel == null) {
            panel2 = this.getLastPage();
        } else if (this.vectorPages != null && !this.vectorPages.isEmpty() && (n2 = this.vectorPages.indexOf(panel)) > 0 && n2 < this.vectorPages.size()) {
            panel2 = (Panel)this.vectorPages.elementAt(n2 - 1);
        }
        return panel2;
    }

    protected boolean isFirstPage(Panel panel) {
        boolean bl = panel == this.getFirstPage();
        return bl;
    }

    protected boolean isLastPage(Panel panel) {
        boolean bl = panel == this.getLastPage();
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_FINISH) || string.equals(ACTION_CANCEL)) {
            if (string.equals(ACTION_FINISH)) {
                if (!this.onPageDone(this.panelCurPage)) {
                    return;
                }
                if (!this.onFinish()) {
                    this.setPage(this.getFirstPage());
                    return;
                }
            }
            this.strResultAction = string;
            this.dispose();
        } else if (string.equals(ACTION_BACK)) {
            this.setPrevPage();
        } else if (string.equals(ACTION_NEXT)) {
            this.setNextPage();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

