/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.impls;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import net.sbbi.log.Log;
import net.sbbi.log.LogFactory;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.messages.StateVariableResponse;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.UPNPService;

public class InternetGatewayDevice {
    private static final Log log = LogFactory.getLog(InternetGatewayDevice.class);
    private UPNPRootDevice igd;
    private UPNPMessageFactory msgFactory;

    public InternetGatewayDevice(UPNPRootDevice igd) throws UnsupportedOperationException {
        this(igd, true, true);
    }

    private InternetGatewayDevice(UPNPRootDevice igd, boolean WANIPConnection, boolean WANPPPConnection) throws UnsupportedOperationException {
        this.igd = igd;
        UPNPDevice myIGDWANDevice = igd.getChildDevice("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        if (myIGDWANDevice == null) {
            throw new UnsupportedOperationException("device urn:schemas-upnp-org:device:WANConnectionDevice:1 not supported by IGD device " + igd.getModelName());
        }
        UPNPService wanIPSrv = myIGDWANDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1");
        UPNPService wanPPPSrv = myIGDWANDevice.getService("urn:schemas-upnp-org:service:WANPPPConnection:1");
        if (WANIPConnection && WANPPPConnection && wanIPSrv == null && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 or urn:schemas-upnp-org:service:WANPPPConnection:1 device");
        }
        if (WANIPConnection && !WANPPPConnection && wanIPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 device");
        }
        if (!WANIPConnection && WANPPPConnection && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANPPPConnection:1 device");
        }
        this.msgFactory = wanIPSrv != null && wanPPPSrv == null ? UPNPMessageFactory.getNewInstance(wanIPSrv) : (wanPPPSrv != null && wanIPSrv == null ? UPNPMessageFactory.getNewInstance(wanPPPSrv) : UPNPMessageFactory.getNewInstance(wanIPSrv));
    }

    public UPNPRootDevice getIGDRootDevice() {
        return this.igd;
    }

    public static InternetGatewayDevice[] getDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, true, true);
    }

    public static InternetGatewayDevice[] getIPDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, true, false);
    }

    public static InternetGatewayDevice[] getPPPDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, false, true);
    }

    public static InternetGatewayDevice[] lookupDeviceDevices(int timeout, boolean WANIPConnection, boolean WANPPPConnection) throws IOException {
        UPNPRootDevice[] devices = null;
        InternetGatewayDevice[] rtrVal = null;
        devices = timeout == -1 ? Discovery.discover("urn:schemas-upnp-org:device:InternetGatewayDevice:1") : Discovery.discover(timeout, "urn:schemas-upnp-org:device:InternetGatewayDevice:1");
        if (devices != null) {
            int i;
            HashSet<InternetGatewayDevice> valid = new HashSet<InternetGatewayDevice>();
            for (i = 0; i < devices.length; ++i) {
                try {
                    valid.add(new InternetGatewayDevice(devices[i], WANIPConnection, WANPPPConnection));
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("UnsupportedOperationException during discovery " + ex.getMessage());
                }
            }
            if (valid.size() == 0) {
                return null;
            }
            rtrVal = new InternetGatewayDevice[valid.size()];
            i = 0;
            Iterator itr = valid.iterator();
            while (itr.hasNext()) {
                rtrVal[i++] = (InternetGatewayDevice)itr.next();
            }
        }
        return rtrVal;
    }

    public String getExternalIPAddress() throws UPNPResponseException, IOException {
        ActionMessage msg = this.msgFactory.getMessage("GetExternalIPAddress");
        return msg.service().getOutActionArgumentValue("NewExternalIPAddress");
    }

    public ActionResponse getGenericPortMappingEntry(int newPortMappingIndex) throws IOException, UPNPResponseException {
        ActionMessage msg = this.msgFactory.getMessage("GetGenericPortMappingEntry");
        msg.setInputParameter("NewPortMappingIndex", newPortMappingIndex);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public ActionResponse getSpecificPortMappingEntry(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("GetSpecificPortMappingEntry");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public boolean addPortMapping(String description, String remoteHost, int internalPort, int externalPort, String internalClient, int leaseDuration, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        if (externalPort != 0) {
            this.checkPortRange(externalPort);
        }
        this.checkPortRange(internalPort);
        String string = description = description == null ? "" : description;
        if (leaseDuration < 0) {
            throw new IllegalArgumentException("Invalid leaseDuration (" + leaseDuration + ") value");
        }
        ActionMessage msg = this.msgFactory.getMessage("AddPortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol).setInputParameter("NewInternalPort", internalPort).setInputParameter("NewInternalClient", internalClient).setInputParameter("NewEnabled", "1").setInputParameter("NewPortMappingDescription", description).setInputParameter("NewLeaseDuration", leaseDuration);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 718) {
                return false;
            }
            throw ex;
        }
    }

    public boolean deletePortMapping(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("DeletePortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return false;
            }
            throw ex;
        }
    }

    public Integer getNatMappingsCount() throws IOException, UPNPResponseException {
        Integer rtrval;
        block2: {
            rtrval = null;
            StateVariableMessage natTableSize = this.msgFactory.getStateVariableMessage("PortMappingNumberOfEntries");
            try {
                StateVariableResponse resp = natTableSize.service();
                rtrval = new Integer(resp.getStateVariableValue());
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 404) break block2;
                throw ex;
            }
        }
        return rtrval;
    }

    public Integer getNatTableSize() throws IOException, UPNPResponseException {
        int startIndex = -1;
        for (int i = 0; i < 50; ++i) {
            try {
                this.getGenericPortMappingEntry(i);
                startIndex = i;
                break;
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 713) continue;
                throw ex;
            }
        }
        if (startIndex == -1) {
            return null;
        }
        int size = 0;
        try {
            while (true) {
                this.getGenericPortMappingEntry(startIndex++);
                ++size;
            }
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() != 713) {
                throw ex;
            }
            return new Integer(size);
        }
    }

    private void checkPortMappingProtocol(String prot) throws IllegalArgumentException {
        if (prot == null || !prot.equals("TCP") && !prot.equals("UDP")) {
            throw new IllegalArgumentException("PortMappingProtocol must be either TCP or UDP");
        }
    }

    private void checkPortRange(int port) throws IllegalArgumentException {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port range must be between 1 and 65535");
        }
    }
}

