/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sbbi.log.Log;
import net.sbbi.log.LogFactory;
import net.sbbi.upnp.jmx.HttpRequest;
import net.sbbi.upnp.jmx.UPNPMBeanDevice;
import net.sbbi.upnp.jmx.UPNPMBeanService;

public class UPNPMBeanDevicesDiscoveryHandler
implements Runnable {
    private static final Log log = LogFactory.getLog(UPNPMBeanDevicesDiscoveryHandler.class);
    private static final Map instances = new HashMap();
    private Set handledDevices = new HashSet();
    private MulticastSocket skt;
    private boolean isRunning = false;
    private boolean isRunningSSDPDaemon = false;
    private InetSocketAddress bindAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UPNPMBeanDevicesDiscoveryHandler getInstance(InetSocketAddress bindAddress) {
        String key = bindAddress.toString();
        Map map = instances;
        synchronized (map) {
            UPNPMBeanDevicesDiscoveryHandler handler = (UPNPMBeanDevicesDiscoveryHandler)instances.get(key);
            if (handler == null) {
                handler = new UPNPMBeanDevicesDiscoveryHandler(bindAddress);
                instances.put(key, handler);
            }
            return handler;
        }
    }

    private UPNPMBeanDevicesDiscoveryHandler(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUPNPMBeanDevice(UPNPMBeanDevice rootDevice) throws IOException {
        if (!rootDevice.isRootDevice()) {
            return;
        }
        Set set = this.handledDevices;
        synchronized (set) {
            Iterator i = this.handledDevices.iterator();
            while (i.hasNext()) {
                UPNPMBeanDevice registred = (UPNPMBeanDevice)i.next();
                if (!registred.getDeviceType().equals(rootDevice.getDeviceType()) || !registred.getUuid().equals(rootDevice.getUuid())) continue;
                throw new RuntimeException("An UPNPMBeanDevice object of type " + rootDevice.getDeviceType() + " with uuid " + rootDevice.getUuid() + " is already registred within this class, use a different UPNPMBeanDevice internalId");
            }
            if (this.handledDevices.size() == 0) {
                Thread runner = new Thread((Runnable)this, "UPNPMBeanDeviceDiscoveryHandler " + this.bindAddress.toString());
                runner.setDaemon(true);
                runner.start();
                SSDPAliveBroadcastMessageSender sender = new SSDPAliveBroadcastMessageSender(this.handledDevices);
                Thread runner2 = new Thread((Runnable)sender, "SSDPAliveBroadcastMessageSender " + this.bindAddress.toString());
                runner2.setDaemon(true);
                runner2.start();
            }
            this.sendHello(rootDevice);
            this.handledDevices.add(rootDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUPNPMBeanDevice(UPNPMBeanDevice rootDevice) throws IOException {
        if (!rootDevice.isRootDevice()) {
            return;
        }
        Set set = this.handledDevices;
        synchronized (set) {
            if (this.handledDevices.contains(rootDevice)) {
                this.handledDevices.remove(rootDevice);
                this.sendByeBye(rootDevice);
                if (this.handledDevices.size() == 0 && this.isRunning) {
                    this.isRunning = false;
                    this.isRunningSSDPDaemon = false;
                    this.skt.close();
                }
            }
        }
    }

    private void sendHello(UPNPMBeanDevice dv) throws IOException {
        InetAddress group = InetAddress.getByName("239.255.255.250");
        MulticastSocket multi = new MulticastSocket(this.bindAddress.getPort());
        multi.setInterface(this.bindAddress.getAddress());
        multi.setTimeToLive(dv.getSSDPTTL());
        List packets = this.getReplyMessages(dv, true, dv.getSSDPAliveDelay());
        for (int i = 0; i < packets.size(); ++i) {
            String packet = (String)packets.get(i);
            if (log.isDebugEnabled()) {
                log.debug("Sending ssdp alive message on 239.255.255.250:1900 multicast address:\n" + packet.toString());
            }
            byte[] pk = packet.getBytes();
            multi.send(new DatagramPacket(pk, pk.length, group, 1900));
        }
        multi.close();
    }

    private void sendByeBye(UPNPMBeanDevice dv) throws IOException {
        InetAddress group = InetAddress.getByName("239.255.255.250");
        MulticastSocket multi = new MulticastSocket(this.bindAddress.getPort());
        multi.setInterface(this.bindAddress.getAddress());
        multi.setTimeToLive(dv.getSSDPTTL());
        List packets = this.getByeByeReplyMessages(dv);
        for (int i = 0; i < packets.size(); ++i) {
            String packet = (String)packets.get(i);
            if (log.isDebugEnabled()) {
                log.debug("Sending ssdp:byebye message on 239.255.255.250:1900 multicast address:\n" + packet.toString());
            }
            byte[] pk = packet.getBytes();
            multi.send(new DatagramPacket(pk, pk.length, group, 1900));
        }
        multi.close();
    }

    private List getReplyMessages(UPNPMBeanDevice rootDevice, boolean ssdpAliveMsg, int maxAge) {
        ArrayList<String> rtrVal = new ArrayList<String>();
        StringBuffer basePacket = new StringBuffer();
        StringBuffer packet = null;
        if (ssdpAliveMsg) {
            basePacket.append("NOTIFY * HTTP/1.1\r\n");
            basePacket.append("HOST: 239.255.255.250:1900\r\n");
        } else {
            basePacket.append("HTTP/1.1 200 OK\r\n");
        }
        basePacket.append("CACHE-CONTROL: max-age = ").append(maxAge).append("\r\n");
        basePacket.append("LOCATION: ").append(rootDevice.getLocation()).append("\r\n");
        basePacket.append("SERVER: ").append(UPNPMBeanDevice.IMPL_NAME).append("\r\n");
        packet = new StringBuffer(basePacket.toString());
        if (ssdpAliveMsg) {
            packet.append("NT: uuid:").append(rootDevice.getUuid()).append("\r\n");
            packet.append("NTS: ssdp:alive\r\n");
        } else {
            packet.append("ST: uuid:").append(rootDevice.getUuid()).append("\r\n");
            packet.append("EXT:\r\n");
        }
        packet.append("USN: uuid:").append(rootDevice.getUuid()).append("\r\n\r\n");
        rtrVal.add(packet.toString());
        packet = new StringBuffer(basePacket.toString());
        if (ssdpAliveMsg) {
            packet.append("NT: ").append(rootDevice.getDeviceType()).append("\r\n");
            packet.append("NTS: ssdp:alive\r\n");
        } else {
            packet.append("ST: ").append(rootDevice.getDeviceType()).append("\r\n");
            packet.append("EXT:\r\n");
        }
        packet.append("USN: uuid:").append(rootDevice.getUuid()).append("::").append(rootDevice.getDeviceType()).append("\r\n\r\n");
        rtrVal.add(packet.toString());
        packet = new StringBuffer(basePacket.toString());
        if (ssdpAliveMsg) {
            packet.append("NT: upnp:rootdevice\r\n");
            packet.append("NTS: ssdp:alive\r\n");
        } else {
            packet.append("ST: upnp:rootdevice\r\n");
            packet.append("EXT:\r\n");
        }
        packet.append("USN: uuid:").append(rootDevice.getUuid()).append("::upnp:rootdevice\r\n\r\n");
        rtrVal.add(packet.toString());
        packet = new StringBuffer(basePacket.toString());
        ArrayList services = new ArrayList();
        services.addAll(rootDevice.getUPNPMBeanServices());
        Iterator i = rootDevice.getUPNPMBeanChildrens().iterator();
        while (i.hasNext()) {
            UPNPMBeanDevice child = (UPNPMBeanDevice)i.next();
            services.addAll(child.getUPNPMBeanServices());
            packet = new StringBuffer(basePacket.toString());
            if (ssdpAliveMsg) {
                packet.append("NT: uuid:").append(child.getUuid()).append("\r\n");
                packet.append("NTS: ssdp:alive\r\n");
            } else {
                packet.append("ST: uuid:").append(child.getUuid()).append("\r\n");
                packet.append("EXT:\r\n");
            }
            packet.append("USN: uuid:").append(child.getUuid()).append("\r\n\r\n");
            rtrVal.add(packet.toString());
            packet = new StringBuffer(basePacket.toString());
            if (ssdpAliveMsg) {
                packet.append("NT: ").append(child.getDeviceType()).append("\r\n");
                packet.append("NTS: ssdp:alive\r\n");
            } else {
                packet.append("ST: ").append(child.getDeviceType()).append("\r\n");
                packet.append("EXT:\r\n");
            }
            packet.append("USN: uuid:").append(child.getUuid()).append("::").append(child.getDeviceType()).append("\r\n\r\n");
            rtrVal.add(packet.toString());
        }
        i = services.iterator();
        while (i.hasNext()) {
            UPNPMBeanService srv = (UPNPMBeanService)i.next();
            if (ssdpAliveMsg) {
                packet.append("NT: ").append(srv.getServiceType()).append("\r\n");
                packet.append("NTS: ssdp:alive\r\n");
            } else {
                packet.append("ST: ").append(srv.getServiceType()).append("\r\n");
                packet.append("EXT:\r\n");
            }
            packet.append("USN: uuid:").append(srv.getDeviceUUID()).append("::").append(srv.getServiceType()).append("\r\n\r\n");
            rtrVal.add(packet.toString());
        }
        return rtrVal;
    }

    private List getByeByeReplyMessages(UPNPMBeanDevice rootDevice) {
        ArrayList<String> rtrVal = new ArrayList<String>();
        StringBuffer basePacket = new StringBuffer();
        StringBuffer packet = null;
        basePacket.append("NOTIFY * HTTP/1.1\r\n");
        basePacket.append("HOST: 239.255.255.250:1900\r\n");
        packet = new StringBuffer(basePacket.toString());
        packet.append("NT: uuid:").append(rootDevice.getUuid()).append("\r\n");
        packet.append("NTS: ssdp:byebye\r\n");
        packet.append("USN: uuid:").append(rootDevice.getUuid()).append("\r\n\r\n");
        rtrVal.add(packet.toString());
        packet = new StringBuffer(basePacket.toString());
        packet.append("NT: ").append(rootDevice.getDeviceType()).append("\r\n");
        packet.append("NTS: ssdp:byebye\r\n");
        packet.append("USN: uuid:").append(rootDevice.getUuid()).append("::").append(rootDevice.getDeviceType()).append("\r\n\r\n");
        rtrVal.add(packet.toString());
        packet = new StringBuffer(basePacket.toString());
        packet.append("NT: upnp:rootdevice\r\n");
        packet.append("NTS: ssdp:byebye\r\n");
        packet.append("USN: uuid:").append(rootDevice.getUuid()).append("::upnp:rootdevice\r\n\r\n");
        rtrVal.add(packet.toString());
        ArrayList services = new ArrayList();
        services.addAll(rootDevice.getUPNPMBeanServices());
        Iterator i = rootDevice.getUPNPMBeanChildrens().iterator();
        while (i.hasNext()) {
            UPNPMBeanDevice child = (UPNPMBeanDevice)i.next();
            services.addAll(child.getUPNPMBeanServices());
            packet = new StringBuffer(basePacket.toString());
            packet.append("NT: uuid:").append(child.getUuid()).append("\r\n");
            packet.append("NTS: ssdp:byebye\r\n");
            packet.append("USN: uuid:").append(child.getUuid()).append("\r\n\r\n");
            rtrVal.add(packet.toString());
            packet = new StringBuffer(basePacket.toString());
            packet.append("NT: ").append(child.getDeviceType()).append("\r\n");
            packet.append("NTS: ssdp:byebye\r\n");
            packet.append("USN: uuid:").append(child.getUuid()).append("::").append(child.getDeviceType()).append("\r\n\r\n");
            rtrVal.add(packet.toString());
        }
        i = services.iterator();
        while (i.hasNext()) {
            UPNPMBeanService srv = (UPNPMBeanService)i.next();
            packet = new StringBuffer(basePacket.toString());
            packet.append("NT: urn:").append(srv.getServiceType()).append("\r\n");
            packet.append("NTS: ssdp:byebye\r\n");
            packet.append("USN: uuid:").append(srv.getDeviceUUID()).append("::").append(srv.getServiceType()).append("\r\n\r\n");
            rtrVal.add(packet.toString());
        }
        return rtrVal;
    }

    public void run() {
        InetAddress group = null;
        try {
            group = InetAddress.getByName("239.255.255.250");
            this.skt = new MulticastSocket(1900);
            this.skt.setInterface(this.bindAddress.getAddress());
            this.skt.joinGroup(group);
        }
        catch (IOException ex) {
            log.error("Error during multicast socket creation, thread cannot start", ex);
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                String searchTarget;
                String man;
                HttpRequest req;
                byte[] buffer = new byte[4096];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length, group, this.bindAddress.getPort());
                this.skt.receive(packet);
                String received = new String(packet.getData(), 0, packet.getLength());
                if (log.isDebugEnabled()) {
                    log.debug("Received message:\n" + received);
                }
                if (!(req = new HttpRequest(received)).getHttpCommand().equals("M-SEARCH") || !(man = req.getHTTPHeaderField("MAN")).equals("\"ssdp:discover\"") || !(searchTarget = req.getHTTPHeaderField("ST")).equals("upnp:rootdevice")) continue;
                MulticastSocket multi = new MulticastSocket();
                multi.setInterface(this.bindAddress.getAddress());
                Iterator i = this.handledDevices.iterator();
                while (i.hasNext()) {
                    UPNPMBeanDevice dv = (UPNPMBeanDevice)i.next();
                    List packets = this.getReplyMessages(dv, false, dv.getSSDPAliveDelay());
                    for (int z = 0; z < packets.size(); ++z) {
                        String pack = (String)packets.get(z);
                        if (log.isDebugEnabled()) {
                            log.debug("Sending http reply message on " + packet.getAddress() + ":" + packet.getPort() + " multicast address:\n" + pack.toString());
                        }
                        byte[] pk = pack.getBytes();
                        multi.setTimeToLive(dv.getSSDPTTL());
                        multi.send(new DatagramPacket(pk, pk.length, packet.getAddress(), packet.getPort()));
                    }
                }
                multi.close();
            }
            catch (IOException ex) {
                if (!this.isRunning) continue;
                log.error("Error during multicast socket IO operations", ex);
            }
        }
    }

    private class SSDPAliveBroadcastMessageSender
    implements Runnable {
        private Set devices = new HashSet();
        private Map devicesLastBroadCast = new HashMap();

        private SSDPAliveBroadcastMessageSender(Set upnpRootDevices) {
            this.devices = upnpRootDevices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UPNPMBeanDevicesDiscoveryHandler.this.isRunningSSDPDaemon = true;
            while (UPNPMBeanDevicesDiscoveryHandler.this.isRunningSSDPDaemon) {
                Set set = this.devices;
                synchronized (set) {
                    Iterator i = this.devices.iterator();
                    while (i.hasNext()) {
                        UPNPMBeanDevice dv = (UPNPMBeanDevice)i.next();
                        String key = dv.getUuid();
                        long deviceDelay = dv.getSSDPAliveDelay();
                        Long lastCall = (Long)this.devicesLastBroadCast.get(key);
                        if (lastCall == null) {
                            lastCall = new Long(System.currentTimeMillis() + deviceDelay * 60L + 1000L);
                            this.devicesLastBroadCast.put(key, lastCall);
                        }
                        if (lastCall + deviceDelay * 60L >= System.currentTimeMillis()) continue;
                        try {
                            InetAddress group = InetAddress.getByName("239.255.255.250");
                            MulticastSocket multi = new MulticastSocket(UPNPMBeanDevicesDiscoveryHandler.this.bindAddress.getPort());
                            multi.setInterface(UPNPMBeanDevicesDiscoveryHandler.this.bindAddress.getAddress());
                            multi.setTimeToLive(dv.getSSDPTTL());
                            multi.joinGroup(group);
                            List packets = UPNPMBeanDevicesDiscoveryHandler.this.getReplyMessages(dv, true, dv.getSSDPAliveDelay());
                            for (int z = 0; z < packets.size(); ++z) {
                                String pack = (String)packets.get(z);
                                if (log.isDebugEnabled()) {
                                    log.debug("Sending http message on " + group.getAddress() + ":1900 multicast address:\n" + pack.toString());
                                }
                                byte[] pk = pack.getBytes();
                                multi.send(new DatagramPacket(pk, pk.length, group, 1900));
                            }
                            multi.leaveGroup(group);
                            multi.close();
                            this.devicesLastBroadCast.put(key, new Long(System.currentTimeMillis()));
                        }
                        catch (IOException ex) {
                            log.error("Error occured during SSDP alive broadcast message sending", ex);
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

