#
# (C) Tenable Network Security
#

if(description)
{
 script_id(16321);
 script_version ("$Revision: 1.9 $");

 script_cve_id("CVE-2005-0276", "CVE-2005-0277", "CVE-2005-0278", "CVE-2005-0419");
 script_bugtraq_id(12155, 12463);
 script_xref(name:"OSVDB", value:"12810");
 script_xref(name:"OSVDB", value:"12811");
 
 name["english"] = "3Com 3CServer/3CDaemon FTP Overflow";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis : 

The remote FTP server is affected by multiple issues. 

Description :

The remote host is running the 3Com 3CServer or 3CDaemon FTP server. 

According to its banner, the version of the 3CServer / 3CDaemon FTP
server on the remote host is reportedly affected by multiple buffer
overflow and format string vulnerabilities as well as an information
leak issue.  An attacker may be able to exploit these flaws to execute
arbitrary code on the remote host with the privileges of the FTP
server, generally Administrator. 

See also :

http://www.securityfocus.com/archive/1/385969
http://www.securityfocus.com/archive/1/389623

Solution : 

Unknown at this time. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for 3Com 3CServer FTP Server";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "FTP";
 script_family(english:family["english"]);
 script_require_ports("Services/ftp", 21);
 script_dependencies("find_service1.nasl");
 exit(0);
}


include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if ( ! port ) port = 21;

ftpbanner = get_ftp_banner(port:port);
if ( ftpbanner == NULL ) exit(0);
if ( egrep(pattern:"^220 3Com FTP Server Version 1\.[01]([^0-9]|\.)", string:ftpbanner) ||
     egrep(pattern:"^220 3Com 3CDaemon FTP Server Version [0-2]\.", string:ftpbanner)) 
	security_hole(port);
