# This script was automatically generated from the SSA-2008-042-01
# Slackware Security Advisory
# It is released under the Nessus Script Licence.
# Slackware Security Advisories are copyright 1999-2004 Slackware Linux, Inc.
# SSA2nasl Convertor is copyright 2004 Michel Arboi
# See http://www.slackware.com/about/ or http://www.slackware.com/security/
# Slackware(R) is a registered trademark of Slackware Linux, Inc.

if (! defined_func("bn_random")) exit(0);
desc='
New kernel packages are available for Slackware 12.0, and -current to
fix a local root exploit.

More details about this issue may be found in the Common
Vulnerabilities and Exposures (CVE) database:

  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0010
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0163
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0600


';
if (description) {
script_id(31027);
script_version("$Revision: 1.1 $");
script_category(ACT_GATHER_INFO);
script_family(english: "Slackware Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_copyright("This script is Copyright (C) 2008 Michel Arboi <mikhail@nessus.org>");
script_require_keys("Host/Slackware/release", "Host/Slackware/packages");
script_description(english: desc);

script_xref(name: "SSA", value: "2008-042-01");
script_summary("SSA-2008-042-01 kernel exploit fix ");
name["english"] = "SSA-2008-042-01 kernel exploit fix ";
script_name(english:name["english"]);
script_cve_id("CVE-2008-0010","CVE-2008-0163","CVE-2008-0600");
exit(0);
}

include('slackware.inc');
include('global_settings.inc');

if (slackware_check(osver: "12.0", pkgname: "kernel-generic", pkgver: "2.6.21.5", pkgnum:  "2", pkgarch: "i486")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-generic is vulnerable in Slackware 12.0
Upgrade to kernel-generic-2.6.21.5-i486-2_slack12.0 or newer.
');
}
if (slackware_check(osver: "12.0", pkgname: "kernel-generic-smp", pkgver: "2.6.21.5_smp", pkgnum:  "2", pkgarch: "i686")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-generic-smp is vulnerable in Slackware 12.0
Upgrade to kernel-generic-smp-2.6.21.5_smp-i686-2_slack12.0 or newer.
');
}
if (slackware_check(osver: "12.0", pkgname: "kernel-huge", pkgver: "2.6.21.5", pkgnum:  "2", pkgarch: "i486")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-huge is vulnerable in Slackware 12.0
Upgrade to kernel-huge-2.6.21.5-i486-2_slack12.0 or newer.
');
}
if (slackware_check(osver: "12.0", pkgname: "kernel-huge-smp", pkgver: "2.6.21.5_smp", pkgnum:  "2", pkgarch: "i686")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-huge-smp is vulnerable in Slackware 12.0
Upgrade to kernel-huge-smp-2.6.21.5_smp-i686-2_slack12.0 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-generic", pkgver: "2.6.23.16", pkgnum:  "1", pkgarch: "i486")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-generic is vulnerable in Slackware -current
Upgrade to kernel-generic-2.6.23.16-i486-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-generic-smp", pkgver: "2.6.23.16_smp", pkgnum:  "1", pkgarch: "i686")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-generic-smp is vulnerable in Slackware -current
Upgrade to kernel-generic-smp-2.6.23.16_smp-i686-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-huge", pkgver: "2.6.23.16", pkgnum:  "1", pkgarch: "i486")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-huge is vulnerable in Slackware -current
Upgrade to kernel-huge-2.6.23.16-i486-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-huge-smp", pkgver: "2.6.23.16_smp", pkgnum:  "1", pkgarch: "i686")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-huge-smp is vulnerable in Slackware -current
Upgrade to kernel-huge-smp-2.6.23.16_smp-i686-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-modules", pkgver: "2.6.23.16", pkgnum:  "1", pkgarch: "i486")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-modules is vulnerable in Slackware -current
Upgrade to kernel-modules-2.6.23.16-i486-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-modules-smp", pkgver: "2.6.23.16_smp", pkgnum:  "1", pkgarch: "i686")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-modules-smp is vulnerable in Slackware -current
Upgrade to kernel-modules-smp-2.6.23.16_smp-i686-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-headers", pkgver: "2.6.23.16_smp", pkgnum:  "1", pkgarch: "i386")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-headers is vulnerable in Slackware -current
Upgrade to kernel-headers-2.6.23.16_smp-i386-1 or newer.
');
}
if (slackware_check(osver: "-current", pkgname: "kernel-source", pkgver: "2.6.23.16_smp", pkgnum:  "1", pkgarch: "noarch")) {
w++;
if (report_verbosity > 0) desc = strcat(desc, '
The package kernel-source is vulnerable in Slackware -current
Upgrade to kernel-source-2.6.23.16_smp-noarch-1 or newer.
');
}

if (w) { security_hole(port: 0, data: desc); }
