#
# (C) Tenable Network Security, Inc.
#

account = "informix";
password = "informix";

if(description)
{
 script_id(24275);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CVE-1999-0502");
 
 script_name(english:"Default password 'informix' for account 'informix'");
 script_summary(english:"Logs into the remote host");

  desc["english"] = "
Synopsis :

An account on the remote host uses a known password. 

Description :

The password for the account 'informix' on the remote host is
'informix'.  An attacker may leverage this issue to gain access to the
affected system and launch further attacks against it. 

Solution :

Change the password for this account or disable it. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 script_description(english:desc["english"]);

 script_category(ACT_GATHER_INFO);
 script_family(english:"Default Unix Accounts");
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

 script_dependencie("find_service1.nasl", "ssh_detect.nasl");
 script_require_ports("Services/telnet", 23, "Services/ssh", 22);
 script_require_keys("Settings/ThoroughTests");
 exit(0);
}

#
# The script code starts here : 
#
include("default_account.inc");
include("global_settings.inc");
if ( ! thorough_tests ) exit(0);

port = check_account(login:account, password:password);
if(port)security_hole(port);
