#
# (C) Tenable Network Security
#

if(description)
{
 script_id(17989);
 script_cve_id("CVE-2005-1029", "CVE-2005-1030");
 script_bugtraq_id(13039, 13038, 13036, 13035, 13034, 13032);
 script_version("$Revision: 1.5 $");
 name["english"] = "Active Auction Multiple Vulnerabilities";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote server contains a ASP script that is affected by various
issues. 

Description :

The remote host is running Active Auction, an auction software written
in ASP. 

The remote version of this software is affected by various SQL
injection and cross-site scripting issues. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2005-04/0079.html

Solution : 

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for a SQL injection error in Active Auction House";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if ( ! can_host_asp(port:port) ) exit(0);


foreach dir (make_list( cgi_dirs()))
{
 req = http_get(item:dir + "/activeauctionsuperstore/ItemInfo.asp?itemID=42'", port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if ( res == NULL ) exit(0);
 if(egrep(pattern:"Microsoft.*ODBC.*80040e14", string:res ) )
  {
  security_hole(port);
  exit(0);
  }
}
