#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24002);
  script_version("$Revision: 1.5 $");

  script_cve_id(
    "CVE-2006-5857", 
    "CVE-2007-0044",
    "CVE-2007-0045",
    "CVE-2007-0046",
    "CVE-2007-0047",
    "CVE-2007-0048"
  );
  script_bugtraq_id(21858, 21981);
  script_xref(name:"OSVDB", value:"31047");
  script_xref(name:"OSVDB", value:"31316");

  script_name(english:"Adobe Reader < 6.0.6 / 7.0.9");
  script_summary(english:"Checks version of Adobe Reader");

  desc = "
Synopsis :

The PDF file viewer on the remote Windows host is affected by several
vulnerabilities. 

Description :

The version of Adobe Reader installed on the remote host is earlier
than 7.0.9 / 8.0 and thus reportedly is affected by several security
issues, including one that can lead to arbitrary code execution when
processing a malicious PDF file. 

See also :

http://www.piotrbania.com/all/adv/adobe-acrobat-adv.txt
http://archives.neohapsis.com/archives/fulldisclosure/2007-01/0200.html
http://www.adobe.com/support/security/bulletins/apsb07-01.html

Solution : 

Upgrade to Adobe Reader 6.0.6 / 7.0.9 / 8.0 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";

  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("adobe_reader_installed.nasl");
  script_require_keys("SMB/Acroread/Version");

  exit(0);
}


ver = get_kb_item("SMB/Acroread/Version");
if (
  ver && 
  ver =~ "^([0-5]\.|6\.0\.[0-5][^0-9.]?|7\.0\.[0-8][^0-9.]?)"
) security_hole(get_kb_item("SMB/transport"));
