#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30200);
  script_version("$Revision: 1.7 $");
  script_cve_id(
    "CVE-2007-5659",
    "CVE-2007-5663",
    "CVE-2007-5666",
    "CVE-2008-0655",
    "CVE-2008-0667",
    "CVE-2008-0726"
  );
  script_bugtraq_id(27641);

  script_name(english:"Adobe Reader < 8.1.2");
  script_summary(english:"Checks version of Adobe Reader");

  desc = "
Synopsis :

The PDF file viewer on the remote Windows host is affected by multiple
vulnerabilities. 

Description :

The version of Adobe Reader installed on the remote host is earlier
than 8.1.2.  Such versions are reportedly affected by multiple 
vulnerabilities :

  - A design error vulnerability may allow an attacker to 
    gain control of a user's printer.

  - Multiple stack-based buffer overflows may allow an
    attacker to execute arbitrary code subject to the 
    user's privileges.

  - Insecure loading of 'Security Provider' libraries may
    allow for arbitrary code execution.

  - An insecure method exposed by the Javascript library
    in the 'EScript.api' plug-in allows direct control
    over low-level features of the object, which allows 
    for execution of arbitrary code as the current user.

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=655
http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=656
http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=657
http://www.zerodayinitiative.com/advisories/ZDI-08-004.html
http://archives.neohapsis.com/archives/bugtraq/2008-02/0080.html
http://archives.neohapsis.com/archives/bugtraq/2008-02/0104.html
http://archives.neohapsis.com/archives/bugtraq/2008-02/0105.html
http://archives.neohapsis.com/archives/bugtraq/2008-02/0106.html
http://archives.neohapsis.com/archives/bugtraq/2008-02/0147.html
http://www.adobe.com/go/kb403079
http://www.adobe.com/support/security/advisories/apsa08-01.html

Solution :

Upgrade to Adobe Reader 8.1.2 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("adobe_reader_installed.nasl");
  script_require_keys("SMB/Acroread/Version");

  exit(0);
}


include("global_settings.inc");


ver = get_kb_item("SMB/Acroread/Version");
if (
  ver && 
  ver =~ "^([0-7]\.|8\.(0\.|1\.[01][^0-9.]?))"
)
{
  if (report_verbosity)
  {
    report = string(
      "\n",
      "The remote version of Adobe Reader is ", ver, ".\n"
    );
    security_hole(port:get_kb_item("SMB/transport"), extra:report);
  }
  else security_hole(get_kb_item("SMB/transport"));
}
