#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25170);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0609");
  script_bugtraq_id(23876);
  script_xref(name:"OSVDB", value:"33879");

  script_name(english:"Advanced Guestbook lang Cookie Local File Include Vulnerability");
  script_summary(english:"Tries to execute a local file");
 
  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by a
local file include vulnerability. 

Description :

The remote host is running Advanced Guestbook, a free guestbook
written in PHP. 

The installed version of Advanced Guestbook fails to validate input to
the 'lang' cookie before using it as a language template.  An
unauthenticated remote attacker may be able to exploit these issues to
view arbitrary files or to execute arbitrary PHP code on the remote
host, subject to the privileges of the web server user id. 

See also :

http://www.netvigilance.com/advisory0013
http://archives.neohapsis.com/archives/bugtraq/2007-05/0094.html

Solution :

Unknown at this time. 

Risk factor : 

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/guestbook", "/gbook", "/gb", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to execute the application's misc/forget_pass.php.
  file = "../misc/forget_pass";
  req = http_get(item:string(dir, "/"), port:port);
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Cookie: lang=", file, "\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if the request includes output from the file
  # we requested.
  if (
    "<title>Create new password" >< res && 
    'href="http://www.proxy2.de"' >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
