#
# This script was written by Renaud Deraison
#

if(description)
{
 script_id(11487);
 script_version ("$Revision: 1.8 $");

 script_cve_id("CVE-2003-1181");
 script_bugtraq_id(7171);
 script_xref(name:"OSVDB", value:"3292");
 
 name["english"] = "Advanced Poll info.php";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is affected by an
information disclosure vulnerability. 

Description :

The remote host is running Chien Kien Uong's Advanced Poll, a simple
Poll system using PHP. 

By default, this utility includes a file named 'info.php' that makes a
call to 'phpinfo()' and displays a lot of information about the remote
host and how PHP is configured.  An attacker may use this flaw to gain
a more intimate knowledge about the remote host and better prepare its
attacks. 

See also :

http://www.securityfocus.com/archive/1/342493

Solution : 

Delete the affected file.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
 script_description(english:desc["english"]);
 summary["english"] = "Checks for the presence of info.php";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 script_dependencies("http_version.nasl");
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if ( !can_host_php(port:port) ) exit(0);


foreach dir (make_list("/poll", cgi_dirs()))
{
 req = http_get(item:string(dir, "/misc/info.php"), port:port);
 res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if( res == NULL ) exit(0);
 if("<title>phpinfo()</title>" >< res)
 	{
	security_warning(port);
	exit(0);
	}
}
