#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is susceptible to
buffer overflow vulnerabilities. 

Description :

The Windows remote host contains the Download Manager ActiveX control
from Akamai, which helps users download content. 

The version of this ActiveX control on the remote host reportedly
contains two stack-based buffer overflow vulnerabilities.  A remote
attacker may be able to leverage these issues to execute arbitrary
code on the remote host subject to the privileges of the current user. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=514
http://archives.neohapsis.com/archives/fulldisclosure/2007-04/0474.html
http://www.securityfocus.com/archive/1/465908/30/0/threaded

Solution :

Upgrade to version 2.2.1.0 or later of the control. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25038);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-1891", "CVE-2007-1892");
  script_bugtraq_id(23522);
  script_xref(name:"OSVDB", value:"34323");
  script_xref(name:"OSVDB", value:"34324");

  script_name(english:"Akamai Download Manager ActiveX Control < 2.2.1.0 Vulnerabilities");
  script_summary(english:"Checks version of Download Manager ActiveX control"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Check whether it's installed.
file = NULL;
ver = NULL;

clsid = "{2AF5BD25-90C5-4EEC-88C5-B44DC2905D8B}";
key = "SOFTWARE\Classes\CLSID\" + clsid +  "\InprocServer32";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:NULL);
  if (!isnull(value)) file = value[1];

  RegCloseKey(handle:key_h);
}
if (file)
{
  # Check its version.
  key = "SOFTWARE\Microsoft\Code Store Database\Distribution Units\" + clsid +  "\InstalledVersion";
  key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
  if (!isnull(key_h))
  {
    value = RegQueryValue(handle:key_h, item:NULL);
    if (!isnull(value)) ver = value[1];

    RegCloseKey(handle:key_h);
  }
}
RegCloseKey(handle:hklm);
if (isnull(file))
{
  NetUseDel();
  exit(0);
}


# Make sure the control exists.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:file);
ocx =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1", string:file);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:ocx,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
if (!isnull(fh))
{
  CloseFile(handle:fh);

  # Check the version number.
  iver = split(ver, sep:',', keep:FALSE);
  for (i=0; i<max_index(iver); i++)
    iver[i] = int(iver[i]);

  if (
    !isnull(ver) &&
    (
      iver[0] < 2 ||
      (
        iver[0] == 2 &&
        (
          iver[1] < 2 ||
          (iver[1] == 2 && iver[2] < 1)
        )
      )
    )
  )
  {
    version = string(iver[0], ".", iver[1], ".", iver[2], ".", iver[3]);
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Version ", version, " of the control is installed as \n",
      "\n",
      "  ", file, "\n"
    );
    security_hole(port:port, data:report);
  }
}


# Clean up.
NetUseDel();
