#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29703);
  script_version("$Revision: 1.1 $");

  script_name(english:"Anon Proxy Server Detection");
  script_summary(english:"Looks at banner for evidence of Anon Proxy Server");

  desc = "
Synopsis :

Anon Proxy Server is running on the remote host. 

Description :

The remote service is a proxy server named Anon Proxy Server, which
can operated either as a normal HTTP / HTTPS / Socks proxy or a P2P
anonymous proxy. 

See also :

http://anonproxyserver.sourceforge.net/

Solution :

Make sure use of this program is in accordance with your corporate
security policy.  And limit incoming traffic to this port if desired. 

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/www", 80, "Services/http_proxy", 8080, 8082);

  exit(0);
}


include("http_func.inc");
include("misc_func.inc");


# Get a list of possible ports.
ports = add_port_in_list(list:get_kb_list("Services/http_proxy"), port:8080);
ports = add_port_in_list(list:ports, port:8082);
# nb: currently find_service.nes flags this as a web server.
www_servers = get_kb_list("Services/www");
if (!isnull(www_servers))
{
  foreach port (www_servers)
    ports = add_port_in_list(list:ports, port:port);
}


# Iterate over each port.
foreach port (ports)
{
  if (get_port_state(port))
  {
    # Look for Anon-Proxy response header in the banner.
    banner = get_http_banner(port:port);
    if (banner && "Anon-Proxy: message" >< banner) 
    {
      register_service(port:port, proto:"http_proxy");
      security_note(port);
    }
  }
}
