#
# (C) Tenable Network Security
#
if(description)
{
  script_id(11909);
  script_cve_id("CVE-2003-1138");
  script_bugtraq_id(8898);
  script_xref(name:"OSVDB", value:"19137");
  script_version ("$Revision: 1.11 $");
    script_name(english:"Apache2 double slash dir index");
  desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure
vulnerability. 

Description :

It is possible to obtain the listing of the content of the remote web
server root by sending the request 'GET // HTTP/1.0' This
vulnerability usually affects the default Apache configuration which
is shipped with Red Hat Linux, although it might affect other Linux
distributions or other web server. 

An attacker can exploit this flaw to browse the contents of the remote
web server and possibly find hidden links. 

See also :

http://www.securityfocus.com/archive/1/342578/30/0/threaded

Solution :

Create an index file for each directory instead of default welcome
pages. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

  script_description(english:desc["english"]);
  script_summary(english:"sends a GET // HTTP/1.0");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Remote file access");
  script_copyright(english:"This script is Copyright (C) 2003-2008 Tenable Network Security, Inc.");
  script_dependencies("find_service1.nasl", "http_version.nasl");
  script_require_keys("www/apache");
  script_require_ports("Services/www", 80);
  exit(0);
}



#
# The script code starts here

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);


res = http_get_cache(item:"/", port:port);
if ( res == NULL ) exit(0);
if ( "Index of /" >< res) exit(0);

req = http_get(item:"//", port:port);
res = http_keepalive_send_recv(port:port, data:req);


if ( "Index of /" >< res) security_warning(port);
