#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30056);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2008-0475");
  script_bugtraq_id(27443);

  script_name(english:"ManageEngine Applications Manager Information Disclosure Vulnerability");
  script_summary(english:"Sends an invalid URL to AppManager");

  desc = "
Synopsis :

The remote web server contains an application affected by an
information disclosure vulnerability. 

Description :

The remote host is running ManageEngine Applications Manager, a
web-based tool for monitoring websites, databases, and other
applications. 

The version of Applications Manager installed on the remote host
returns a summary of monitor groups and alerts in response to a
request with an invalid URL, which may reveal sensitive information
about the applications and services being monitored. 

Note that this version may also be affected by several other
information disclosure and cross-site scripting vulnerabilities,
although Nessus did not explicitly check for them. 

See also :

http://secunia.com/advisories/28332/

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 9090);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:9090);
if (!get_port_state(port)) exit(0);


# Exploit the issue.
req = http_get(item:"/-", port:port);
res = http_keepalive_send_recv(port:port, data:req, fetch404:TRUE);
if (res == NULL) exit(0);


# There's a problem if we get to AppManager's Monitor Groups display.
if (
  "title>Applications Manager - Monitor Groups<" >< res &&
  "<!--$Id: Recent" >< res
) security_warning(port);
