#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23841);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6379");
  script_bugtraq_id(21502);
  script_xref(name:"OSVDB", value:"30775");

  script_name(english:"BrightStor ARCserve Backup Discovery Service Buffer Overflow Vulnerability");
  script_summary(english:"Checks version of BrightStor ARCserve Backup");

  desc = "
Synopsis :

The remote service is affected by a buffer overflow vulnerability. 

Description :

According to its version, the installation of BrightStor ARCserve
Backup on the remote host allows an attacker to execute arbitrary code
on the affected host with SYSTEM privileges due to a buffer overflow
that can be triggered by a specially-crafted packet sent to the
Discovery Service. 

Note that the vendor reports only Windows installs are vulnerable. 

See also : 

http://supportconnectw.ca.com/public/storage/infodocs/babsecurity-notice.asp
http://www.securityfocus.com/archive/1/archive/1/453916/100/0/threaded

Solution :

Either apply the appropriate patch as described in the vendor advisory
referenced above or upgrade to BrightStor ARCserve Backup r11.5 SP2 or
later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");
 
  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");
 
  script_dependencies("arcserve_discovery_service_detect.nasl", "os_fingerprint.nasl");
  script_require_keys("ARCSERVE/Discovery/Version");

  exit(0);
}


os = get_kb_item("Host/OS");
if (!os || "Windows" >!< os) exit(0);


ver = get_kb_item("ARCSERVE/Discovery/Version");
if (isnull(ver)) exit(0);

port = get_kb_item("Services/udp/casdscsvc");
if (!port) exit(0);


matches = eregmatch(string:ver, pattern:"^[a-z]([0-9]+\.[0-9]+) \(build ([0-9]+)\)$");
if (!isnull(matches))
{
  ver = matches[1];
  build = int(matches[2]);

  if (
    (ver == "11.5" && build < 4232) ||
    (ver == "11.1" && build < 3205) ||
    # nb: QI82917 says there's no patch for 11.0; the solution is to 
    #     upgrade to 11.1 and then apply QO82863.
    (ver == "11.0") ||
    # nb: QO84611 doesn't exist.
    (ver == "10.5") ||
    (ver == "9.0" && build < 2203)
  ) security_hole(port:port, proto:"udp");
}
