#
# (C) Tenable Network Security
#


if(description)
{
 script_id(16364);
 script_version("$Revision: 1.5 $");
 
 script_cve_id("CVE-2005-0367");
 script_bugtraq_id(12502);

 name["english"] = "ArGoSoft Mail Server Directory Traversal Vulnerability";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected by a directory traversal
vulnerability. 

Description :

The remote host is running the ArGoSoft WebMail interface.  There are
multiple flaws in this interface that may allow an authenticated
attacker to read arbitrary files on the remote server and create /
delete arbitrary directories on the affected host. 

See also :

http://www.securityfocus.com/archive/1/389866

Solution : 

Upgrade to ArGoSoft 1.8.7.4 or later.

Risk factor :

Medium / CVSS Base Score : 6.5
(CVSS2#AV:N/AC:L/Au:S/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Gets the version of the remote ArGoSoft server";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");



port = get_http_port(default:80);

if(get_port_state(port))
{
 res = http_get_cache(item:"/", port:port);
 if( res == NULL ) exit(0);
 if((vers = egrep(pattern:".*ArGoSoft Mail Server.*Version", string:res)))
 {
  if(ereg(pattern:".*Version.*\((0\.|1\.([0-7]\.|8\.([0-6]\.|7\.[0-3])))\)", 
  	  string:vers))security_warning(port);
 }
}
