#
# (C) Tenable Network Security
#
#

if(description)
{
 script_id(16334);
 script_version("$Revision: 1.7 $");

 script_cve_id("CVE-2005-0519", "CVE-2005-0520");
 script_bugtraq_id(12487, 12632);

 name["english"] = "ArGoSoft FTP Server < 1.4.2.8 Multiple Vulnerabilities";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote FTP server is susceptible to several file access attacks. 

Description :

The remote host is running the ArGoSoft FTP Server. 

It is reported that ArGoSoft FTP Server allows an attacker to upload
shortcut (.LNK) files via either a 'SITE UNZIP' or 'SITE COPY' command
and gain read and write access to any files and directories on the FTP
server. 

See also :

http://www.argosoft.com/ftpserver/changelist.aspx

Solution : 

Upgrade to ArGoSoft FTP 1.4.2.8 or later.

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Gets the version of the remote ArGoSoft server";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "FTP";
 script_family(english:family["english"]);
 script_dependencie("ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

# Check starts here

include("ftp_func.inc");


port = get_kb_item("Services/ftp");
if ( ! port ) port = 21;
if ( ! get_port_state(port) ) exit(0);

banner = get_ftp_banner(port:port);
if (!banner) exit(0);

if (
  "ArGoSoft FTP Server" >< banner &&
  egrep(pattern:"^220 ArGoSoft FTP Server.*Version.*\(1\.([0-3]\..*|4\.[0-1]\.|4\.2.\.[0-7][^0-9])", string:banner)
) security_hole(port);
