#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25674);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-3621");
  script_bugtraq_id(24781);
  script_xref(name:"OSVDB", value:"37846");

  script_name(english:"AsteriDex IN Parameter Command Injection Vulnerability");
  script_summary(english:"Checks if AsteriDex's callboth.php script filters newlines");

  desc = "
Synopsis :

The remote web server contains a PHP script that may allow execution
of arbitrary commands. 

Description :

The remote host is running AsteriDex, a web-based dialer and address
book for Asterisk. 

The version of AsteriDex installed on the remote host fails to
sanitize input to the 'IN' parameter of the 'callboth.php' script
before passing it to the Asterisk Call Manager as part of the data
stream of an authenticated session.  Using a valid SIP address that
answers when dialed, an unauthenticated attacker can leverage this
issue to execute arbitrary code on the remote host subject to the
privileges of the user id under which Asterisk runs. 

See also :

http://www.securityfocus.com/archive/1/472907/30/0/threaded
http://www.milw0rm.com/exploits/4151

Solution :

Upgrade to AsteriDex version 3.1 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/asteridex", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  exploit = string(unixtime(), "@nessus\r\n", SCRIPT_NAME);
  req = http_get(
    item:string(
      dir, "/callboth.php?",
      "SEQ=654321&",
      "OUT=123456&",
      "IN=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if the CR/LF was not filtered out.
  if (string("Extension SIP/", exploit, " is ringing now") >< res)
  {
    security_hole(port);
    exit(0);
  }
}
