#TRUSTED 5acf899631f4b2f79d0c6b1027a38506dc1d5bd583645a0a57e6f289a0a71a0d5c0ff336864509d218bdec4290bf4d26dd155ccc6df72d29eb00ce9d086d9f146d3c3eb040783a542a060ca5773b2c6501d31960b11cf5f67b9b2a736efabae02677b165a016193648a8357f92cb4b90e109dddd50c78a8a6e6c3c5dd2f59f96b95cf20be1b460872c2daa304ba36f3a301b405b96c44965eca7af43827e6d1aaffca0c8bae9b196af8aba8bd6cc41b8e50fc2c7945a2ac5957966049867fc7336506e61a0f70876105a3bcee8f1efbabce3c0897a4f8408722b66a3cc74284ecc0d229c5209d70c1f5e9260b37d55b7919998fb977ff0e863d8a4efe2809736798b1cd34eb73da8c57b9b268e5ec15bf347ba6a0266c3dd7b9b62f1d3d1dcf4704c2535019100ff97ecdce19efe60e285d70174d15fdacddfffd9a307dab08e00e85e469bb9273cf76a26e90be11b580de4f21a5f16272c34cf557d65b67da38e130d2c4717fda85cb0adf541e7d42cee481aa31c1c3a42d3aad9e5ee0ff968cbce7b430630994a14a450efe38f759a3332e8d992c05ef74f66a8c153ea892144870aa23aa5ca5824543c9a5059a0339f473eb498e15587545086a829fe1ae92f62bd5f1387607a511f921b165277808c16376425f988ff0c71b9d94e2aede3203eb6878ce79117a3a7bba757adf07755b557aba8dd92be694a1199a87fc8e5
#
# (C) Tenable Network Security
#


if(description)
{
 script_id(23971);
 script_version("1.4");
 name["english"] = "Remote host on same physical but not logical network";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The physical network is set up in a potentially insecure way.

Description :

The remote host is on a different logical network. However, it is
on the same physical subnet.

An attacker connecting from the same network as your Nessus
scanner is on could reconfigure his system to force it
to belong to the subnet of the remote host.

This makes any filtering between the two subnets useless.

Solution : 

Use VLANs to separate different logical networks.

Risk factor : 

Low";

 script_description(english:desc["english"]);
 
 summary["english"] = "Performs an ARP who-is on the remote host";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Firewalls";
 script_family(english:family["english"]);
 exit(0);
}


#


# ByteFunc included here
BYTE_ORDER_BIG_ENDIAN  		= 1;
BYTE_ORDER_LITTLE_ENDIAN 	= 2;

ByteOrder = BYTE_ORDER_BIG_ENDIAN;

function set_byte_order()
{
 ByteOrder = _FCT_ANON_ARGS[0];
}

function mkbyte()
{
 local_var l;
 l = _FCT_ANON_ARGS[0];
 return raw_string(l & 0xff);
}

function mkword()
{
 local_var l;
 l = _FCT_ANON_ARGS[0];

 if ( ByteOrder == BYTE_ORDER_BIG_ENDIAN )
 	return  raw_string((l >> 8) & 0xFF, l & 0xFF);
 else
 	return  raw_string(l & 0xff, (l >> 8) & 0xff);
}


function mkdword()
{
 local_var l;
 l = _FCT_ANON_ARGS[0];

 if ( ByteOrder == BYTE_ORDER_BIG_ENDIAN )
	 return  raw_string( (l >> 24 ) & 0xff,
		     	     (l >> 16 ) & 0xff,
		     	     (l >>  8 ) & 0xff,
		     	     (l)   & 0xff);
 else
	 return  raw_string( l & 0xff,
		     	    (l >> 8) & 0xff,
		            (l >> 16) & 0xff,
		            (l >> 24)   & 0xff);
}


function getdword(blob, pos)
{
 local_var l, s;
 if ( strlen(blob) < pos + 4 )
	return NULL;

 s = substr(blob, pos, pos + 3);
 if ( ByteOrder == BYTE_ORDER_BIG_ENDIAN )
  return ord(s[0]) << 24 | ord(s[1]) << 16 | ord(s[2]) << 8 | ord(s[3]);
 else
  return ord(s[0]) | ord(s[1]) << 8 | ord(s[2]) << 16 | ord(s[3]) << 24;
}

function getword(blob, pos)
{
 local_var l, s;
 if ( strlen(blob) < pos + 2 )
	return NULL;
 s = substr(blob, pos, pos + 1);
 if ( ByteOrder == BYTE_ORDER_BIG_ENDIAN )
  return ord(s[0]) << 8 | ord(s[1]);
 else
  return ord(s[0]) | ord(s[1]) << 8;
}

function getbyte(blob, pos)
{
 local_var l, s;
 if ( strlen(blob) < pos + 1 )
	return NULL;
 s = substr(blob, pos, pos);
 return ord(s[0]);
}




function mkpad()
{
 local_var l;
 l = _FCT_ANON_ARGS[0];
 return crap(data:raw_string(0), length:l);
}





function mkipaddr()
{
 local_var ip;
 local_var str;

 ip = _FCT_ANON_ARGS[0];
 str = split(ip, sep:'.', keep:FALSE);
 return raw_string(int(str[0]), int(str[1]), int(str[2]), int(str[3])); 
}


function is_class_b(a,b)
{
 local_var aa, ab;
 local_var i;

 aa = split(a, sep:'.', keep:FALSE);
 ab = split(b, sep:'.', keep:FALSE);
 
 for ( i = 0 ; i < 4 ; i ++ )
 {
   if ( aa[i] != ab[i] ) break;
 }

 if ( i < 2 ) return FALSE;
 else return TRUE;
}


function arp_ping()
{
 local_var broadcast, macaddr, arp, ethernet, i, r, srcip, dstmac;

 broadcast = crap(data:raw_string(0xff), length:6);
 macaddr   = get_local_mac_addr();

 if ( ! macaddr ) return 0;  # Not an ethernet interface

 arp       = mkword(0x0806); 
 ethernet = broadcast + macaddr + arp;
 arp      = ethernet +              			# Ethernet
           mkword(0x0001) +        			# Hardware Type
           mkword(0x0800) +        			# Protocol Type
           mkbyte(0x06)   +        			# Hardware Size
           mkbyte(0x04)   +        			# Protocol Size
           mkword(0x0001) +        			# Opcode (Request)
           macaddr        +        			# Sender mac addr
           mkipaddr(this_host()) + 			# Sender IP addr
           crap(data:raw_string(0), length:6) + 	# Target Mac Addr
           mkipaddr(get_host_ip());

 for ( i = 0 ; i < 2 ; i ++ )
 {
  r = inject_packet(packet:arp, filter:"arp and arp[7] = 2 and src host " + get_host_ip(), timeout:1);
  if ( ! r || strlen(r) <= 31 ) continue;
  srcip = substr(r, 28, 31);
  if ( srcip == mkipaddr(get_host_ip() ) )
   {
    dstmac = substr(r, 6, 11);
    dstmac = strcat(hexstr(dstmac[0]), ":",
	            hexstr(dstmac[1]), ":",
		    hexstr(dstmac[2]), ":",
		    hexstr(dstmac[3]), ":",
		    hexstr(dstmac[4]), ":",
		    hexstr(dstmac[5]));
    return dstmac;
   }
  }
}

# Nessus 3 only
if ( ! defined_func("inject_packet") ) exit(0);
if ( ! isnull(get_gw_mac_addr()) ) exit(0);

# If the target is officially in the same subnet, exit
if ( islocalnet() || TARGET_IS_IPV6 ) exit(0);

opt = get_kb_item("global_settings/thorough_tests");
if (! opt || "yes" >!< opt  )
	# If the target is not at least in the same class B, exit
	if ( ! is_class_b(a:this_host(), b:get_host_ip() ) ) exit(0);



if ( mac = arp_ping() )
{
 if ( mac == get_gw_mac_addr() ) exit(0); # Arp proxy
 replace_kb_item(name:"ARP/mac_addr", value:mac);
 security_note(port:0,extra:"The MAC address of the remote host is " + mac);
}

