#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25443);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-5578");
  script_bugtraq_id(24315);
  script_xref(name:"OSVDB", value:"35243");

  script_name(english:"BASE Authentication Bypass Vulnerability (2)");
  script_summary(english:"Tries to bypass authentication in BASE");

  desc = "
Synopsis :

The remote web server contains a PHP application that is prone to an
authentication bypass vulnerability. 

Description :

The remote host is running BASE, a web-based tool for analyzing alerts
from one or more SNORT sensors. 

The version of BASE installed on the remote host allows a remote
attacker to bypass authentication to various scripts. 

Note that successful exploitation of this issue requires that BASE be
configured to use its own authentication system. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2007-06/0031.html
http://www.nessus.org/u?cb637b72
http://sourceforge.net/project/shownotes.php?release_id=521723&group_id=103348

Solution :

Upgrade to BASE 1.3.8 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/base", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  url = string(dir, "/base_maintenance.php");

  # Check whether we get beyond the authentication check.
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # we gain access to the main form and...
    '<FORM METHOD="POST' >< res && 'ACTION="base_maintenance.php"' >< res &&
    # Use_Auth_System is enabled
    "302 Found" >< res && egrep(pattern:"^Location: .+/index\.php", string:res)
  )
  {
    security_hole(port);
    exit(0);
  }
}
