#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains an ASP script that allows uploading of
arbitrary files. 

Description :

The remote host contains BDPDT, a database abstraction layer used in
various add-on modules for DotNetNuke. 

The installed version of the BDPDT contains an ASP.NET script that
allows an unauthenticated attacker to gain control of the affected
host by allowing uploading arbitrary files with the
'UploadFilePopUp.aspx' script. 

See also :

http://www.dotnetnuke.com/Community/Blogs/tabid/825/EntryID/422/Default.aspx
http://forums.asp.net/thread/1276672.aspx
http://www.wwwcoder.com/Default.aspx?tabid=283&EntryID=723
http://www.wwwcoder.com/Default.aspx?tabid=283&EntryID=733

Solution :

Contact the vendor for a newer version of BDPDT. 

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(21747);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2006-3601");
  script_bugtraq_id(18522);

  script_name(english:"BDPDT Arbitrary File Upload Vulnerabily");
  script_summary(english:"Checks for BDPDT's uploadfilepopup.aspx");
 
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Check if the affected script exists.
script = "/DesktopModules/BDPDT/uploadfilepopup.aspx";
foreach dir (cgi_dirs())
{
  req = http_get(item:string(dir, script), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if it does.
  if (
    '<input name="cmdBrowse"' >< res &&
    '<a id="btnUploadFile"' >< res &&
    '<input type="hidden" name="__VIEWSTATE"' >< res
  )
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Nessus found the affected script available via the affected URL :\n",
      "\n",
      "  ", dir, script, "\n"
    );
    security_hole(port:port, data:report);
    exit(0);
  }
}
