#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31351);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-6016", "CVE-2007-6017");
  script_bugtraq_id(26904, 28008);
  script_xref(name:"milw0rm", value:"5205");
  script_xref(name:"Secunia", value:"27885");

  script_name(english:"Symantec Backup Exec Calendar ActiveX Control Multiple Vulnerabilities (SYM08-007)");
  script_summary(english:"Checks version of Calendar ActiveX control"); 
 
 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by
multiple vulnerabilities. 

Description :

The remote host contains the PVATLCalendar.PVCalendar.1 ActiveX
control distributed with Symantec Backup Exec for Windows Servers. 

The installed version of that control reportedly contains two
stack-based buffer overflows and allows for corrupting or saving
malicious script code and overwriting arbitrary files.  These issues
can be triggered by specially-crafted arguments to the '_DOWText0'... 
'_DOWText6' and '_MonthText0' ...  '_MonthText11' properties and then
calling the 'Save()' method. 

See also :

http://secunia.com/secunia_research/2007-101/advisory/
http://www.symantec.com/avcenter/security/Content/2008.02.29.html

Solution :

Apply the appropriate hotfix as discussed in the vendor advisory
above. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{22ACD16F-99EB-11D2-9BB3-00400561D975}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  # Check its version.
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"10.0.0.50") == TRUE)
  {
    report = NULL;
    if (report_paranoia > 1)
      report = string(
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Note, though, that Nessus did not check whether the 'kill' bit was\n",
        "set for the control's CLSID because of the Report Paranoia setting\n",
        "in effect when this scan was run.\n"
      );
    else if (activex_get_killbit(clsid:clsid) != TRUE)
      report = string(
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Moreover, its 'kill' bit is not set so it is accessible via Internet\n",
        "Explorer.\n"
      );
    if (report)
    {
      if (report_verbosity) security_hole(port:kb_smb_transport(), extra:report);
      else security_hole(kb_smb_transport());
    }
  }
}
activex_end();
