# bigip_web_version.nasl
#
# History:
#
# 1.00, 12/2/07
# - Initial release


if (description)
    {
    script_id(30216);
    script_version("$Revision: 1.1 $");
    name["english"]="F5 BIG-IP web management interface version";
    desc["english"]="
Synopsis :

The remote web server is a web management interface. 

Description :

An F5 BIG-IP web management interface is running on this port, and
Nessus has determined its software version. 

See also :

http://www.f5.com/products/big-ip/

Risk factor :

None";
    summary["english"]="Tests for F5 BIG-IP web interface version";
    family["english"]="Misc.";
    script_name(english:name["english"]);
    script_description(english:desc["english"]);
    script_summary(english:summary["english"]);
    script_family(english:family["english"]);
    script_category(ACT_GATHER_INFO);
    script_copyright(english:"This script is Copyright (c) 2007-2008 nnposter");
    script_dependencies("bigip_web_detect.nasl","http_login.nasl");
    script_require_keys("www/bigip");
    script_require_ports("Services/www",443);
    exit(0);
    }


include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


if (!get_kb_item("www/bigip")) exit(0);

port=get_http_port(default:443);
if (!get_tcp_port_state(port) || !get_kb_item("www/"+port+"/bigip")) exit(0);

url="/tmui/Control/jspmap/tmui/system/device/properties_general.jsp";
resp=http_keepalive_send_recv(port:port,
                              data:http_get(item:url,port:port),
                              embedded:TRUE);
if (!resp) exit(0);

resp=egrep(pattern:'title=["\']BIG-IP',string:resp,icase:TRUE);
match=eregmatch(pattern:'title=["\'](BIG-IP [^"\']+)',string:resp,icase:TRUE);
version=match[1];
if (!version) exit(0);

replace_or_set_kb_item(name:"www/"+port+"/bigip/version",value:version);
security_note(port:port,
              data:'The remote host is running the F5 BIG-IP web management version\n' + version, '\n');
